/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.resourceprovider;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.io.resource.IReadableResource;
import com.helger.io.resource.URLResource;
import com.helger.io.resourceprovider.IReadableResourceProvider;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.MalformedURLException;

@Immutable
public final class URLResourceProvider
implements IReadableResourceProvider {
    @Override
    public boolean supportsReading(@Nullable String string) {
        return URLResource.isExplicitURLResource(string);
    }

    @Override
    public IReadableResource getReadableResource(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"URL");
        try {
            return new URLResource(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Passed name '" + string + "' is not a URL!", malformedURLException);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object != null && this.getClass().equals(object.getClass());
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

