/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.file;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringCount;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.ICommonsIterableIterator;
import com.helger.collection.commons.ICommonsList;
import com.helger.io.file.FileHelper;
import java.io.File;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class FileSystemRecursiveIterator
implements ICommonsIterableIterator<File> {
    private final int m_nStartLevel;
    private int m_nLevel = 0;
    private final Predicate<File> m_aRecursionFilter;
    private final ICommonsList<File> m_aFilesLeft;

    @Nonnegative
    private static int _getLevel(@NonNull File file) {
        return StringCount.getCharCount((String)file.getAbsolutePath(), (char)File.separatorChar);
    }

    public FileSystemRecursiveIterator(@NonNull String string) {
        this(new File(string), (Predicate<File>)null);
    }

    public FileSystemRecursiveIterator(@NonNull File file) {
        this(file, (Predicate<File>)null);
    }

    public FileSystemRecursiveIterator(@NonNull String string, @Nullable Predicate<File> predicate) {
        this(new File(string), predicate);
    }

    public FileSystemRecursiveIterator(@NonNull File file, @Nullable Predicate<File> predicate) {
        ValueEnforcer.notNull((Object)file, (String)"BaseDirectory");
        this.m_nStartLevel = FileSystemRecursiveIterator._getLevel(file);
        this.m_aRecursionFilter = predicate;
        this.m_aFilesLeft = FileHelper.getDirectoryContent(file);
    }

    @Nonnegative
    public int getStartLevel() {
        return this.m_nStartLevel;
    }

    public @Nullable Predicate<File> getRecursionFilter() {
        return this.m_aRecursionFilter;
    }

    public final boolean hasNext() {
        return this.m_aFilesLeft.isNotEmpty();
    }

    @OverrideOnDemand
    protected boolean recurseIntoDirectory(@NonNull File file) {
        return this.m_aRecursionFilter == null || this.m_aRecursionFilter.test(file);
    }

    public final @NonNull File next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        File file = (File)this.m_aFilesLeft.removeFirstOrNull();
        this.m_nLevel = FileSystemRecursiveIterator._getLevel(file) - this.m_nStartLevel;
        if (file.isDirectory() && this.recurseIntoDirectory(file)) {
            this.m_aFilesLeft.addAll(0, FileHelper.getDirectoryContent(file));
        }
        return file;
    }

    @Nonnegative
    public final int getLevel() {
        return this.m_nLevel;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("FilesLeft", this.m_aFilesLeft).getToString();
    }
}

