/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.id.factory;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.ELockType;
import com.helger.annotation.concurrent.MustBeLocked;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.id.factory.AbstractPersistingIntIDFactory;
import com.helger.base.string.StringParser;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.io.file.EFileIOErrorCode;
import com.helger.io.file.EFileIOOperation;
import com.helger.io.file.FileHelper;
import com.helger.io.file.FileIOError;
import com.helger.io.file.FileOperationManager;
import com.helger.io.file.SimpleFileIO;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jspecify.annotations.NonNull;

@ThreadSafe
public class FileIntIDFactory
extends AbstractPersistingIntIDFactory {
    public static final Charset CHARSET_TO_USE = StandardCharsets.ISO_8859_1;
    public static final int DEFAULT_RESERVE_COUNT = 20;
    private final File m_aFile;
    private final File m_aPrevFile;
    private final File m_aNewFile;

    public FileIntIDFactory(@NonNull File file) {
        this(file, 20);
    }

    public FileIntIDFactory(@NonNull File file, @Nonnegative int n) {
        super(n);
        ValueEnforcer.notNull((Object)file, (String)"File");
        this.m_aFile = file;
        this.m_aPrevFile = new File(file.getParentFile(), file.getName() + ".prev");
        this.m_aNewFile = new File(file.getParentFile(), file.getName() + ".new");
        if (!FileHelper.canReadAndWriteFile(this.m_aFile)) {
            throw new IllegalArgumentException("Cannot read and/or write the file " + String.valueOf(this.m_aFile) + "!");
        }
        if (!FileHelper.canReadAndWriteFile(this.m_aPrevFile)) {
            throw new IllegalArgumentException("Cannot read and/or write the file " + String.valueOf(this.m_aPrevFile) + "!");
        }
        if (!FileHelper.canReadAndWriteFile(this.m_aNewFile)) {
            throw new IllegalArgumentException("Cannot read and/or write the file " + String.valueOf(this.m_aNewFile) + "!");
        }
        if (this.m_aNewFile.exists()) {
            throw new IllegalStateException("The temporary ID file '" + this.m_aNewFile.getAbsolutePath() + "' already exists! Please use the file with the highest number. Please resolve this conflict manually.");
        }
        if (this.m_aPrevFile.exists()) {
            throw new IllegalStateException("The temporary ID file '" + this.m_aPrevFile.getAbsolutePath() + "' already exists! If the ID file '" + this.m_aFile.getAbsolutePath() + "' exists and contains a higher number, you may consider deleting this file. Please resolve this conflict manually.");
        }
    }

    public final @NonNull File getFile() {
        return this.m_aFile;
    }

    @MustBeLocked(value=ELockType.WRITE)
    protected final int readAndUpdateIDCounter(@Nonnegative int n) {
        FileIOError fileIOError;
        String string = SimpleFileIO.getFileAsString(this.m_aFile, CHARSET_TO_USE);
        int n2 = string != null ? StringParser.parseInt((String)string.trim(), (int)0) : 0;
        SimpleFileIO.writeFile(this.m_aNewFile, Integer.toString(n2 + n), CHARSET_TO_USE);
        boolean bl = false;
        if (this.m_aFile.exists()) {
            fileIOError = FileOperationManager.INSTANCE.renameFile(this.m_aFile, this.m_aPrevFile);
            bl = true;
        } else {
            fileIOError = new FileIOError(EFileIOOperation.RENAME_FILE, EFileIOErrorCode.NO_ERROR);
        }
        if (fileIOError.isSuccess()) {
            fileIOError = FileOperationManager.INSTANCE.renameFile(this.m_aNewFile, this.m_aFile);
            if (fileIOError.isSuccess()) {
                fileIOError = FileOperationManager.INSTANCE.deleteFileIfExisting(this.m_aPrevFile);
            } else if (bl) {
                FileOperationManager.INSTANCE.renameFile(this.m_aPrevFile, this.m_aFile);
            }
        }
        if (fileIOError.isFailure()) {
            throw new IllegalStateException("Error on rename(existing-old)/rename(new-existing)/delete(old): " + String.valueOf(fileIOError));
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        FileIntIDFactory fileIntIDFactory = (FileIntIDFactory)((Object)object);
        return this.m_aFile.equals(fileIntIDFactory.m_aFile);
    }

    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_aFile).getHashCode();
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("file", (Object)this.m_aFile).getToString();
    }
}

