/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.provider;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.io.EAppend;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.io.provider.FileSystemByteStreamProvider;
import com.helger.io.provider.IInputStreamProvider;
import com.helger.io.provider.IOutputStreamProvider;
import com.helger.io.provider.IReaderProvider;
import com.helger.io.provider.IWriterProvider;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class FileSystemCharStreamProvider
implements IInputStreamProvider,
IOutputStreamProvider,
IReaderProvider,
IWriterProvider {
    private final FileSystemByteStreamProvider m_aByteStreamResolver;
    private final Charset m_aCharset;

    public FileSystemCharStreamProvider(@NonNull String string, @NonNull Charset charset) {
        this(new File(string), charset);
    }

    public FileSystemCharStreamProvider(@NonNull File file, @NonNull Charset charset) {
        this.m_aByteStreamResolver = new FileSystemByteStreamProvider(file);
        this.m_aCharset = (Charset)ValueEnforcer.notNull((Object)charset, (String)"Charset");
    }

    public @NonNull File getBasePath() {
        return this.m_aByteStreamResolver.getBasePath();
    }

    public @NonNull Charset getCharset() {
        return this.m_aCharset;
    }

    @Override
    public @Nullable InputStream getInputStream(@NonNull String string) {
        return this.m_aByteStreamResolver.getInputStream(string);
    }

    @Override
    public @Nullable OutputStream getOutputStream(@NonNull String string, @NonNull EAppend eAppend) {
        return this.m_aByteStreamResolver.getOutputStream(string, eAppend);
    }

    @Override
    public @Nullable Reader getReader(@NonNull String string) {
        return StreamHelper.createReader((InputStream)this.getInputStream(string), (Charset)this.m_aCharset);
    }

    @Override
    public @Nullable Writer getWriter(@NonNull String string, @NonNull EAppend eAppend) {
        return StreamHelper.createWriter((OutputStream)this.getOutputStream(string, eAppend), (Charset)this.m_aCharset);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FileSystemCharStreamProvider fileSystemCharStreamProvider = (FileSystemCharStreamProvider)object;
        return this.m_aByteStreamResolver.equals(fileSystemCharStreamProvider.m_aByteStreamResolver) && this.m_aCharset.equals(fileSystemCharStreamProvider.m_aCharset);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aByteStreamResolver).append((Object)this.m_aCharset).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("byteStreamResolver", (Object)this.m_aByteStreamResolver).append("charset", (Object)this.m_aCharset).getToString();
    }
}

