/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.relative;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.exception.InitializationException;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.timing.StopWatch;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.io.file.FileOperationManager;
import com.helger.io.file.FileSystemRecursiveIterator;
import com.helger.io.relative.IFileRelativeIO;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class FileRelativeIO
implements IFileRelativeIO {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileRelativeIO.class);
    private final File m_aBasePath;

    public static void internalCheckAccessRights(@NonNull File file) {
        StopWatch stopWatch = StopWatch.createdStarted();
        LOGGER.info("Checking file access in " + String.valueOf(file));
        int n = 0;
        int n2 = 0;
        Iterator iterator = new FileSystemRecursiveIterator(file).iterator();
        while (iterator.hasNext()) {
            File file2 = (File)iterator.next();
            if (file2.isFile()) {
                if (!file2.canRead()) {
                    throw new IllegalArgumentException("Cannot read file " + String.valueOf(file2));
                }
                if (!file2.canWrite()) {
                    LOGGER.warn("Cannot write file " + String.valueOf(file2));
                }
                ++n;
                continue;
            }
            if (file2.isDirectory()) {
                if (!file2.canRead()) {
                    throw new IllegalArgumentException("Cannot read in directory " + String.valueOf(file2));
                }
                if (!file2.canWrite()) {
                    LOGGER.warn("Cannot write in directory " + String.valueOf(file2));
                }
                if (!file2.canExecute()) {
                    LOGGER.warn("Cannot execute in directory " + String.valueOf(file2));
                }
                ++n2;
                continue;
            }
            LOGGER.warn("Neither file nor directory: " + String.valueOf(file2));
        }
        LOGGER.info("Finished checking file access for " + n + " files and " + n2 + " directories in " + stopWatch.stopAndGetMillis() + " milliseconds");
    }

    public FileRelativeIO(@NonNull File file) {
        ValueEnforcer.notNull((Object)file, (String)"BasePath");
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("Please provide an absolute path: " + String.valueOf(file));
        }
        FileOperationManager.INSTANCE.createDirRecursiveIfNotExisting(file);
        if (!file.isDirectory()) {
            throw new InitializationException("The passed base path " + String.valueOf(file) + " exists but is not a directory!");
        }
        try {
            this.m_aBasePath = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public @NonNull File getBasePathFile() {
        return this.m_aBasePath;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FileRelativeIO fileRelativeIO = (FileRelativeIO)object;
        return this.m_aBasePath.equals(fileRelativeIO.m_aBasePath);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aBasePath).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("BasePath", (Object)this.m_aBasePath).getToString();
    }

    public static @NonNull FileRelativeIO createForCurrentDir() {
        return new FileRelativeIO(new File(".").getAbsoluteFile());
    }
}

