/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.relative;

import com.helger.annotation.Nonempty;
import com.helger.base.io.EAppend;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.state.ESuccess;
import com.helger.io.file.FileIOError;
import com.helger.io.file.FileOperationManager;
import com.helger.io.file.FilenameHelper;
import com.helger.io.relative.IPathRelativeIO;
import com.helger.io.resource.FileSystemResource;
import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface IFileRelativeIO
extends IPathRelativeIO {
    public @NonNull File getBasePathFile();

    @Override
    @Nonempty
    default public @NonNull String getBasePath() {
        return this.getBasePathFile().getAbsolutePath();
    }

    default public @NonNull File getFile(@NonNull String string) {
        return new File(this.getBasePathFile(), string);
    }

    @Override
    default public @NonNull FileSystemResource getResource(@NonNull String string) {
        return new FileSystemResource(this.getFile(string));
    }

    default public @Nullable String getRelativeFilename(@NonNull File file) {
        return FilenameHelper.getRelativeToParentDirectory(file, this.getBasePathFile());
    }

    default public boolean existsFile(@NonNull String string) {
        return this.getFile(string).isFile();
    }

    default public boolean existsDir(@NonNull String string) {
        return this.getFile(string).isDirectory();
    }

    default public @Nullable OutputStream getOutputStream(@NonNull String string) {
        return this.getOutputStream(string, EAppend.TRUNCATE);
    }

    default public @Nullable OutputStream getOutputStream(@NonNull String string, @NonNull EAppend eAppend) {
        return this.getResource(string).getOutputStream(eAppend);
    }

    default public @Nullable Writer getWriter(@NonNull String string, @NonNull Charset charset) {
        return this.getWriter(string, charset, EAppend.TRUNCATE);
    }

    default public @Nullable Writer getWriter(@NonNull String string, @NonNull Charset charset, @NonNull EAppend eAppend) {
        return this.getResource(string).getWriter(charset, eAppend);
    }

    default public @NonNull FileIOError createDirectory(@NonNull String string, boolean bl) {
        File file = this.getFile(string);
        return bl ? FileOperationManager.INSTANCE.createDirRecursiveIfNotExisting(file) : FileOperationManager.INSTANCE.createDirIfNotExisting(file);
    }

    default public @NonNull FileIOError deleteDirectory(@NonNull String string, boolean bl) {
        File file = this.getFile(string);
        return bl ? FileOperationManager.INSTANCE.deleteDirRecursive(file) : FileOperationManager.INSTANCE.deleteDir(file);
    }

    default public @NonNull FileIOError deleteDirectoryIfExisting(@NonNull String string, boolean bl) {
        File file = this.getFile(string);
        return bl ? FileOperationManager.INSTANCE.deleteDirRecursiveIfExisting(file) : FileOperationManager.INSTANCE.deleteDirIfExisting(file);
    }

    default public @NonNull FileIOError deleteFile(@NonNull String string) {
        return FileOperationManager.INSTANCE.deleteFile(this.getFile(string));
    }

    default public @NonNull FileIOError deleteFileIfExisting(@NonNull String string) {
        return FileOperationManager.INSTANCE.deleteFileIfExisting(this.getFile(string));
    }

    default public @NonNull FileIOError renameDir(@NonNull String string, @NonNull String string2) {
        File file = this.getFile(string);
        File file2 = this.getFile(string2);
        return FileOperationManager.INSTANCE.renameDir(file, file2);
    }

    default public @NonNull FileIOError renameFile(@NonNull String string, @NonNull String string2) {
        File file = this.getFile(string);
        File file2 = this.getFile(string2);
        return FileOperationManager.INSTANCE.renameFile(file, file2);
    }

    default public @NonNull ESuccess writeFile(@NonNull String string, @NonNull EAppend eAppend, @NonNull byte[] byArray) {
        OutputStream outputStream = this.getOutputStream(string, eAppend);
        if (outputStream == null) {
            return ESuccess.FAILURE;
        }
        return StreamHelper.writeStream((OutputStream)outputStream, (byte[])byArray);
    }

    default public @NonNull ESuccess saveFile(@NonNull String string, @NonNull String string2, @NonNull Charset charset) {
        return this.saveFile(string, string2.getBytes(charset));
    }

    default public @NonNull ESuccess saveFile(@NonNull String string, byte[] byArray) {
        return this.writeFile(string, EAppend.TRUNCATE, byArray);
    }

    default public @NonNull ESuccess appendFile(@NonNull String string, @NonNull String string2, @NonNull Charset charset) {
        return this.appendFile(string, string2.getBytes(charset));
    }

    default public @NonNull ESuccess appendFile(@NonNull String string, @NonNull byte[] byArray) {
        return this.writeFile(string, EAppend.APPEND, byArray);
    }
}

