/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.resource;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.io.EAppend;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.io.file.FileHelper;
import com.helger.io.file.FilenameHelper;
import com.helger.io.resource.IReadWriteResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class FileSystemResource
implements IReadWriteResource {
    private final File m_aFile;
    private final String m_sPath;
    private int m_nHashCode = 0;

    public FileSystemResource(@NonNull URI uRI) {
        this(new File(uRI));
    }

    public FileSystemResource(@NonNull String string, @NonNull String string2) {
        this(new File(string, string2));
    }

    public FileSystemResource(@NonNull String string) {
        this(new File(string));
    }

    public FileSystemResource(@NonNull File file, String string) {
        this(new File(file, string));
    }

    public FileSystemResource(@NonNull File file) {
        ValueEnforcer.notNull((Object)file, (String)"File");
        String string = FilenameHelper.getCleanPath(file.getAbsolutePath());
        this.m_aFile = new File(string);
        this.m_sPath = this.m_aFile.getAbsolutePath();
    }

    public FileSystemResource(@NonNull Path path) {
        this(path.toFile());
    }

    @Override
    public @NonNull String getResourceID() {
        return this.getPath();
    }

    @Override
    public @NonNull String getPath() {
        return this.m_sPath;
    }

    public @Nullable FileInputStream getInputStream() {
        return FileHelper.getInputStream(this.m_aFile);
    }

    public @Nullable Reader getReader(@NonNull Charset charset) {
        return FileHelper.getReader(this.m_aFile, charset);
    }

    public final boolean isReadMultiple() {
        return true;
    }

    public @Nullable FileOutputStream getOutputStream(@NonNull EAppend eAppend) {
        return FileHelper.getOutputStream(this.m_aFile, eAppend);
    }

    public @Nullable Writer getWriter(@NonNull Charset charset, @NonNull EAppend eAppend) {
        return FileHelper.getWriter(this.m_aFile, eAppend, charset);
    }

    public final boolean isWriteMultiple() {
        return true;
    }

    @Override
    public boolean exists() {
        return this.m_aFile.exists();
    }

    @Override
    public @Nullable URL getAsURL() {
        return FileHelper.getAsURL(this.m_aFile);
    }

    @Override
    public @NonNull File getAsFile() {
        return this.m_aFile;
    }

    @Override
    public @NonNull FileSystemResource getReadableCloneForPath(@NonNull String string) {
        return new FileSystemResource(string);
    }

    @Override
    public @NonNull FileSystemResource getWritableCloneForPath(@NonNull String string) {
        return new FileSystemResource(string);
    }

    public boolean canRead() {
        return this.m_aFile.canRead();
    }

    public boolean canWrite() {
        return this.m_aFile.canWrite();
    }

    public boolean canExecute() {
        return this.m_aFile.canExecute();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FileSystemResource fileSystemResource = (FileSystemResource)object;
        return this.m_aFile.equals(fileSystemResource.m_aFile);
    }

    public int hashCode() {
        int n = this.m_nHashCode;
        if (n == 0) {
            n = this.m_nHashCode = new HashCodeGenerator((Object)this).append((Object)this.m_aFile).getHashCode();
        }
        return n;
    }

    public String toString() {
        return new ToStringGenerator(null).append("file", (Object)this.m_aFile).getToString();
    }
}

