/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.resource.wrapped;

import com.helger.io.resource.IReadableResource;
import com.helger.io.resource.wrapped.AbstractWrappedReadableResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class GZIPReadableResource
extends AbstractWrappedReadableResource {
    public GZIPReadableResource(@NonNull IReadableResource iReadableResource) {
        super(iReadableResource);
    }

    public @Nullable InputStream getInputStream() {
        InputStream inputStream = this.getWrappedReadableResource().getInputStream();
        if (inputStream == null) {
            return null;
        }
        try {
            return new GZIPInputStream(inputStream);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to open GZIP InputStream", iOException);
        }
    }

    @Override
    public @NonNull GZIPReadableResource getReadableCloneForPath(@NonNull String string) {
        return new GZIPReadableResource(this.getWrappedReadableResource().getReadableCloneForPath(string));
    }
}

