/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.stream;

import com.helger.statistics.api.IMutableStatisticsHandlerCounter;
import com.helger.statistics.api.IMutableStatisticsHandlerSize;
import com.helger.statistics.impl.StatisticsManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jspecify.annotations.NonNull;

public class CountingFileInputStream
extends FileInputStream {
    private static final IMutableStatisticsHandlerSize STATS_READ_SIZE = StatisticsManager.getSizeHandler((String)(CountingFileInputStream.class.getName() + "$read.bytes"));
    private static final IMutableStatisticsHandlerCounter STATS_READ_FILES = StatisticsManager.getCounterHandler((String)(CountingFileInputStream.class.getName() + "$read.files"));

    public CountingFileInputStream(@NonNull File file) throws FileNotFoundException {
        super(file);
        STATS_READ_FILES.increment();
    }

    public CountingFileInputStream(@NonNull String string) throws FileNotFoundException {
        super(string);
        STATS_READ_FILES.increment();
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            STATS_READ_SIZE.addSize(1L);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = super.read(byArray);
        if (n > -1) {
            STATS_READ_SIZE.addSize((long)n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 > -1) {
            STATS_READ_SIZE.addSize((long)n3);
        }
        return n3;
    }
}

