/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.stream;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.WillClose;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.nonblocking.NonBlockingBufferedReader;
import com.helger.base.io.stream.StreamHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class StreamHelperExt
extends StreamHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamHelperExt.class);
    private static final StreamHelperExt INSTANCE = new StreamHelperExt();

    private StreamHelperExt() {
    }

    @ReturnsMutableCopy
    public static @Nullable ICommonsList<String> readStreamLines(@Nullable IHasInputStream iHasInputStream, @NonNull Charset charset) {
        return StreamHelperExt.readStreamLines(iHasInputStream, charset, 0, -1);
    }

    @ReturnsMutableCopy
    public static @Nullable ICommonsList<String> readStreamLines(@Nullable IHasInputStream iHasInputStream, @NonNull Charset charset, @Nonnegative int n, @CheckForSigned int n2) {
        if (iHasInputStream == null) {
            return null;
        }
        return StreamHelperExt.readStreamLines(iHasInputStream.getInputStream(), charset, n, n2);
    }

    @ReturnsMutableCopy
    public static @Nullable ICommonsList<String> readStreamLines(@WillClose @Nullable InputStream inputStream, @Nonempty @NonNull Charset charset) {
        return StreamHelperExt.readStreamLines(inputStream, charset, 0, -1);
    }

    public static void readStreamLines(@WillClose @Nullable InputStream inputStream, @NonNull Charset charset, @NonNull List<String> list) {
        if (inputStream != null) {
            StreamHelperExt.readStreamLines(inputStream, charset, 0, -1, list::add);
        }
    }

    @ReturnsMutableCopy
    public static @Nullable ICommonsList<String> readStreamLines(@WillClose @Nullable InputStream inputStream, @NonNull Charset charset, @Nonnegative int n, @CheckForSigned int n2) {
        if (inputStream == null) {
            return null;
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        StreamHelperExt.readStreamLines(inputStream, charset, n, n2, arg_0 -> ((ICommonsList)commonsArrayList).add(arg_0));
        return commonsArrayList;
    }

    public static void readStreamLines(@WillClose @Nullable InputStream inputStream, @Nonempty @NonNull Charset charset, @NonNull Consumer<? super String> consumer) {
        if (inputStream != null) {
            StreamHelperExt.readStreamLines(inputStream, charset, 0, -1, consumer);
        }
    }

    private static void _readFromReader(int n, int n2, @NonNull Consumer<? super String> consumer, boolean bl, @NonNull NonBlockingBufferedReader nonBlockingBufferedReader) throws IOException {
        String string;
        int n3;
        for (n3 = 0; n3 < n && (string = nonBlockingBufferedReader.readLine()) != null; ++n3) {
        }
        if (bl) {
            while ((string = nonBlockingBufferedReader.readLine()) != null) {
                consumer.accept(string);
            }
        } else {
            n3 = 0;
            while ((string = nonBlockingBufferedReader.readLine()) != null) {
                consumer.accept(string);
                if (++n3 < n2) continue;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readStreamLines(@WillClose @Nullable InputStream inputStream, @Nonempty @NonNull Charset charset, @Nonnegative int n, int n2, @NonNull Consumer<? super String> consumer) {
        block10: {
            try {
                ValueEnforcer.notNull((Object)charset, (String)"Charset");
                ValueEnforcer.isGE0((int)n, (String)"LinesToSkip");
                boolean bl = n2 == -1;
                ValueEnforcer.isTrue((bl || n2 >= 0 ? 1 : 0) != 0, () -> "Line count may not be that negative: " + n2);
                ValueEnforcer.notNull(consumer, (String)"LineCallback");
                if (inputStream == null || !bl && n2 <= 0) break block10;
                try (NonBlockingBufferedReader nonBlockingBufferedReader = new NonBlockingBufferedReader((Reader)StreamHelperExt.createReader((InputStream)inputStream, (Charset)charset));){
                    StreamHelperExt._readFromReader(n, n2, consumer, bl, nonBlockingBufferedReader);
                }
                catch (IOException iOException) {
                    LOGGER.error("Failed to read from reader", (Throwable)StreamHelperExt.internalGetPropagatableException((Exception)iOException));
                }
            }
            finally {
                StreamHelperExt.close((AutoCloseable)inputStream);
            }
        }
    }
}

