/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.typeconvert;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.IsSPIImplementation;
import com.helger.base.io.EAppend;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.iface.IHasOutputStream;
import com.helger.base.io.iface.IHasReader;
import com.helger.base.io.iface.IHasWriter;
import com.helger.base.url.URLHelper;
import com.helger.io.resource.ClassPathResource;
import com.helger.io.resource.FileSystemResource;
import com.helger.io.resource.IResourceBase;
import com.helger.io.resource.URLResource;
import com.helger.typeconvert.ITypeConverterRegistrarSPI;
import com.helger.typeconvert.ITypeConverterRegistry;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jspecify.annotations.NonNull;

@IsSPIImplementation
@Immutable
public final class IOTypeConverterRegistrar
implements ITypeConverterRegistrarSPI {
    public void registerTypeConverter(@NonNull ITypeConverterRegistry iTypeConverterRegistry) {
        iTypeConverterRegistry.registerTypeConverter(File.class, String.class, File::getAbsolutePath);
        iTypeConverterRegistry.registerTypeConverter(File.class, URI.class, File::toURI);
        iTypeConverterRegistry.registerTypeConverter(File.class, URL.class, file -> URLHelper.getAsURL((URI)file.toURI()));
        iTypeConverterRegistry.registerTypeConverter(URI.class, File.class, File::new);
        iTypeConverterRegistry.registerTypeConverter(URI.class, URL.class, URLHelper::getAsURL);
        iTypeConverterRegistry.registerTypeConverter(URL.class, String.class, URL::toExternalForm);
        iTypeConverterRegistry.registerTypeConverter(URL.class, File.class, uRL -> {
            try {
                return new File(uRL.toURI().getSchemeSpecificPart());
            }
            catch (URISyntaxException uRISyntaxException) {
                return new File(uRL.getPath());
            }
        });
        iTypeConverterRegistry.registerTypeConverter(URL.class, URI.class, URLHelper::getAsURI);
        iTypeConverterRegistry.registerTypeConverter(String.class, File.class, File::new);
        iTypeConverterRegistry.registerTypeConverter(String.class, URI.class, URLHelper::getAsURI);
        iTypeConverterRegistry.registerTypeConverter(String.class, URL.class, URLHelper::getAsURL);
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(IResourceBase.class, String.class, IResourceBase::getPath);
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(IResourceBase.class, URL.class, IResourceBase::getAsURL);
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(IResourceBase.class, File.class, IResourceBase::getAsFile);
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(IHasInputStream.class, InputStream.class, IHasInputStream::getInputStream);
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(IHasOutputStream.class, OutputStream.class, iHasOutputStream -> iHasOutputStream.getOutputStream(EAppend.DEFAULT));
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(IHasReader.class, Reader.class, IHasReader::getReader);
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(IHasWriter.class, Writer.class, IHasWriter::getWriter);
        iTypeConverterRegistry.registerTypeConverter(String.class, ClassPathResource.class, ClassPathResource::new);
        iTypeConverterRegistry.registerTypeConverter(URL.class, ClassPathResource.class, ClassPathResource::new);
        iTypeConverterRegistry.registerTypeConverter(String.class, FileSystemResource.class, FileSystemResource::new);
        iTypeConverterRegistry.registerTypeConverter(URL.class, FileSystemResource.class, uRL -> {
            try {
                URI uRI = uRL.toURI();
                return new FileSystemResource(uRI);
            }
            catch (IllegalArgumentException | URISyntaxException exception) {
                return null;
            }
        });
        iTypeConverterRegistry.registerTypeConverter(String.class, URLResource.class, string -> {
            try {
                return new URLResource((String)string);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        });
        iTypeConverterRegistry.registerTypeConverter(URL.class, URLResource.class, URLResource::new);
        iTypeConverterRegistry.registerTypeConverter(URI.class, URLResource.class, uRI -> {
            try {
                return new URLResource((URI)uRI);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        });
    }
}

