/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.adapter;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.datetime.OffsetDate;
import com.helger.commons.datetime.PDTWebDateHelper;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdapterOffsetDate
extends XmlAdapter<String, OffsetDate> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdapterOffsetDate.class);
    private static Function<LocalDate, ZoneOffset> s_aZOSupplier = localDate -> ZoneOffset.UTC;

    @Nonnull
    public static Function<LocalDate, ZoneOffset> getFallbackZoneOffsetSupplier() {
        return s_aZOSupplier;
    }

    @Nonnull
    public static void setFallbackZoneOffsetSupplier(@Nonnull Function<LocalDate, ZoneOffset> function) {
        ValueEnforcer.notNull(function, (String)"ZoneOffsetSupplier");
        s_aZOSupplier = function;
    }

    public OffsetDate unmarshal(@Nullable String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        OffsetDate offsetDate = PDTWebDateHelper.getOffsetDateFromXSD((String)string2);
        if (offsetDate == null) {
            LocalDate localDate = PDTWebDateHelper.getLocalDateFromXSD((String)string2);
            if (localDate != null) {
                offsetDate = OffsetDate.of((LocalDate)localDate, (ZoneOffset)AdapterOffsetDate.getFallbackZoneOffsetSupplier().apply(localDate));
            } else if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Failed to parse '" + string + "' to an OffsetDate");
            }
        }
        return offsetDate;
    }

    public String marshal(@Nullable OffsetDate offsetDate) {
        return PDTWebDateHelper.getAsStringXSD((OffsetDate)offsetDate);
    }
}

