/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ClassLoaderHelper;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.annotation.XmlSchema;
import java.lang.ref.WeakReference;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
@MustImplementEqualsAndHashcode
public class JAXBContextCacheKey {
    private static final Logger LOGGER = LoggerFactory.getLogger(JAXBContextCacheKey.class);
    private final Package m_aPackage;
    private final WeakReference<ClassLoader> m_aClassLoader;
    private final ICommonsList<WeakReference<Class<?>>> m_aClasses;
    private final Map<String, ?> m_aProperties;
    private final String m_sEqualsHashCodeKey;

    public JAXBContextCacheKey(@Nonnull Package package_, @Nullable ClassLoader classLoader) {
        ValueEnforcer.notNull((Object)package_, (String)"Package");
        this.m_aPackage = package_;
        this.m_aClassLoader = new WeakReference<ClassLoader>(classLoader);
        this.m_aClasses = null;
        this.m_aProperties = null;
        this.m_sEqualsHashCodeKey = this.m_aPackage.getName();
    }

    public JAXBContextCacheKey(@Nonnull ICommonsList<Class<?>> iCommonsList, @Nullable Map<String, ?> map) {
        ValueEnforcer.notEmptyNoNullValue(iCommonsList, (String)"Classes");
        this.m_aPackage = null;
        this.m_aClassLoader = null;
        this.m_aClasses = new CommonsArrayList(iCommonsList, WeakReference::new);
        this.m_aProperties = new CommonsHashMap(map);
        this.m_sEqualsHashCodeKey = StringHelper.getImplodedMapped((char)':', iCommonsList, Class::getName);
    }

    @Nullable
    @ReturnsMutableCopy
    private ICommonsList<Class<?>> _getAllClasses() {
        CommonsArrayList commonsArrayList = null;
        if (this.m_aClasses != null) {
            commonsArrayList = new CommonsArrayList();
            for (WeakReference weakReference : this.m_aClasses) {
                Class clazz = (Class)weakReference.get();
                if (clazz == null) continue;
                commonsArrayList.add((Object)clazz);
            }
        }
        return commonsArrayList;
    }

    @Nullable
    private final ClassLoader _getClassLoader() {
        ClassLoader classLoader = null;
        if (this.m_aClassLoader != null) {
            classLoader = (ClassLoader)this.m_aClassLoader.get();
        }
        return classLoader != null ? classLoader : ClassLoaderHelper.getDefaultClassLoader();
    }

    @Nonnull
    private JAXBContext _createFromPackageAndClassLoader(boolean bl) {
        ClassLoader classLoader = this._getClassLoader();
        if (!bl && LOGGER.isInfoEnabled()) {
            LOGGER.info("Creating JAXB context for package " + this.m_aPackage.getName() + " using ClassLoader " + classLoader.toString());
        }
        try {
            if (this.m_aPackage.getAnnotation(XmlSchema.class) == null && GenericReflection.getClassFromNameSafe((String)(this.m_aPackage.getName() + ".ObjectFactory")) == null) {
                LOGGER.warn("The package " + this.m_aPackage.getName() + " does not seem to be JAXB generated! Trying to create a JAXBContext anyway.");
            }
            return JAXBContext.newInstance((String)this.m_aPackage.getName(), (ClassLoader)classLoader);
        }
        catch (JAXBException jAXBException) {
            String string = "Failed to create JAXB context for package '" + this.m_aPackage.getName() + "' using ClassLoader " + classLoader;
            LOGGER.error(string + ": " + jAXBException.getMessage());
            throw new IllegalArgumentException(string, jAXBException);
        }
    }

    @Nonnull
    private JAXBContext _createFromClassesAndProperties(boolean bl) {
        ICommonsList<Class<?>> iCommonsList = this._getAllClasses();
        if (!bl && LOGGER.isInfoEnabled()) {
            LOGGER.info("Creating JAXB context for classes " + StringHelper.getImplodedMapped((String)", ", iCommonsList, clazz -> "'" + clazz.getName() + "'") + (String)(this.m_aProperties.isEmpty() ? "" : " with properties " + this.m_aProperties.keySet()));
        }
        try {
            Class[] classArray = (Class[])iCommonsList.toArray((Object[])ArrayHelper.EMPTY_CLASS_ARRAY);
            return JAXBContext.newInstance((Class[])classArray, this.m_aProperties);
        }
        catch (JAXBException jAXBException) {
            String string = "Failed to create JAXB context for classes " + StringHelper.getImplodedMapped((String)", ", iCommonsList, clazz -> "'" + clazz.getName() + "'") + (String)(this.m_aProperties.isEmpty() ? "" : " with properties " + this.m_aProperties.keySet());
            LOGGER.error(string + ": " + jAXBException.getMessage());
            throw new IllegalArgumentException(string, jAXBException);
        }
    }

    @Nonnull
    public JAXBContext createJAXBContext(boolean bl) {
        if (this.m_aPackage != null) {
            return this._createFromPackageAndClassLoader(bl);
        }
        return this._createFromClassesAndProperties(bl);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JAXBContextCacheKey jAXBContextCacheKey = (JAXBContextCacheKey)object;
        return this.m_sEqualsHashCodeKey.equals(jAXBContextCacheKey.m_sEqualsHashCodeKey) && EqualsHelper.equals((Object)this._getClassLoader(), (Object)jAXBContextCacheKey._getClassLoader()) && EqualsHelper.equals(this.m_aProperties, jAXBContextCacheKey.m_aProperties);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sEqualsHashCodeKey).append((Object)this._getClassLoader()).append(this.m_aProperties).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("Package", (Object)this.m_aPackage).appendIfNotNull("ClassLoader", this.m_aClassLoader).appendIfNotNull("Classes", this.m_aClasses).appendIfNotNull("Properties", this.m_aProperties).appendIfNotNull("EqualsHashCodeKey", (Object)this.m_sEqualsHashCodeKey).getToString();
    }
}

