/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.builder;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.builder.IJAXBDocumentType;
import com.helger.xml.schema.XMLSchemaCache;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchema;
import jakarta.xml.bind.annotation.XmlType;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.validation.Schema;

@Deprecated(forRemoval=true, since="11.0.3")
@NotThreadSafe
public class JAXBDocumentType
implements IJAXBDocumentType {
    public static final String JAXB_DEFAULT = "##default";
    private final Class<?> m_aClass;
    private final ICommonsList<ClassPathResource> m_aXSDs = new CommonsArrayList();
    private Supplier<XMLSchemaCache> m_aXMLSchemaCacheProvider = XMLSchemaCache::getInstance;
    private final String m_sNamespaceURI;
    private final String m_sLocalName;
    private Schema m_aCachedSchema;

    public JAXBDocumentType(@Nonnull Class<?> clazz, @Nullable List<? extends ClassPathResource> list, @Nullable Function<? super String, ? extends String> function) {
        String string;
        String string2;
        Package package_;
        Object object;
        ValueEnforcer.notNull(clazz, (String)"Class");
        if (list != null) {
            ValueEnforcer.notEmptyNoNullValue(list, (String)"XSDs");
            object = list.iterator();
            while (object.hasNext()) {
                package_ = (ClassPathResource)object.next();
                ValueEnforcer.isTrue((boolean)package_.hasClassLoader(), () -> JAXBDocumentType.lambda$new$0((ClassPathResource)package_));
            }
        }
        if ((object = clazz.getAnnotation(XmlType.class)) == null) {
            throw new IllegalArgumentException("The passed class '" + clazz.getName() + "' does not have an @XmlType annotation!");
        }
        package_ = clazz.getPackage();
        XmlSchema xmlSchema = package_.getAnnotation(XmlSchema.class);
        if (xmlSchema != null && xmlSchema.namespace() == null) {
            throw new IllegalArgumentException("The package '" + package_.getName() + "' has no namespace URI in the @XmlSchema annotation!");
        }
        XmlRootElement xmlRootElement = clazz.getAnnotation(XmlRootElement.class);
        if (xmlRootElement != null) {
            string2 = xmlRootElement.namespace();
            if (JAXB_DEFAULT.equals(string2) && xmlSchema != null) {
                string2 = xmlSchema.namespace();
            }
            if (JAXB_DEFAULT.equals(string = xmlRootElement.name())) {
                string = object.name();
            }
        } else {
            string2 = xmlSchema != null ? xmlSchema.namespace() : null;
            string = object.name();
        }
        if (function != null) {
            string = function.apply(string);
        }
        if (StringHelper.hasNoText((String)string)) {
            throw new IllegalArgumentException("Failed to determine the local name of the element to be created!");
        }
        this.m_aClass = clazz;
        if (list != null) {
            this.m_aXSDs.addAll(list);
        }
        this.m_sNamespaceURI = StringHelper.getNotNull((String)string2);
        this.m_sLocalName = string;
    }

    public JAXBDocumentType(@Nonnull Class<?> clazz, @Nullable List<? extends ClassPathResource> list, @Nullable String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notNull(clazz, (String)"Class");
        if (list != null) {
            ValueEnforcer.notEmptyNoNullValue(list, (String)"XSDs");
            for (ClassPathResource object2 : list) {
                ValueEnforcer.isTrue((boolean)object2.hasClassLoader(), () -> "ClassPathResource " + object2 + " MUST define its ClassLoader!");
            }
        }
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"sLocalName");
        XmlType xmlType = clazz.getAnnotation(XmlType.class);
        if (xmlType == null) {
            throw new IllegalArgumentException("The passed class '" + clazz.getName() + "' does not have an @XmlType annotation!");
        }
        Package package_ = clazz.getPackage();
        XmlSchema xmlSchema = package_.getAnnotation(XmlSchema.class);
        if (xmlSchema != null && xmlSchema.namespace() == null) {
            throw new IllegalArgumentException("The package '" + package_.getName() + "' has no namespace URI in the @XmlSchema annotation!");
        }
        this.m_aClass = clazz;
        if (list != null) {
            this.m_aXSDs.addAll(list);
        }
        this.m_sNamespaceURI = string;
        this.m_sLocalName = string2;
    }

    @Override
    @Nonnull
    public final Class<?> getImplementationClass() {
        return this.m_aClass;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<ClassPathResource> getAllXSDResources() {
        return (ICommonsList)this.m_aXSDs.getClone();
    }

    @Nonnull
    public final Supplier<XMLSchemaCache> getXMLSchemaCacheProvider() {
        return this.m_aXMLSchemaCacheProvider;
    }

    @Nonnull
    public final JAXBDocumentType setXMLSchemaCacheProvider(@Nonnull Supplier<XMLSchemaCache> supplier) {
        ValueEnforcer.notNull(supplier, (String)"SchemaCacheProvider");
        this.m_aXMLSchemaCacheProvider = supplier;
        return this;
    }

    @Override
    @Nonnull
    public final String getNamespaceURI() {
        return this.m_sNamespaceURI;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getLocalName() {
        return this.m_sLocalName;
    }

    @Override
    @Nullable
    public Schema getSchema() {
        if (this.m_aXSDs.isEmpty()) {
            return null;
        }
        if (this.m_aCachedSchema == null) {
            XMLSchemaCache xMLSchemaCache = this.m_aXMLSchemaCacheProvider.get();
            if (xMLSchemaCache == null) {
                throw new IllegalStateException("Failed to get an instance of XMLSchemaCache from " + this.m_aXMLSchemaCacheProvider);
            }
            this.m_aCachedSchema = xMLSchemaCache.getSchema(this.m_aXSDs);
        }
        return this.m_aCachedSchema;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JAXBDocumentType jAXBDocumentType = (JAXBDocumentType)object;
        return this.m_aClass.equals(jAXBDocumentType.m_aClass) && this.m_aXSDs.equals(jAXBDocumentType.m_aXSDs);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aClass).append(this.m_aXSDs).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Class", this.m_aClass).append("XSDPaths", this.m_aXSDs).append("XMLSchemaCacheProvider", this.m_aXMLSchemaCacheProvider).append("NamespaceURI", (Object)this.m_sNamespaceURI).append("LocalName", (Object)this.m_sLocalName).getToString();
    }

    private static /* synthetic */ String lambda$new$0(ClassPathResource classPathResource) {
        return "ClassPathResource " + classPathResource + " MUST define its ClassLoader!";
    }
}

