/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsIterable;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.state.EChange;
import com.helger.commons.traits.IGetterByKeyTrait;
import com.helger.json.IJson;
import com.helger.json.IJsonArray;
import com.helger.json.IJsonCollection;
import com.helger.json.IJsonValue;
import com.helger.json.JsonValue;
import com.helger.json.convert.JsonConverter;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IJsonObject
extends IJsonCollection,
ICommonsIterable<Map.Entry<String, IJson>>,
IGetterByKeyTrait<String> {
    @Nonnull
    public IJsonObject addJson(@Nonnull String var1, @Nonnull IJson var2);

    @Nonnull
    @Deprecated
    default public IJsonObject addIf(@Nonnull String string, @Nonnull IJson iJson, @Nonnull Predicate<? super IJson> predicate) {
        return this.addJsonIf(string, iJson, predicate);
    }

    @Nonnull
    default public IJsonObject addJsonIf(@Nonnull String string, @Nonnull IJson iJson, @Nonnull Predicate<? super IJson> predicate) {
        if (predicate.test(iJson)) {
            this.addJson(string, iJson);
        }
        return this;
    }

    @Nonnull
    default public IJsonObject addJsonIfNotNull(@Nonnull String string, @Nonnull IJson iJson) {
        if (iJson != null) {
            this.addJson(string, iJson);
        }
        return this;
    }

    @Nonnull
    default public IJsonObject add(@Nonnull String string, @Nullable Object object) {
        IJson iJson = JsonConverter.convertToJson(object);
        return this.addJson(string, iJson);
    }

    @Nonnull
    default public IJsonObject addIfNotNull(@Nonnull String string, @Nullable Object object) {
        if (object != null) {
            this.add(string, object);
        }
        return this;
    }

    @Nonnull
    default public IJsonObject addIf(@Nonnull String string, @Nullable Object object, @Nonnull Predicate<? super Object> predicate) {
        if (predicate.test(object)) {
            this.add(string, object);
        }
        return this;
    }

    @Nonnull
    default public IJsonObject add(@Nonnull Map.Entry<String, ?> entry) {
        return this.add(entry.getKey(), entry.getValue());
    }

    @Nonnull
    default public IJsonObject add(@Nonnull String string, boolean bl) {
        return this.addJson(string, JsonValue.create(bl));
    }

    @Nonnull
    default public IJsonObject add(@Nonnull String string, char c) {
        return this.addJson(string, JsonValue.create(c));
    }

    @Nonnull
    default public IJsonObject add(@Nonnull String string, double d) {
        return this.addJson(string, JsonValue.create(d));
    }

    @Nonnull
    default public IJsonObject add(@Nonnull String string, int n) {
        return this.addJson(string, JsonValue.create(n));
    }

    @Nonnull
    default public IJsonObject add(@Nonnull String string, long l) {
        return this.addJson(string, JsonValue.create(l));
    }

    @Nonnull
    default public IJsonObject addAll(@Nullable Map<String, ?> map) {
        if (map != null) {
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                this.add(entry);
            }
        }
        return this;
    }

    @Nonnull
    default public IJsonObject addAll(@Nullable IJsonObject iJsonObject) {
        if (iJsonObject != null) {
            Iterator iterator = iJsonObject.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                this.add(entry);
            }
        }
        return this;
    }

    @Nonnull
    default public <VALUETYPE> IJsonObject addAllMapped(@Nullable Map<String, ? extends VALUETYPE> map, @Nonnull Function<? super VALUETYPE, IJson> function) {
        if (map != null) {
            for (Map.Entry<String, VALUETYPE> entry : map.entrySet()) {
                this.addJson(entry.getKey(), function.apply(entry.getValue()));
            }
        }
        return this;
    }

    @Nonnull
    default public <KEYTYPE, VALUETYPE> IJsonObject addAllMapped(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map, @Nonnull Function<? super KEYTYPE, String> function, @Nonnull Function<? super VALUETYPE, IJson> function2) {
        if (map != null) {
            for (Map.Entry<KEYTYPE, VALUETYPE> entry : map.entrySet()) {
                this.addJson(function.apply(entry.getKey()), function2.apply(entry.getValue()));
            }
        }
        return this;
    }

    @Nullable
    public IJson removeKeyAndReturnValue(@Nullable String var1);

    @Nonnull
    public EChange removeKey(@Nullable String var1);

    public boolean containsKey(@Nullable String var1);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> keySet();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IJson> values();

    @Nullable
    public IJson get(@Nullable String var1);

    @Nullable
    default public Object getValue(@Nullable String string) {
        IJsonValue iJsonValue;
        IJson iJson = this.get(string);
        if (iJson != null && (iJsonValue = iJson.getAsValue()) != null) {
            return iJsonValue.getValue();
        }
        return null;
    }

    @Nullable
    default public IJsonValue getAsValue(@Nullable String string) {
        IJson iJson = this.get(string);
        return iJson != null ? iJson.getAsValue() : null;
    }

    @Nullable
    default public IJsonArray getAsArray(@Nullable String string) {
        IJson iJson = this.get(string);
        return iJson != null ? iJson.getAsArray() : null;
    }

    @Nullable
    default public IJsonObject getAsObject(@Nullable String string) {
        IJson iJson = this.get(string);
        return iJson != null ? iJson.getAsObject() : null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, IJson> getAll();

    public void forEach(@Nonnull BiConsumer<? super String, ? super IJson> var1);

    public boolean containsValue(@Nullable IJson var1);

    default public boolean containsValue(@Nullable Object object) {
        return this.containsValue(JsonValue.create(object));
    }

    default public boolean containsValue(boolean bl) {
        return this.containsValue(JsonValue.create(bl));
    }

    default public boolean containsValue(char c) {
        return this.containsValue(JsonValue.create(c));
    }

    default public boolean containsValue(double d) {
        return this.containsValue(JsonValue.create(d));
    }

    default public boolean containsValue(int n) {
        return this.containsValue(JsonValue.create(n));
    }

    default public boolean containsValue(long l) {
        return this.containsValue(JsonValue.create(l));
    }

    @Nullable
    default public IJson computeIfAbsent(@Nonnull String string, @Nonnull Function<? super String, ? extends IJson> function) {
        IJson iJson = this.get(string);
        if (iJson == null && (iJson = function.apply(string)) != null) {
            this.addJson(string, iJson);
        }
        return iJson;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, IJson> getClonedValues();

    @Nonnull
    public IJsonObject getClone();
}

