/*
 * Decompiled with CFR 0.152.
 */
package com.helger.scope;

import com.helger.commons.concurrent.SimpleReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;

@ThreadSafe
public final class ScopeHelper {
    public static final boolean DEFAULT_DEBUG_LIFE_CYCLE = false;
    public static final boolean DEFAULT_DEBUG_GLOBAL_SCOPE = false;
    public static final boolean DEFAULT_DEBUG_SESSION_SCOPE = false;
    public static final boolean DEFAULT_DEBUG_REQUEST_SCOPE = false;
    public static final boolean DEFAULT_DEBUG_WITH_STACK_TRACE = false;
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bDebugLifeCycle = false;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bDebugGlobalScope = false;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bDebugSessionScope = false;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bDebugRequestScope = false;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bDebugWithStackTrace = false;

    private ScopeHelper() {
    }

    public static void setLifeCycleDebuggingEnabled(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bDebugLifeCycle = bl;
        });
    }

    public static boolean isLifeCycleDebuggingEnabled() {
        return RW_LOCK.readLockedBoolean(() -> s_bDebugLifeCycle);
    }

    public static void setDebugGlobalScopeEnabled(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bDebugGlobalScope = bl;
        });
    }

    public static boolean isDebugGlobalScopeEnabled() {
        return RW_LOCK.readLockedBoolean(() -> s_bDebugGlobalScope);
    }

    public static void setDebugSessionScopeEnabled(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bDebugSessionScope = bl;
        });
    }

    public static boolean isDebugSessionScopeEnabled() {
        return RW_LOCK.readLockedBoolean(() -> s_bDebugSessionScope);
    }

    public static void setDebugRequestScopeEnabled(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bDebugRequestScope = bl;
        });
    }

    public static boolean isDebugRequestScopeEnabled() {
        RW_LOCK.readLock().lock();
        try {
            boolean bl = s_bDebugRequestScope;
            return bl;
        }
        finally {
            RW_LOCK.readLock().unlock();
        }
    }

    public static void setDebugWithStackTrace(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bDebugWithStackTrace = bl;
        });
    }

    public static boolean isDebugWithStackTrace() {
        return RW_LOCK.readLockedBoolean(() -> s_bDebugWithStackTrace);
    }

    @Deprecated
    public static boolean debugGlobalScopeLifeCycle(@Nonnull Logger logger) {
        return ScopeHelper.isDebugGlobalScopeLifeCycle(logger);
    }

    public static boolean isDebugGlobalScopeLifeCycle(@Nonnull Logger logger) {
        return (ScopeHelper.isLifeCycleDebuggingEnabled() || ScopeHelper.isDebugGlobalScopeEnabled()) && logger.isInfoEnabled();
    }

    @Deprecated
    public static boolean debugSessionScopeLifeCycle(@Nonnull Logger logger) {
        return ScopeHelper.isDebugSessionScopeLifeCycle(logger);
    }

    public static boolean isDebugSessionScopeLifeCycle(@Nonnull Logger logger) {
        return (ScopeHelper.isLifeCycleDebuggingEnabled() || ScopeHelper.isDebugSessionScopeEnabled()) && logger.isInfoEnabled();
    }

    @Deprecated
    public static boolean debugRequestScopeLifeCycle(@Nonnull Logger logger) {
        return ScopeHelper.isDebugRequestScopeLifeCycle(logger);
    }

    public static boolean isDebugRequestScopeLifeCycle(@Nonnull Logger logger) {
        return (ScopeHelper.isLifeCycleDebuggingEnabled() || ScopeHelper.isDebugRequestScopeEnabled()) && logger.isInfoEnabled();
    }

    @Nullable
    public static Throwable getDebugStackTrace() {
        return ScopeHelper.isDebugWithStackTrace() ? new DebugScopeException() : null;
    }

    public static class DebugScopeException
    extends Exception {
    }
}

