/*
 * Decompiled with CFR 0.152.
 */
package com.helger.scope.singleton;

import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.debug.GlobalDebug;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SingletonHelper {
    public static final boolean DEFAULT_DEBUG_CONSISTENCY = GlobalDebug.isDebugMode();
    public static final boolean DEFAULT_DEBUG_WITH_STACK_TRACE = false;
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bDebugConsistency = DEFAULT_DEBUG_CONSISTENCY;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bDebugWithStackTrace = false;

    private SingletonHelper() {
    }

    public static void setDebugConsistency(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bDebugConsistency = bl;
        });
    }

    public static boolean isDebugConsistency() {
        return RW_LOCK.readLockedBoolean(() -> s_bDebugConsistency);
    }

    public static void setDebugWithStackTrace(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bDebugWithStackTrace = bl;
        });
    }

    public static boolean isDebugWithStackTrace() {
        return RW_LOCK.readLockedBoolean(() -> s_bDebugWithStackTrace);
    }

    @Nullable
    public static Throwable getDebugStackTrace() {
        return SingletonHelper.isDebugWithStackTrace() ? new Exception() : null;
    }
}

