/*
 * Decompiled with CFR 0.152.
 */
package com.helger.scope.mgr;

import com.helger.scope.IScope;
import com.helger.scope.mgr.ScopeManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EScope {
    GLOBAL,
    SESSION,
    REQUEST;


    @Nonnull
    public IScope getScope() {
        return this.getScope(true);
    }

    @Nullable
    public IScope getScope(boolean bl) {
        return EScope.getScope(this, bl);
    }

    @Nullable
    public static IScope getScope(@Nonnull EScope eScope, boolean bl) {
        switch (eScope) {
            case GLOBAL: {
                return bl ? ScopeManager.getGlobalScope() : ScopeManager.getGlobalScopeOrNull();
            }
            case SESSION: {
                return ScopeManager.getSessionScope(bl);
            }
            case REQUEST: {
                return bl ? ScopeManager.getRequestScope() : ScopeManager.getRequestScopeOrNull();
            }
        }
        throw new IllegalArgumentException("Unknown scope: " + eScope);
    }
}

