/*
 * Decompiled with CFR 0.152.
 */
package com.helger.scope.spi;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.exception.mock.IMockException;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.scope.IGlobalScope;
import com.helger.scope.IRequestScope;
import com.helger.scope.ISessionScope;
import com.helger.scope.spi.IGlobalScopeSPI;
import com.helger.scope.spi.IRequestScopeSPI;
import com.helger.scope.spi.ISessionScopeSPI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ScopeSPIManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScopeSPIManager.class);
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private ICommonsList<IGlobalScopeSPI> m_aGlobalSPIs;
    @GuardedBy(value="m_aRWLock")
    private ICommonsList<ISessionScopeSPI> m_aSessionSPIs;
    @GuardedBy(value="m_aRWLock")
    private ICommonsList<IRequestScopeSPI> m_aRequestSPIs;

    private ScopeSPIManager() {
        this.reinitialize();
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static ScopeSPIManager getInstance() {
        ScopeSPIManager scopeSPIManager = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return scopeSPIManager;
    }

    public void reinitialize() {
        this.m_aRWLock.writeLocked(() -> {
            this.m_aGlobalSPIs = ServiceLoaderHelper.getAllSPIImplementations(IGlobalScopeSPI.class);
            this.m_aSessionSPIs = ServiceLoaderHelper.getAllSPIImplementations(ISessionScopeSPI.class);
            this.m_aRequestSPIs = ServiceLoaderHelper.getAllSPIImplementations(IRequestScopeSPI.class);
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Reinitialized " + ScopeSPIManager.class.getName());
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IGlobalScopeSPI> getAllGlobalScopeSPIs() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> (ICommonsList)this.m_aGlobalSPIs.getClone());
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ISessionScopeSPI> getAllSessionScopeSPIs() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> (ICommonsList)this.m_aSessionSPIs.getClone());
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IRequestScopeSPI> getAllRequestScopeSPIs() {
        this.m_aRWLock.readLock().lock();
        try {
            ICommonsList iCommonsList = (ICommonsList)this.m_aRequestSPIs.getClone();
            return iCommonsList;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Nullable
    private static Exception _propagate(@Nonnull Exception exception) {
        return exception instanceof IMockException ? null : exception;
    }

    public void onGlobalScopeBegin(@Nonnull IGlobalScope iGlobalScope) {
        for (IGlobalScopeSPI iGlobalScopeSPI : this.getAllGlobalScopeSPIs()) {
            try {
                iGlobalScopeSPI.onGlobalScopeBegin(iGlobalScope);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to invoke SPI method onGlobalScopeBegin on " + iGlobalScopeSPI + " with scope " + iGlobalScope, (Throwable)ScopeSPIManager._propagate(exception));
            }
        }
    }

    public void onGlobalScopeEnd(@Nonnull IGlobalScope iGlobalScope) {
        for (IGlobalScopeSPI iGlobalScopeSPI : this.getAllGlobalScopeSPIs()) {
            try {
                iGlobalScopeSPI.onGlobalScopeEnd(iGlobalScope);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to invoke SPI method onGlobalScopeEnd on " + iGlobalScopeSPI + " with scope " + iGlobalScope, (Throwable)ScopeSPIManager._propagate(exception));
            }
        }
    }

    public void onSessionScopeBegin(@Nonnull ISessionScope iSessionScope) {
        for (ISessionScopeSPI iSessionScopeSPI : this.getAllSessionScopeSPIs()) {
            try {
                iSessionScopeSPI.onSessionScopeBegin(iSessionScope);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to invoke SPI method onSessionScopeBegin on " + iSessionScopeSPI + " with scope " + iSessionScope, (Throwable)ScopeSPIManager._propagate(exception));
            }
        }
    }

    public void onSessionScopeEnd(@Nonnull ISessionScope iSessionScope) {
        for (ISessionScopeSPI iSessionScopeSPI : this.getAllSessionScopeSPIs()) {
            try {
                iSessionScopeSPI.onSessionScopeEnd(iSessionScope);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to invoke SPI method onSessionScopeEnd on " + iSessionScopeSPI + " with scope " + iSessionScope, (Throwable)ScopeSPIManager._propagate(exception));
            }
        }
    }

    public void onRequestScopeBegin(@Nonnull IRequestScope iRequestScope) {
        for (IRequestScopeSPI iRequestScopeSPI : this.getAllRequestScopeSPIs()) {
            try {
                iRequestScopeSPI.onRequestScopeBegin(iRequestScope);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to invoke SPI method onRequestScopeBegin on " + iRequestScopeSPI + " with scope " + iRequestScope, (Throwable)ScopeSPIManager._propagate(exception));
            }
        }
    }

    public void onRequestScopeEnd(@Nonnull IRequestScope iRequestScope) {
        for (IRequestScopeSPI iRequestScopeSPI : this.getAllRequestScopeSPIs()) {
            try {
                iRequestScopeSPI.onRequestScopeEnd(iRequestScope);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to invoke SPI method onRequestScopeEnd on " + iRequestScopeSPI + " with scope " + iRequestScope, (Throwable)ScopeSPIManager._propagate(exception));
            }
        }
    }

    private static final class SingletonHolder {
        private static final ScopeSPIManager INSTANCE = new ScopeSPIManager();

        private SingletonHolder() {
        }
    }
}

