/*
 * Decompiled with CFR 0.152.
 */
package com.helger.statistics.impl;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsSet;
import com.helger.statistics.api.IMutableStatisticsHandlerKeyedCounter;
import java.util.concurrent.atomic.AtomicInteger;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@ThreadSafe
public class StatisticsHandlerKeyedCounter
implements IMutableStatisticsHandlerKeyedCounter {
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final AtomicInteger m_aInvocationCount = new AtomicInteger();
    private final ICommonsMap<String, Value> m_aMap = new CommonsHashMap();

    @Override
    @Nonnegative
    public int getInvocationCount() {
        return this.m_aInvocationCount.intValue();
    }

    @Override
    public void increment(@Nullable String string, long l) {
        this.m_aInvocationCount.incrementAndGet();
        this.m_aRWLock.writeLocked(() -> {
            Value value = (Value)this.m_aMap.get((Object)string);
            if (value == null) {
                this.m_aMap.put((Object)string, (Object)new Value(l));
            } else {
                value.increment(l);
            }
        });
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsSet<String> getAllKeys() {
        return (ICommonsSet)this.m_aRWLock.readLockedGet(() -> this.m_aMap.copyOfKeySet());
    }

    @Override
    @CheckForSigned
    public long getCount(@Nullable String string) {
        return this.m_aRWLock.readLockedLong(() -> {
            Value value = (Value)this.m_aMap.get((Object)string);
            return value == null ? -1L : value.getCount();
        });
    }

    @Override
    @CheckForSigned
    public int getInvocationCount(@Nullable String string) {
        return this.m_aRWLock.readLockedInt(() -> {
            Value value = (Value)this.m_aMap.get((Object)string);
            return value == null ? -1 : value.getInvocationCount();
        });
    }

    @NotThreadSafe
    private static final class Value {
        private int m_nInvocationCount = 1;
        private long m_nCount;

        public Value(long l) {
            this.m_nCount = l;
        }

        public void increment(long l) {
            ++this.m_nInvocationCount;
            this.m_nCount += l;
        }

        @Nonnegative
        public int getInvocationCount() {
            return this.m_nInvocationCount;
        }

        public long getCount() {
            return this.m_nCount;
        }

        public String toString() {
            return new ToStringGenerator(null).append("invocations", this.m_nInvocationCount).append("count", this.m_nCount).getToString();
        }
    }
}

