/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.format;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.text.format.AbstractFormatterString;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class FormatterStringPrefixAndSuffix
extends AbstractFormatterString {
    private final String m_sPrefix;
    private final String m_sSuffix;

    public FormatterStringPrefixAndSuffix(@Nonnull String string, @Nonnull String string2) {
        this.m_sPrefix = (String)ValueEnforcer.notNull((Object)string, (String)"Prefix");
        this.m_sSuffix = (String)ValueEnforcer.notNull((Object)string2, (String)"Suffix");
    }

    @Nonnull
    public String getPrefix() {
        return this.m_sPrefix;
    }

    @Nonnull
    public String getSuffix() {
        return this.m_sSuffix;
    }

    @Override
    public String apply(@Nullable Object object) {
        return this.m_sPrefix + this.getValueAsString(object) + this.m_sSuffix;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FormatterStringPrefixAndSuffix formatterStringPrefixAndSuffix = (FormatterStringPrefixAndSuffix)object;
        return this.m_sPrefix.equals(formatterStringPrefixAndSuffix.m_sPrefix) && this.m_sSuffix.equals(formatterStringPrefixAndSuffix.m_sSuffix);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sPrefix).append((Object)this.m_sSuffix).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Prefix", (Object)this.m_sPrefix).append("Suffix", (Object)this.m_sSuffix).getToString();
    }

    @Nonnull
    public static FormatterStringPrefixAndSuffix createPrefixOnly(@Nonnull String string) {
        return new FormatterStringPrefixAndSuffix(string, "");
    }

    @Nonnull
    public static FormatterStringPrefixAndSuffix createSuffixOnly(@Nonnull String string) {
        return new FormatterStringPrefixAndSuffix("", string);
    }

    @Nonnull
    public static FormatterStringPrefixAndSuffix createWithBrackets() {
        return new FormatterStringPrefixAndSuffix("[", "]");
    }
}

