/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.codepoint;

import com.helger.text.codepoint.AbstractCodepointIterator;
import java.nio.CharBuffer;
import org.jspecify.annotations.NonNull;

public class CodepointIteratorCharBuffer
extends AbstractCodepointIterator {
    private final char[] m_aBuffer;

    public CodepointIteratorCharBuffer(@NonNull CharBuffer charBuffer) {
        super(charBuffer.position(), charBuffer.limit());
        this.m_aBuffer = charBuffer.array();
    }

    @Override
    protected char get() {
        return this.m_nPosition < this.limit() ? this.m_aBuffer[this.m_nPosition++] : (char)'\uffff';
    }

    @Override
    protected char get(int n) {
        if (n < 0 || n >= this.m_nLimit) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.m_aBuffer[n];
    }
}

