/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.display;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.text.TextFormatter;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.text.display.IHasDisplayText;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public class HasDisplayTextWithArgs
implements IHasDisplayText {
    private final IHasDisplayText m_aParentText;
    private final Object[] m_aArgs;

    public HasDisplayTextWithArgs(@NonNull IHasDisplayText iHasDisplayText, Object ... objectArray) {
        this.m_aParentText = (IHasDisplayText)ValueEnforcer.notNull((Object)iHasDisplayText, (String)"ParentText");
        this.m_aArgs = ValueEnforcer.notEmpty((Object[])objectArray, (String)"Arguments");
    }

    public @NonNull IHasDisplayText getParentText() {
        return this.m_aParentText;
    }

    @Nonempty
    @ReturnsMutableCopy
    public @NonNull Object[] getAllArgs() {
        return ArrayHelper.getCopy((Object[])this.m_aArgs);
    }

    @Override
    public @Nullable String getDisplayText(@NonNull Locale locale) {
        String string = this.m_aParentText.getDisplayText(locale);
        return TextFormatter.getFormattedText((String)string, (Object[])this.m_aArgs);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("parentText", (Object)this.m_aParentText).append("args", this.m_aArgs).getToString();
    }
}

