/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.locale.country;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.log.ConditionalLogger;
import com.helger.base.log.IHasConditionalLogger;
import com.helger.base.state.EChange;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsSet;
import com.helger.text.locale.LocaleCache;
import com.helger.text.locale.LocaleHelper;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CountryCache
implements IHasConditionalLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(CountryCache.class);
    private static final ConditionalLogger CONDLOG = new ConditionalLogger(LOGGER);
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsSet<String> m_aCountries = new CommonsHashSet();

    protected CountryCache() {
        this.reinitialize();
    }

    public static boolean isSilentMode() {
        return CONDLOG.isDisabled();
    }

    public static boolean setSilentMode(boolean bl) {
        return !CONDLOG.setEnabled(!bl);
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    public static @NonNull CountryCache getInstance() {
        CountryCache countryCache = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return countryCache;
    }

    final @NonNull EChange addCountry(@NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Country");
        String string2 = LocaleHelper.getValidCountryCode(string);
        ValueEnforcer.isTrue((string2 != null ? 1 : 0) != 0, () -> "illegal country code '" + string + "'");
        ValueEnforcer.isTrue((boolean)string.equals(string2), () -> "invalid casing of '" + string + "'");
        return (EChange)this.m_aRWLock.writeLockedGet(() -> this.m_aCountries.addObject((Object)string2));
    }

    public @Nullable Locale getCountry(@Nullable Locale locale) {
        return locale == null ? null : this.getCountry(locale.getCountry());
    }

    public @Nullable Locale getCountryExt(@Nullable Locale locale, @Nullable LocaleCache.IMissingLocaleHandler iMissingLocaleHandler) {
        return locale == null ? null : this.getCountryExt(locale.getCountry(), iMissingLocaleHandler);
    }

    public @Nullable Locale getCountry(@Nullable String string) {
        return this.getCountryExt(string, null);
    }

    public @Nullable Locale getCountryExt(@Nullable String string, @Nullable LocaleCache.IMissingLocaleHandler iMissingLocaleHandler) {
        LocaleCache.IMissingLocaleHandler iMissingLocaleHandler2;
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        LocaleCache localeCache = LocaleCache.getInstance();
        LocaleCache.IMissingLocaleHandler iMissingLocaleHandler3 = iMissingLocaleHandler2 = iMissingLocaleHandler != null ? iMissingLocaleHandler : localeCache.getDefaultMissingLocaleHandler();
        if (string.indexOf(95) >= 0) {
            return this.getCountryExt(localeCache.getLocaleExt(string, iMissingLocaleHandler2), iMissingLocaleHandler2);
        }
        String string2 = LocaleHelper.getValidCountryCode(string);
        if (!this.containsCountry(string2)) {
            CONDLOG.warn(() -> "Trying to retrieve unsupported country '" + string + "'");
        }
        return localeCache.getLocale("", string2, "", iMissingLocaleHandler2);
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsSet<String> getAllCountries() {
        return (ICommonsSet)this.m_aRWLock.readLockedGet(() -> this.m_aCountries.getClone());
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsSet<Locale> getAllCountryLocales() {
        return (ICommonsSet)this.m_aRWLock.readLockedGet(() -> {
            LocaleCache localeCache = LocaleCache.getInstance();
            return new CommonsHashSet(this.m_aCountries, string -> localeCache.getLocale("", (String)string, ""));
        });
    }

    public boolean containsCountry(@Nullable Locale locale) {
        return locale != null && this.containsCountry(locale.getCountry());
    }

    public boolean containsCountry(@Nullable String string) {
        if (string == null) {
            return false;
        }
        String string2 = LocaleHelper.getValidCountryCode(string);
        if (string2 == null) {
            return false;
        }
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aCountries.contains((Object)string2));
    }

    public final void reinitialize() {
        this.m_aRWLock.writeLocked(() -> this.m_aCountries.clear());
        for (Locale locale : LocaleCache.getAllDefaultLocales()) {
            String string = locale.getCountry();
            if (!StringHelper.isNotEmpty((String)string)) continue;
            this.addCountry(string);
        }
        CONDLOG.debug(() -> "Reinitialized " + this.getClass().getName());
    }

    private static final class SingletonHolder {
        private static final CountryCache INSTANCE = new CountryCache();

        private SingletonHolder() {
        }
    }
}

