/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.locale.language;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.log.ConditionalLogger;
import com.helger.base.log.IHasConditionalLogger;
import com.helger.base.state.EChange;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsSet;
import com.helger.text.locale.LocaleCache;
import com.helger.text.locale.LocaleHelper;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class LanguageCache
implements IHasConditionalLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(LanguageCache.class);
    private static final ConditionalLogger CONDLOG = new ConditionalLogger(LOGGER);
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsSet<String> m_aLanguages = new CommonsHashSet();

    private LanguageCache() {
        this.reinitialize();
    }

    public static boolean isSilentMode() {
        return CONDLOG.isDisabled();
    }

    public static boolean setSilentMode(boolean bl) {
        return !CONDLOG.setEnabled(!bl);
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    public static @NonNull LanguageCache getInstance() {
        LanguageCache languageCache = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return languageCache;
    }

    @NonNull EChange addLanguage(@NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Language");
        String string2 = LocaleHelper.getValidLanguageCode(string);
        ValueEnforcer.isTrue((string2 != null ? 1 : 0) != 0, () -> "illegal language code '" + string + "'");
        ValueEnforcer.isEqual((Object)string, (Object)string2, () -> "invalid casing of '" + string + "'");
        return (EChange)this.m_aRWLock.writeLockedGet(() -> this.m_aLanguages.addObject((Object)string2));
    }

    public @Nullable Locale getLanguage(@Nullable Locale locale) {
        return locale == null ? null : this.getLanguage(locale.getLanguage());
    }

    public @Nullable Locale getLanguageExt(@Nullable Locale locale, @Nullable LocaleCache.IMissingLocaleHandler iMissingLocaleHandler) {
        return locale == null ? null : this.getLanguageExt(locale.getLanguage(), iMissingLocaleHandler);
    }

    public @Nullable Locale getLanguage(@Nullable String string) {
        return this.getLanguageExt(string, null);
    }

    public @Nullable Locale getLanguageExt(@Nullable String string, @Nullable LocaleCache.IMissingLocaleHandler iMissingLocaleHandler) {
        LocaleCache.IMissingLocaleHandler iMissingLocaleHandler2;
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        LocaleCache localeCache = LocaleCache.getInstance();
        LocaleCache.IMissingLocaleHandler iMissingLocaleHandler3 = iMissingLocaleHandler2 = iMissingLocaleHandler != null ? iMissingLocaleHandler : localeCache.getDefaultMissingLocaleHandler();
        if (string.indexOf(95) >= 0) {
            return this.getLanguageExt(localeCache.getLocaleExt(string, iMissingLocaleHandler2), iMissingLocaleHandler2);
        }
        String string2 = LocaleHelper.getValidLanguageCode(string);
        if (!this.containsLanguage(string2)) {
            CONDLOG.warn(() -> "Trying to retrieve unsupported language '" + string + "'");
        }
        return localeCache.getLocale(string2, "", "", iMissingLocaleHandler2);
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsSet<String> getAllLanguages() {
        return (ICommonsSet)this.m_aRWLock.readLockedGet(() -> this.m_aLanguages.getClone());
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsSet<Locale> getAllLanguageLocales() {
        return (ICommonsSet)this.m_aRWLock.readLockedGet(() -> {
            LocaleCache localeCache = LocaleCache.getInstance();
            return new CommonsHashSet(this.m_aLanguages, string -> localeCache.getLocale((String)string, "", ""));
        });
    }

    public boolean containsLanguage(@Nullable Locale locale) {
        return locale != null && this.containsLanguage(locale.getLanguage());
    }

    public boolean containsLanguage(@Nullable String string) {
        if (string == null) {
            return false;
        }
        String string2 = LocaleHelper.getValidLanguageCode(string);
        if (string2 == null) {
            return false;
        }
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aLanguages.contains((Object)string2));
    }

    public void reinitialize() {
        this.m_aRWLock.writeLocked(() -> this.m_aLanguages.clear());
        for (Locale locale : LocaleCache.getAllDefaultLocales()) {
            String string = locale.getLanguage();
            if (!StringHelper.isNotEmpty((String)string)) continue;
            this.addLanguage(string);
        }
        CONDLOG.debug(() -> "Reinitialized " + LanguageCache.class.getName());
    }

    private static final class SingletonHolder {
        private static final LanguageCache INSTANCE = new LanguageCache();

        private SingletonHolder() {
        }
    }
}

