/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.misc.DevelopersNote;
import com.helger.annotation.style.ReturnsImmutableObject;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.functional.ITriConsumer;
import com.helger.base.state.EChange;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringParser;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.typeconvert.impl.TypeConverter;
import com.helger.xml.microdom.IHasAttributeValue;
import com.helger.xml.microdom.IMicroAttribute;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroQName;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface IMicroAttributeContainer<IMPLTYPE extends IMicroAttributeContainer<IMPLTYPE>>
extends IMicroNode {
    public boolean hasAttributes();

    public boolean hasNoAttributes();

    @Nonnegative
    public int getAttributeCount();

    default public boolean hasAttribute(@Nullable String string) {
        return this.hasAttribute(null, string);
    }

    default public boolean hasAttribute(@Nullable String string, @Nullable String string2) {
        if (StringHelper.isEmpty((String)string2)) {
            return false;
        }
        return this.hasAttribute(new MicroQName(string, string2));
    }

    public boolean hasAttribute(@Nullable IMicroQName var1);

    default public @Nullable IMicroAttribute getAttributeObj(@Nullable String string) {
        return this.getAttributeObj(null, string);
    }

    default public @Nullable IMicroAttribute getAttributeObj(@Nullable String string, @Nullable String string2) {
        if (StringHelper.isEmpty((String)string2)) {
            return null;
        }
        return this.getAttributeObj(new MicroQName(string, string2));
    }

    public @Nullable IMicroAttribute getAttributeObj(@Nullable IMicroQName var1);

    default public @Nullable String getAttributeValue(@Nullable String string) {
        return this.getAttributeValue(null, string);
    }

    default public @Nullable String getAttributeValue(@Nullable String string, @Nullable String string2) {
        if (string2 == null) {
            return null;
        }
        return this.getAttributeValue(new MicroQName(string, string2));
    }

    default public @Nullable String getAttributeValue(@Nullable IMicroQName iMicroQName) {
        IMicroAttribute iMicroAttribute = this.getAttributeObj(iMicroQName);
        return iMicroAttribute == null ? null : iMicroAttribute.getAttributeValue();
    }

    default public <DSTTYPE> @Nullable DSTTYPE getAttributeValueWithConversion(@Nullable String string, @NonNull Class<DSTTYPE> clazz) {
        return this.getAttributeValueWithConversion(null, string, clazz);
    }

    default public <DSTTYPE> @Nullable DSTTYPE getAttributeValueWithConversion(@Nullable String string, @Nullable String string2, @NonNull Class<DSTTYPE> clazz) {
        if (string2 == null) {
            return null;
        }
        return this.getAttributeValueWithConversion(new MicroQName(string, string2), clazz);
    }

    public <DSTTYPE> @Nullable DSTTYPE getAttributeValueWithConversion(@Nullable IMicroQName var1, @NonNull Class<DSTTYPE> var2);

    default public boolean getAttributeValueAsBool(@Nullable String string, boolean bl) {
        return StringParser.parseBool((String)this.getAttributeValue(string), (boolean)bl);
    }

    default public boolean getAttributeValueAsBool(@Nullable String string, @Nullable String string2, boolean bl) {
        return StringParser.parseBool((String)this.getAttributeValue(string, string2), (boolean)bl);
    }

    default public boolean getAttributeValueAsBool(@Nullable IMicroQName iMicroQName, boolean bl) {
        return StringParser.parseBool((String)this.getAttributeValue(iMicroQName), (boolean)bl);
    }

    default public double getAttributeValueAsDouble(@Nullable String string, double d) {
        return StringParser.parseDouble((String)this.getAttributeValue(string), (double)d);
    }

    default public double getAttributeValueAsDouble(@Nullable String string, @Nullable String string2, double d) {
        return StringParser.parseDouble((String)this.getAttributeValue(string, string2), (double)d);
    }

    default public double getAttributeValueAsDouble(@Nullable IMicroQName iMicroQName, double d) {
        return StringParser.parseDouble((String)this.getAttributeValue(iMicroQName), (double)d);
    }

    default public float getAttributeValueAsFloat(@Nullable String string, float f) {
        return StringParser.parseFloat((String)this.getAttributeValue(string), (float)f);
    }

    default public float getAttributeValueAsFloat(@Nullable String string, @Nullable String string2, float f) {
        return StringParser.parseFloat((String)this.getAttributeValue(string, string2), (float)f);
    }

    default public float getAttributeValueAsFloat(@Nullable IMicroQName iMicroQName, float f) {
        return StringParser.parseFloat((String)this.getAttributeValue(iMicroQName), (float)f);
    }

    default public int getAttributeValueAsInt(@Nullable String string, int n) {
        return StringParser.parseInt((String)this.getAttributeValue(string), (int)n);
    }

    default public int getAttributeValueAsInt(@Nullable String string, @Nullable String string2, int n) {
        return StringParser.parseInt((String)this.getAttributeValue(string, string2), (int)n);
    }

    default public int getAttributeValueAsInt(@Nullable IMicroQName iMicroQName, int n) {
        return StringParser.parseInt((String)this.getAttributeValue(iMicroQName), (int)n);
    }

    default public long getAttributeValueAsLong(@Nullable String string, long l) {
        return StringParser.parseLong((String)this.getAttributeValue(string), (long)l);
    }

    default public long getAttributeValueAsLong(@Nullable String string, @Nullable String string2, long l) {
        return StringParser.parseLong((String)this.getAttributeValue(string, string2), (long)l);
    }

    default public long getAttributeValueAsLong(@Nullable IMicroQName iMicroQName, long l) {
        return StringParser.parseLong((String)this.getAttributeValue(iMicroQName), (long)l);
    }

    @ReturnsImmutableObject
    public @Nullable Iterable<? extends IMicroAttribute> getAttributeObjs();

    @ReturnsMutableCopy
    public @Nullable ICommonsList<? extends IMicroAttribute> getAllAttributeObjs();

    @ReturnsMutableCopy
    public @Nullable ICommonsOrderedMap<IMicroQName, String> getAllQAttributes();

    @ReturnsMutableCopy
    public @Nullable ICommonsOrderedSet<IMicroQName> getAllAttributeQNames();

    public void forAllAttributes(@NonNull Consumer<? super IMicroAttribute> var1);

    public void forAllAttributes(@NonNull BiConsumer<? super IMicroQName, ? super String> var1);

    public void forAllAttributes(@NonNull ITriConsumer<? super String, ? super String, ? super String> var1);

    default public @NonNull IMPLTYPE setAttribute(@NonNull String string, @Nullable String string2) {
        return this.setAttribute((IMicroQName)new MicroQName(string), string2);
    }

    default public @NonNull IMPLTYPE setAttributeNS(@Nullable String string, @NonNull String string2, @Nullable String string3) {
        return this.setAttribute((IMicroQName)new MicroQName(string, string2), string3);
    }

    public @NonNull IMPLTYPE setAttribute(@NonNull IMicroQName var1, @Nullable String var2);

    default public @NonNull IMPLTYPE setAttribute(@NonNull String string, @NonNull IHasAttributeValue iHasAttributeValue) {
        return this.setAttribute((IMicroQName)new MicroQName(string), iHasAttributeValue);
    }

    default public @NonNull IMPLTYPE setAttributeNS(@Nullable String string, @NonNull String string2, @NonNull IHasAttributeValue iHasAttributeValue) {
        return this.setAttribute((IMicroQName)new MicroQName(string, string2), iHasAttributeValue);
    }

    default public @NonNull IMPLTYPE setAttribute(@NonNull IMicroQName iMicroQName, @NonNull IHasAttributeValue iHasAttributeValue) {
        ValueEnforcer.notNull((Object)iHasAttributeValue, (String)"AttrValueProvider");
        return this.setAttribute(iMicroQName, iHasAttributeValue.getAttrValue());
    }

    default public @NonNull IMPLTYPE setAttribute(@NonNull String string, boolean bl) {
        return this.setAttribute(string, Boolean.toString(bl));
    }

    default public @NonNull IMPLTYPE setAttributeNS(@Nullable String string, @NonNull String string2, boolean bl) {
        return this.setAttributeNS(string, string2, Boolean.toString(bl));
    }

    default public @NonNull IMPLTYPE setAttribute(@NonNull IMicroQName iMicroQName, boolean bl) {
        return this.setAttribute(iMicroQName, Boolean.toString(bl));
    }

    default public @NonNull IMPLTYPE setAttribute(@NonNull String string, double d) {
        return this.setAttribute(string, Double.toString(d));
    }

    default public @NonNull IMPLTYPE setAttributeNS(@Nullable String string, @NonNull String string2, double d) {
        return this.setAttributeNS(string, string2, Double.toString(d));
    }

    default public @NonNull IMPLTYPE setAttribute(@NonNull IMicroQName iMicroQName, double d) {
        return this.setAttribute(iMicroQName, Double.toString(d));
    }

    default public @NonNull IMPLTYPE setAttribute(@NonNull String string, float f) {
        return this.setAttribute(string, Float.toString(f));
    }

    default public @NonNull IMPLTYPE setAttributeNS(@Nullable String string, @NonNull String string2, float f) {
        return this.setAttributeNS(string, string2, Float.toString(f));
    }

    default public @NonNull IMPLTYPE setAttribute(@NonNull IMicroQName iMicroQName, float f) {
        return this.setAttribute(iMicroQName, Float.toString(f));
    }

    default public @NonNull IMPLTYPE setAttribute(@NonNull String string, int n) {
        return this.setAttribute(string, Integer.toString(n));
    }

    default public @NonNull IMPLTYPE setAttributeNS(@Nullable String string, @NonNull String string2, int n) {
        return this.setAttributeNS(string, string2, Integer.toString(n));
    }

    default public @NonNull IMPLTYPE setAttribute(@NonNull IMicroQName iMicroQName, int n) {
        return this.setAttribute(iMicroQName, Integer.toString(n));
    }

    default public @NonNull IMPLTYPE setAttribute(@NonNull String string, long l) {
        return this.setAttribute(string, Long.toString(l));
    }

    default public @NonNull IMPLTYPE setAttributeNS(@Nullable String string, @NonNull String string2, long l) {
        return this.setAttributeNS(string, string2, Long.toString(l));
    }

    default public @NonNull IMPLTYPE setAttribute(@NonNull IMicroQName iMicroQName, long l) {
        return this.setAttribute(iMicroQName, Long.toString(l));
    }

    default public @NonNull IMPLTYPE setAttributeWithConversion(@NonNull String string, @Nullable Object object) {
        return this.setAttributeWithConversion((IMicroQName)new MicroQName(string), object);
    }

    @Deprecated(forRemoval=false)
    @DevelopersNote(value="No need for setAttributeWithConversion - setAttribute is enough")
    default public @NonNull IMPLTYPE setAttributeWithConversion(@NonNull String string, @Nullable String string2) {
        return this.setAttribute(string, string2);
    }

    default public @NonNull IMPLTYPE setAttributeNSWithConversion(@Nullable String string, @NonNull String string2, @Nullable Object object) {
        return this.setAttributeWithConversion((IMicroQName)new MicroQName(string, string2), object);
    }

    @Deprecated(forRemoval=false)
    @DevelopersNote(value="No need for setAttributeWithConversion - setAttributeNS is enough")
    default public @NonNull IMPLTYPE setAttributeNSWithConversion(@Nullable String string, @NonNull String string2, @Nullable String string3) {
        return this.setAttributeNS(string, string2, string3);
    }

    default public @NonNull IMPLTYPE setAttributeWithConversion(@NonNull IMicroQName iMicroQName, @Nullable Object object) {
        String string = (String)TypeConverter.convert((Object)object, String.class);
        return this.setAttribute(iMicroQName, string);
    }

    @Deprecated(forRemoval=false)
    @DevelopersNote(value="No need for setAttributeWithConversion - setAttribute is enough")
    default public @NonNull IMPLTYPE setAttributeWithConversion(@NonNull IMicroQName iMicroQName, @Nullable String string) {
        return this.setAttribute(iMicroQName, string);
    }

    default public @NonNull EChange removeAttribute(@Nullable String string) {
        return this.removeAttributeNS(null, string);
    }

    default public @NonNull EChange removeAttributeNS(@Nullable String string, @Nullable String string2) {
        if (StringHelper.isEmpty((String)string2)) {
            return EChange.UNCHANGED;
        }
        return this.removeAttribute(new MicroQName(string, string2));
    }

    public @NonNull EChange removeAttribute(@Nullable IMicroQName var1);

    public @NonNull EChange removeAllAttributes();
}

