/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.namespace;

import com.helger.collection.base.EmptyIterator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.xml.namespace.IIterableNamespaceContext;
import java.util.Iterator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class AbstractNamespaceContext
implements IIterableNamespaceContext {
    private static final ICommonsList<String> XML_NS = new CommonsArrayList((Object)"xml");
    private static final ICommonsList<String> XMLNS_ATTRIBUTE_NS = new CommonsArrayList((Object)"xmlns");

    public abstract @Nullable String getDefaultNamespaceURI();

    protected abstract @Nullable Iterator<String> getCustomPrefixes(@NonNull String var1);

    @Override
    public final @NonNull Iterator<String> getPrefixes(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.equals("http://www.w3.org/XML/1998/namespace")) {
            return XML_NS.iterator();
        }
        if (string.equals("http://www.w3.org/2000/xmlns/")) {
            return XMLNS_ATTRIBUTE_NS.iterator();
        }
        EmptyIterator emptyIterator = this.getCustomPrefixes(string);
        return emptyIterator != null ? emptyIterator : new EmptyIterator();
    }

    protected abstract @Nullable String getCustomPrefix(@NonNull String var1);

    @Override
    public final @Nullable String getPrefix(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (string.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        if (string.equals(this.getDefaultNamespaceURI())) {
            return "";
        }
        return this.getCustomPrefix(string);
    }

    protected abstract @Nullable String getCustomNamespaceURI(@NonNull String var1);

    @Override
    public final @NonNull String getNamespaceURI(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("null prefix is not allowed!");
        }
        if (string.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (string.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (string.equals("")) {
            String string2 = this.getDefaultNamespaceURI();
            return string2 != null ? string2 : "";
        }
        String string3 = this.getCustomNamespaceURI(string);
        return string3 != null ? string3 : "";
    }
}

