/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.namespace;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.helper.CollectionHelperExt;
import com.helger.xml.namespace.AbstractNamespaceContext;
import java.util.Iterator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public class SingleElementNamespaceContext
extends AbstractNamespaceContext {
    private final String m_sPrefix;
    private final String m_sNamespaceURI;

    public SingleElementNamespaceContext(@Nonempty @NonNull String string) {
        this("", string);
    }

    public SingleElementNamespaceContext(@NonNull String string, @Nonempty @NonNull String string2) {
        this.m_sPrefix = (String)ValueEnforcer.notNull((Object)string, (String)"Prefix");
        this.m_sNamespaceURI = (String)ValueEnforcer.notEmpty((CharSequence)string2, (String)"NamespaceURI");
    }

    @Override
    public @Nullable String getDefaultNamespaceURI() {
        return this.m_sPrefix.equals("") ? this.m_sNamespaceURI : null;
    }

    @Override
    protected @Nullable Iterator<String> getCustomPrefixes(@Nullable String string) {
        return this.m_sNamespaceURI.equals(string) ? new CommonsArrayList((Object)this.m_sPrefix).iterator() : null;
    }

    @Override
    protected @Nullable String getCustomPrefix(@Nullable String string) {
        return this.m_sNamespaceURI.equals(string) ? this.m_sPrefix : null;
    }

    @Override
    protected @Nullable String getCustomNamespaceURI(@Nullable String string) {
        return this.m_sPrefix.equals(string) ? this.m_sNamespaceURI : null;
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull ICommonsMap<String, String> getPrefixToNamespaceURIMap() {
        return CollectionHelperExt.createMap((Object)this.m_sPrefix, (Object)this.m_sNamespaceURI);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("prefix", (Object)this.m_sPrefix).append("namespaceURI", (Object)this.m_sNamespaceURI).getToString();
    }
}

