/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.read;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.diagnostics.callback.exception.LoggingExceptionCallback;
import com.helger.diagnostics.error.level.EErrorLevel;
import com.helger.diagnostics.error.level.IErrorLevel;
import com.helger.xml.sax.AbstractSAXErrorHandler;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLLoggingExceptionCallback
extends LoggingExceptionCallback {
    public XMLLoggingExceptionCallback() {
    }

    public XMLLoggingExceptionCallback(@NonNull IErrorLevel iErrorLevel) {
        this.setErrorLevel(iErrorLevel);
    }

    @Nonempty
    @OverrideOnDemand
    protected @NonNull String getLogMessage(@Nullable Throwable throwable) {
        if (throwable instanceof SAXParseException) {
            SAXParseException sAXParseException = (SAXParseException)throwable;
            return AbstractSAXErrorHandler.getSaxParseError((IErrorLevel)EErrorLevel.ERROR, sAXParseException).getAsString(Locale.ROOT);
        }
        if (throwable instanceof SAXException) {
            return "Error parsing XML document";
        }
        if (throwable instanceof UnknownHostException) {
            return "Failed to resolve entity host: " + throwable.getMessage();
        }
        if (throwable instanceof IOException) {
            return "Error reading XML document: " + throwable.getMessage();
        }
        return super.getLogMessage(throwable);
    }

    protected boolean isLogException(@Nullable Throwable throwable) {
        if (throwable instanceof UnknownHostException) {
            return false;
        }
        return super.isLogException(throwable);
    }
}

