/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.write;

import com.helger.annotation.WillClose;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.nonblocking.NonBlockingByteArrayOutputStream;
import com.helger.base.io.nonblocking.NonBlockingStringWriter;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.state.ESuccess;
import com.helger.statistics.api.IMutableStatisticsHandlerSize;
import com.helger.statistics.impl.StatisticsManager;
import com.helger.xml.EXMLVersion;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLSerializer;
import com.helger.xml.serialize.write.XMLWriterSettings;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.namespace.NamespaceContext;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@Immutable
public final class XMLWriter {
    public static final EXMLVersion DEFAULT_XML_VERSION = EXMLVersion.XML_10;
    public static final NamespaceContext DEFAULT_NAMESPACE_CTX = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLWriter.class);
    private static final IMutableStatisticsHandlerSize STATS_SIZE = StatisticsManager.getSizeHandler(XMLWriter.class);
    private static final XMLWriter INSTANCE = new XMLWriter();

    private XMLWriter() {
    }

    public static @NonNull ESuccess writeToStream(@NonNull Node node, @WillClose @NonNull OutputStream outputStream) {
        return XMLWriter.writeToStream(node, outputStream, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @NonNull ESuccess writeToStream(@NonNull Node node, @WillClose @NonNull OutputStream outputStream, @NonNull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull((Object)node, (String)"Node");
        ValueEnforcer.notNull((Object)outputStream, (String)"OutputStream");
        ValueEnforcer.notNull((Object)iXMLWriterSettings, (String)"Settings");
        try {
            XMLSerializer xMLSerializer = new XMLSerializer(iXMLWriterSettings);
            xMLSerializer.write(node, outputStream);
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error("Error in XML serialization", (Throwable)runtimeException);
            throw runtimeException;
        }
        catch (Exception exception) {
            LOGGER.error("Error in XML serialization", (Throwable)exception);
        }
        finally {
            StreamHelper.close((AutoCloseable)outputStream);
        }
        return ESuccess.FAILURE;
    }

    public static @NonNull ESuccess writeToWriter(@NonNull Node node, @WillClose @NonNull Writer writer) {
        return XMLWriter.writeToWriter(node, writer, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @NonNull ESuccess writeToWriter(@NonNull Node node, @WillClose @NonNull Writer writer, @NonNull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull((Object)node, (String)"Node");
        ValueEnforcer.notNull((Object)writer, (String)"Writer");
        ValueEnforcer.notNull((Object)iXMLWriterSettings, (String)"Settings");
        try {
            XMLSerializer xMLSerializer = new XMLSerializer(iXMLWriterSettings);
            xMLSerializer.write(node, writer);
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error("Error in XML serialization", (Throwable)runtimeException);
            throw runtimeException;
        }
        catch (Exception exception) {
            LOGGER.error("Error in XML serialization", (Throwable)exception);
        }
        finally {
            StreamHelper.close((AutoCloseable)writer);
        }
        return ESuccess.FAILURE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @Nullable String getNodeAsString(@NonNull Node node, @NonNull IXMLWriterSettings iXMLWriterSettings) {
        try (NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter(51200);){
            if (!XMLWriter.writeToWriter(node, (Writer)nonBlockingStringWriter, iXMLWriterSettings).isSuccess()) return null;
            STATS_SIZE.addSize((long)nonBlockingStringWriter.size());
            String string = nonBlockingStringWriter.getAsString();
            return string;
        }
        catch (Exception exception) {
            LOGGER.error("Error serializing DOM node with settings " + iXMLWriterSettings.toString(), (Throwable)exception);
        }
        return null;
    }

    public static @Nullable String getNodeAsString(@NonNull Node node) {
        return XMLWriter.getNodeAsString(node, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @Nullable byte[] getNodeAsBytes(@NonNull Node node, @NonNull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull((Object)node, (String)"Node");
        ValueEnforcer.notNull((Object)iXMLWriterSettings, (String)"Settings");
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(51200);){
            if (!XMLWriter.writeToStream(node, (OutputStream)nonBlockingByteArrayOutputStream, iXMLWriterSettings).isSuccess()) return null;
            byte[] byArray = nonBlockingByteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            LOGGER.error("Error serializing DOM node with settings " + iXMLWriterSettings.toString(), (Throwable)exception);
        }
        return null;
    }

    public static @Nullable byte[] getNodeAsBytes(@NonNull Node node) {
        return XMLWriter.getNodeAsBytes(node, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }
}

