/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.xpath;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.compare.CompareHelper;
import com.helger.base.compare.IComparable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import javax.xml.namespace.QName;
import org.jspecify.annotations.NonNull;

@Immutable
public final class XPathFunctionKey
implements IComparable<XPathFunctionKey> {
    private final QName m_aFunctionName;
    private final int m_nArity;

    public XPathFunctionKey(@NonNull QName qName, @Nonnegative int n) {
        this.m_aFunctionName = (QName)ValueEnforcer.notNull((Object)qName, (String)"FunctionName");
        this.m_nArity = ValueEnforcer.isGE0((int)n, (String)"Arity");
    }

    public @NonNull QName getFunctionName() {
        return this.m_aFunctionName;
    }

    @Nonnegative
    public int getArity() {
        return this.m_nArity;
    }

    public int compareTo(@NonNull XPathFunctionKey xPathFunctionKey) {
        int n = CompareHelper.compare((Comparable)((Object)this.m_aFunctionName.getNamespaceURI()), (Comparable)((Object)xPathFunctionKey.m_aFunctionName.getNamespaceURI()));
        if (n == 0 && (n = CompareHelper.compare((Comparable)((Object)this.m_aFunctionName.getLocalPart()), (Comparable)((Object)xPathFunctionKey.m_aFunctionName.getLocalPart()))) == 0) {
            n = CompareHelper.compare((int)this.m_nArity, (int)xPathFunctionKey.m_nArity);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        XPathFunctionKey xPathFunctionKey = (XPathFunctionKey)object;
        return this.m_aFunctionName.equals(xPathFunctionKey.m_aFunctionName) && this.m_nArity == xPathFunctionKey.m_nArity;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aFunctionName).append(this.m_nArity).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("name", (Object)this.m_aFunctionName).append("arity", this.m_nArity).getToString();
    }
}

