/*
 * Decompiled with CFR 0.152.
 */
package com.helger.diver.api.settings;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.diver.api.settings.DVRGlobalCoordinateSettings;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class DVRValidityHelper {
    private DVRValidityHelper() {
    }

    private static boolean _isValidPart(@Nonnull String string, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isTrue(() -> n <= n2, () -> "Min length (" + n + ") must be <= Max length (" + n2 + ")");
        return RegExHelper.stringMatchesPattern((String)("[a-zA-Z0-9_\\-\\.]{" + n + "," + n2 + "}"), (String)string);
    }

    public static boolean isValidCoordinateGroupID(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return false;
        }
        return DVRValidityHelper._isValidPart(string, DVRGlobalCoordinateSettings.getGroupIDMinLen(), DVRGlobalCoordinateSettings.getGroupIDMaxLen());
    }

    public static boolean isValidCoordinateArtifactID(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return false;
        }
        return DVRValidityHelper._isValidPart(string, DVRGlobalCoordinateSettings.getArtifactIDMinLen(), DVRGlobalCoordinateSettings.getArtifactIDMaxLen());
    }

    public static boolean isValidCoordinateVersion(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return false;
        }
        return DVRValidityHelper._isValidPart(string, DVRGlobalCoordinateSettings.getVersionMinLen(), DVRGlobalCoordinateSettings.getVersionMaxLen());
    }

    public static boolean isValidCoordinateClassifier(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return true;
        }
        return DVRValidityHelper._isValidPart(string, DVRGlobalCoordinateSettings.getClassifierMinLen(), DVRGlobalCoordinateSettings.getClassifierMaxLen());
    }
}

