/*
 * Decompiled with CFR 0.152.
 */
package com.helger.diver.api.version;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.version.Version;
import com.helger.diver.api.version.IDVRPseudoVersion;
import com.helger.diver.api.version.IDVRPseudoVersionComparable;
import javax.annotation.Nonnull;

public class DVRPseudoVersion
implements IDVRPseudoVersion {
    private final String m_sID;
    private final IDVRPseudoVersionComparable m_aComparable;

    public DVRPseudoVersion(@Nonnull @Nonempty String string, @Nonnull IDVRPseudoVersionComparable iDVRPseudoVersionComparable) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ID");
        ValueEnforcer.notNull((Object)iDVRPseudoVersionComparable, (String)"Comparable");
        this.m_sID = string;
        this.m_aComparable = iDVRPseudoVersionComparable;
    }

    @Nonnull
    @Nonempty
    public final String getID() {
        return this.m_sID;
    }

    @Override
    public int compareToPseudoVersion(@Nonnull IDVRPseudoVersion iDVRPseudoVersion) {
        ValueEnforcer.notNull((Object)iDVRPseudoVersion, (String)"OtherPseudoVersion");
        if (this.m_sID.equals(iDVRPseudoVersion.getID())) {
            return 0;
        }
        return this.m_aComparable.compareToPseudoVersion(iDVRPseudoVersion);
    }

    @Override
    public int compareToVersion(@Nonnull Version version) {
        ValueEnforcer.notNull((Object)version, (String)"StaticVersion");
        return this.m_aComparable.compareToVersion(version);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        DVRPseudoVersion dVRPseudoVersion = (DVRPseudoVersion)object;
        return this.m_sID.equals(dVRPseudoVersion.m_sID);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("ID", (Object)this.m_sID).append("Comparable", (Object)this.m_aComparable).getToString();
    }
}

