/*
 * Decompiled with CFR 0.152.
 */
package com.helger.diver.api.version;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.version.Version;
import com.helger.diver.api.version.DVRPseudoVersion;
import com.helger.diver.api.version.IDVRPseudoVersion;
import com.helger.diver.api.version.IDVRPseudoVersionComparable;
import com.helger.diver.api.version.IDVRPseudoVersionRegistry;
import com.helger.diver.api.version.spi.IDVRPseudoVersionRegistrarSPI;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DVRPseudoVersionRegistry
implements IDVRPseudoVersionRegistry {
    public static final IDVRPseudoVersion OLDEST = new DVRPseudoVersion("oldest", new IDVRPseudoVersionComparable(){

        @Override
        public int compareToPseudoVersion(@Nonnull IDVRPseudoVersion iDVRPseudoVersion) {
            return -1;
        }

        @Override
        public int compareToVersion(@Nonnull Version version) {
            return -1;
        }
    });
    public static final IDVRPseudoVersion LATEST = new DVRPseudoVersion("latest", new IDVRPseudoVersionComparable(){

        @Override
        public int compareToPseudoVersion(@Nonnull IDVRPseudoVersion iDVRPseudoVersion) {
            return 1;
        }

        @Override
        public int compareToVersion(@Nonnull Version version) {
            return 1;
        }
    });
    public static final IDVRPseudoVersion LATEST_RELEASE = new DVRPseudoVersion("latest-release", new IDVRPseudoVersionComparable(){

        @Override
        public int compareToPseudoVersion(@Nonnull IDVRPseudoVersion iDVRPseudoVersion) {
            if (iDVRPseudoVersion.equals(LATEST)) {
                return -1;
            }
            return 1;
        }

        @Override
        public int compareToVersion(@Nonnull Version version) {
            return 1;
        }
    });
    private static final Logger LOGGER = LoggerFactory.getLogger(DVRPseudoVersionRegistry.class);
    private final ICommonsMap<String, IDVRPseudoVersion> m_aMap = new CommonsHashMap();

    private DVRPseudoVersionRegistry() {
        this._reinitialize(false);
    }

    @Nonnull
    public static DVRPseudoVersionRegistry getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private void _reinitialize(boolean bl) {
        if (bl) {
            LOGGER.info("Reinitializing the DVRPseudoVersionRegistry");
        }
        this.m_aMap.clear();
        for (IDVRPseudoVersionRegistrarSPI iDVRPseudoVersionRegistrarSPI : ServiceLoaderHelper.getAllSPIImplementations(IDVRPseudoVersionRegistrarSPI.class)) {
            iDVRPseudoVersionRegistrarSPI.registerPseudoVersions(this);
        }
        if (bl) {
            LOGGER.info("Finished reinitializing the DVRPseudoVersionRegistry with " + this.m_aMap.size() + " entries");
        }
    }

    public final void reinitialize() {
        this._reinitialize(true);
    }

    @Override
    @Nonnull
    public EChange registerPseudoVersion(@Nonnull IDVRPseudoVersion iDVRPseudoVersion) {
        ValueEnforcer.notNull((Object)iDVRPseudoVersion, (String)"PseudoVersion");
        String string = (String)iDVRPseudoVersion.getID();
        if (this.m_aMap.containsKey((Object)string)) {
            LOGGER.error("Another pseudoversion with ID '" + string + "' is already registered");
            return EChange.UNCHANGED;
        }
        this.m_aMap.put((Object)string, (Object)iDVRPseudoVersion);
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public IDVRPseudoVersion getFromIDOrNull(@Nullable String string) {
        return (IDVRPseudoVersion)this.m_aMap.get((Object)string);
    }

    @Nonnegative
    final int size() {
        return this.m_aMap.size();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        DVRPseudoVersionRegistry dVRPseudoVersionRegistry = (DVRPseudoVersionRegistry)object;
        return this.m_aMap.equals(dVRPseudoVersionRegistry.m_aMap);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMap).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("Map", this.m_aMap).getToString();
    }

    private static final class SingletonHolder {
        static final DVRPseudoVersionRegistry INSTANCE = new DVRPseudoVersionRegistry();

        private SingletonHolder() {
        }
    }
}

