/*
 * Decompiled with CFR 0.152.
 */
package com.helger.en16931.cii2ubl;

import com.helger.commons.CGlobal;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.math.MathHelper;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringHelper;
import com.helger.en16931.cii2ubl.AbstractCIIToUBLConverter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AddressLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AddressType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AllowanceChargeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AttachmentType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.BillingReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.BranchType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CardAccountType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CommodityClassificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ContactType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CountryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CreditNoteLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CustomerPartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DocumentReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ExternalReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.FinancialAccountType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.InvoiceLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ItemIdentificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ItemPropertyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ItemType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.LocationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.MonetaryTotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.OrderLineReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.OrderReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyIdentificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyLegalEntityType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyNameType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyTaxSchemeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentMandateType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentMeansType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentTermsType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PriceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ProjectReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.SupplierPartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxCategoryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxSchemeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxSubtotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxTotalType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.AllowanceChargeReasonType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.AllowanceTotalAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.AmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.BaseAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.BaseQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.ChargeTotalAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.CompanyIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.CreditedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DocumentDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.EmbeddedDocumentBinaryObjectType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.EndpointIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.InvoicedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.ItemClassificationCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.LineExtensionAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.LineIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NameType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PayableAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PayableRoundingAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PaymentIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PaymentMeansCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PrepaidAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PriceAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PrimaryAccountNumberIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TaxAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TaxExclusiveAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TaxExemptionReasonType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TaxInclusiveAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TaxableAmountType;
import oasis.names.specification.ubl.schema.xsd.creditnote_21.CreditNoteType;
import oasis.names.specification.ubl.schema.xsd.invoice_21.InvoiceType;
import un.unece.uncefact.data.standard.crossindustryinvoice._100.CrossIndustryInvoiceType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.FormattedDateTimeType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.DocumentLineDocumentType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.ExchangedDocumentType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.HeaderTradeAgreementType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.HeaderTradeDeliveryType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.HeaderTradeSettlementType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.LegalOrganizationType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.LineTradeDeliveryType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.NoteType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.ProductClassificationType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.ReferencedDocumentType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.SupplyChainTradeTransactionType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TaxRegistrationType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeAccountingAccountType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeAddressType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeAllowanceChargeType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeContactType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeCountryType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradePartyType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradePaymentTermsType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeSettlementHeaderMonetarySummationType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeSettlementPaymentMeansType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeTaxType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.UniversalCommunicationType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.BinaryObjectType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.CodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IDType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.QuantityType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType;

public class CIIToUBL21Converter
extends AbstractCIIToUBLConverter<CIIToUBL21Converter> {
    private static final String UBL_VERSION = "2.1";

    @Nullable
    private static oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType _copyID(@Nullable IDType iDType) {
        return CIIToUBL21Converter._copyID(iDType, new oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType());
    }

    @Nullable
    private static oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NoteType _copyNote(@Nullable NoteType noteType) {
        if (noteType == null) {
            return null;
        }
        oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NoteType noteType2 = new oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NoteType();
        StringBuilder stringBuilder = new StringBuilder();
        for (TextType textType : noteType.getContent()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(textType.getValue());
        }
        noteType2.setValue(stringBuilder.toString());
        return noteType2;
    }

    @Nullable
    private static oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NoteType _copyNote(@Nullable TextType textType) {
        return CIIToUBL21Converter._copyName(textType, new oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NoteType());
    }

    @Nullable
    private static DocumentReferenceType _convertDocumentReference(@Nullable ReferencedDocumentType referencedDocumentType, @Nonnull IErrorList iErrorList) {
        DocumentDescriptionType documentDescriptionType;
        if (referencedDocumentType == null) {
            return null;
        }
        String string = referencedDocumentType.getIssuerAssignedIDValue();
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        DocumentReferenceType documentReferenceType = new DocumentReferenceType();
        documentReferenceType.setID(string).setSchemeID(referencedDocumentType.getReferenceTypeCodeValue());
        FormattedDateTimeType formattedDateTimeType = referencedDocumentType.getFormattedIssueDateTime();
        if (formattedDateTimeType != null) {
            documentReferenceType.setIssueDate(CIIToUBL21Converter._parseDate(formattedDateTimeType.getDateTimeString(), iErrorList));
        }
        for (TextType textType : referencedDocumentType.getName()) {
            documentDescriptionType = new DocumentDescriptionType();
            documentDescriptionType.setValue(textType.getValue());
            documentDescriptionType.setLanguageID(textType.getLanguageID());
            documentDescriptionType.setLanguageLocaleID(textType.getLanguageLocaleID());
            documentReferenceType.addDocumentDescription(documentDescriptionType);
        }
        if (referencedDocumentType.getAttachmentBinaryObjectCount() > 0) {
            TextType textType;
            BinaryObjectType binaryObjectType = referencedDocumentType.getAttachmentBinaryObjectAtIndex(0);
            textType = new AttachmentType();
            documentDescriptionType = new EmbeddedDocumentBinaryObjectType();
            documentDescriptionType.setMimeCode(binaryObjectType.getMimeCode());
            documentDescriptionType.setFilename(binaryObjectType.getFilename());
            documentDescriptionType.setValue(binaryObjectType.getValue());
            textType.setEmbeddedDocumentBinaryObject((EmbeddedDocumentBinaryObjectType)documentDescriptionType);
            String string2 = referencedDocumentType.getURIIDValue();
            if (StringHelper.hasText((String)string2)) {
                ExternalReferenceType externalReferenceType = new ExternalReferenceType();
                externalReferenceType.setURI(string2);
                textType.setExternalReference(externalReferenceType);
            }
            documentReferenceType.setAttachment((AttachmentType)textType);
        }
        return documentReferenceType;
    }

    @Nonnull
    private static AddressType _convertPostalAddress(@Nonnull TradeAddressType tradeAddressType) {
        AddressLineType addressLineType;
        AddressType addressType = new AddressType();
        addressType.setStreetName(tradeAddressType.getLineOneValue());
        if (StringHelper.hasText((String)tradeAddressType.getLineTwoValue())) {
            addressType.setAdditionalStreetName(tradeAddressType.getLineTwoValue());
        }
        if (StringHelper.hasText((String)tradeAddressType.getLineThreeValue())) {
            addressLineType = new AddressLineType();
            addressLineType.setLine(tradeAddressType.getLineThreeValue());
            addressType.addAddressLine(addressLineType);
        }
        addressType.setCityName(tradeAddressType.getCityNameValue());
        addressType.setPostalZone(tradeAddressType.getPostcodeCodeValue());
        if (tradeAddressType.hasCountrySubDivisionNameEntries()) {
            addressType.setCountrySubentity(tradeAddressType.getCountrySubDivisionNameAtIndex(0).getValue());
        }
        if (StringHelper.hasText((String)tradeAddressType.getCountryIDValue())) {
            addressLineType = new CountryType();
            addressLineType.setIdentificationCode(tradeAddressType.getCountryIDValue());
            addressType.setCountry((CountryType)addressLineType);
        }
        return addressType;
    }

    @Nullable
    private static oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType _extractPartyID(@Nonnull TradePartyType tradePartyType) {
        Object object = tradePartyType.hasGlobalIDEntries() ? tradePartyType.getGlobalIDAtIndex(0) : (tradePartyType.hasIDEntries() ? tradePartyType.getIDAtIndex(0) : null);
        return object == null ? null : CIIToUBL21Converter._copyID(object);
    }

    private static void _addPartyID(@Nonnull oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType iDType, @Nonnull PartyType partyType) {
        if (iDType != null && !CollectionHelper.containsAny((Iterable)partyType.getPartyIdentification(), partyIdentificationType -> EqualsHelper.equals((Object)iDType, (Object)partyIdentificationType.getID()))) {
            PartyIdentificationType partyIdentificationType2 = new PartyIdentificationType();
            partyIdentificationType2.setID(iDType);
            partyType.addPartyIdentification(partyIdentificationType2);
        }
    }

    @Nonnull
    private static PartyType _convertParty(@Nonnull TradePartyType tradePartyType) {
        TradeAddressType tradeAddressType;
        UniversalCommunicationType universalCommunicationType;
        PartyType partyType = new PartyType();
        if (tradePartyType.hasURIUniversalCommunicationEntries()) {
            universalCommunicationType = tradePartyType.getURIUniversalCommunicationAtIndex(0);
            partyType.setEndpointID(CIIToUBL21Converter._copyID(universalCommunicationType.getURIID(), new EndpointIDType()));
        }
        CIIToUBL21Converter._addPartyID(CIIToUBL21Converter._extractPartyID(tradePartyType), partyType);
        universalCommunicationType = tradePartyType.getName();
        if (universalCommunicationType != null) {
            tradeAddressType = new PartyNameType();
            tradeAddressType.setName(CIIToUBL21Converter._copyName((TextType)universalCommunicationType, new NameType()));
            partyType.addPartyName((PartyNameType)tradeAddressType);
        }
        if ((tradeAddressType = tradePartyType.getPostalTradeAddress()) != null) {
            partyType.setPostalAddress(CIIToUBL21Converter._convertPostalAddress(tradeAddressType));
        }
        return partyType;
    }

    @Nonnull
    private PartyTaxSchemeType _convertPartyTaxScheme(@Nonnull TaxRegistrationType taxRegistrationType) {
        if (taxRegistrationType.getID() == null) {
            return null;
        }
        PartyTaxSchemeType partyTaxSchemeType = new PartyTaxSchemeType();
        partyTaxSchemeType.setCompanyID(taxRegistrationType.getIDValue());
        String string = taxRegistrationType.getID().getSchemeID();
        if (StringHelper.hasNoText((String)string)) {
            string = this.getVATScheme();
        } else if ("VA".equals(string)) {
            string = this.getVATScheme();
        }
        TaxSchemeType taxSchemeType = new TaxSchemeType();
        taxSchemeType.setID(string);
        partyTaxSchemeType.setTaxScheme(taxSchemeType);
        return partyTaxSchemeType;
    }

    @Nullable
    private static PartyLegalEntityType _convertPartyLegalEntity(@Nonnull TradePartyType tradePartyType) {
        PartyLegalEntityType partyLegalEntityType = new PartyLegalEntityType();
        LegalOrganizationType legalOrganizationType = tradePartyType.getSpecifiedLegalOrganization();
        if (legalOrganizationType != null) {
            if (StringHelper.hasText((String)legalOrganizationType.getTradingBusinessNameValue())) {
                partyLegalEntityType.setRegistrationName(legalOrganizationType.getTradingBusinessNameValue());
            }
            partyLegalEntityType.setCompanyID(CIIToUBL21Converter._copyID(legalOrganizationType.getID(), new CompanyIDType()));
        }
        for (TextType textType : tradePartyType.getDescription()) {
            if (!StringHelper.hasText((String)textType.getValue())) continue;
            partyLegalEntityType.setCompanyLegalForm(textType.getValue());
            break;
        }
        if (partyLegalEntityType.getRegistrationName() == null) {
            partyLegalEntityType.setRegistrationName(tradePartyType.getNameValue());
        }
        return partyLegalEntityType;
    }

    @Nullable
    private static ContactType _convertContact(@Nonnull TradePartyType tradePartyType) {
        UniversalCommunicationType universalCommunicationType;
        UniversalCommunicationType universalCommunicationType2;
        if (!tradePartyType.hasDefinedTradeContactEntries()) {
            return null;
        }
        TradeContactType tradeContactType = tradePartyType.getDefinedTradeContactAtIndex(0);
        ContactType contactType = new ContactType();
        boolean bl = false;
        if (tradeContactType.getPersonName() != null) {
            contactType.setName(CIIToUBL21Converter._copyName(tradeContactType.getPersonName(), new NameType()));
            bl = true;
        }
        if ((universalCommunicationType2 = tradeContactType.getTelephoneUniversalCommunication()) != null) {
            contactType.setTelephone(universalCommunicationType2.getCompleteNumberValue());
            bl = true;
        }
        if ((universalCommunicationType = tradeContactType.getEmailURIUniversalCommunication()) != null) {
            contactType.setElectronicMail(universalCommunicationType.getURIIDValue());
            bl = true;
        }
        return bl ? contactType : null;
    }

    @Nullable
    private static AmountType _copyAmount(@Nullable un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType amountType, @Nullable String string) {
        return CIIToUBL21Converter._copyAmount(amountType, new AmountType(), string);
    }

    private void _copyAllowanceCharge(@Nonnull TradeAllowanceChargeType tradeAllowanceChargeType, @Nonnull AllowanceChargeType allowanceChargeType, @Nullable String string) {
        if (StringHelper.hasText((String)tradeAllowanceChargeType.getReasonCodeValue())) {
            allowanceChargeType.setAllowanceChargeReasonCode(tradeAllowanceChargeType.getReasonCodeValue());
        }
        if (tradeAllowanceChargeType.getReason() != null) {
            AllowanceChargeReasonType allowanceChargeReasonType = new AllowanceChargeReasonType();
            allowanceChargeReasonType.setValue(tradeAllowanceChargeType.getReasonValue());
            allowanceChargeType.addAllowanceChargeReason(allowanceChargeReasonType);
        }
        if (tradeAllowanceChargeType.getCalculationPercent() != null) {
            allowanceChargeType.setMultiplierFactorNumeric(tradeAllowanceChargeType.getCalculationPercentValue().divide(CGlobal.BIGDEC_100));
        }
        if (tradeAllowanceChargeType.hasActualAmountEntries()) {
            allowanceChargeType.setAmount(CIIToUBL21Converter._copyAmount(tradeAllowanceChargeType.getActualAmountAtIndex(0), string));
        }
        allowanceChargeType.setBaseAmount(CIIToUBL21Converter._copyAmount(tradeAllowanceChargeType.getBasisAmount(), new BaseAmountType(), string));
        for (TradeTaxType tradeTaxType : tradeAllowanceChargeType.getCategoryTradeTax()) {
            TaxCategoryType taxCategoryType = new TaxCategoryType();
            taxCategoryType.setID(tradeTaxType.getCategoryCodeValue());
            if (tradeTaxType.getRateApplicablePercentValue() != null) {
                taxCategoryType.setPercent(tradeTaxType.getRateApplicablePercentValue());
            }
            TaxSchemeType taxSchemeType = new TaxSchemeType();
            taxSchemeType.setID(this.getVATScheme());
            taxCategoryType.setTaxScheme(taxSchemeType);
            allowanceChargeType.addTaxCategory(taxCategoryType);
        }
    }

    private void _convertPaymentMeans(@Nonnull HeaderTradeSettlementType headerTradeSettlementType, @Nonnull TradeSettlementPaymentMeansType tradeSettlementPaymentMeansType, @Nonnull Consumer<oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType> consumer, @Nonnull Consumer<PaymentMeansType> consumer2, @Nonnull ErrorList errorList) {
        boolean bl;
        boolean bl2;
        IDType iDType;
        CardAccountType cardAccountType;
        PaymentIDType paymentIDType;
        String string = tradeSettlementPaymentMeansType.getTypeCodeValue();
        PaymentMeansType paymentMeansType = new PaymentMeansType();
        PaymentMeansCodeType paymentMeansCodeType = new PaymentMeansCodeType();
        paymentMeansCodeType.setValue(string);
        if (tradeSettlementPaymentMeansType.hasInformationEntries()) {
            paymentMeansCodeType.setName(tradeSettlementPaymentMeansType.getInformationAtIndex(0).getValue());
        }
        paymentMeansType.setPaymentMeansCode(paymentMeansCodeType);
        for (TextType textType : headerTradeSettlementType.getPaymentReference()) {
            paymentIDType = new PaymentIDType();
            paymentIDType.setValue(textType.getValue());
            paymentMeansType.addPaymentID(paymentIDType);
        }
        boolean bl3 = CIIToUBL21Converter.isPaymentMeansCodeCreditTransfer(string);
        if (bl3) {
            TextType textType;
            textType = tradeSettlementPaymentMeansType.getPayeePartyCreditorFinancialAccount();
            if (textType == null) {
                errorList.add((Object)CIIToUBL21Converter._buildError(null, "The element 'PayeePartyCreditorFinancialAccount' is missing for Credit Transfer"));
            } else {
                paymentIDType = new FinancialAccountType();
                paymentIDType.setID(CIIToUBL21Converter._copyID(textType.getIBANID()));
                if (paymentIDType.getID() == null) {
                    paymentIDType.setID(CIIToUBL21Converter._copyID(textType.getProprietaryID()));
                }
                paymentIDType.setName(CIIToUBL21Converter._copyName(textType.getAccountName(), new NameType()));
                cardAccountType = tradeSettlementPaymentMeansType.getPayeeSpecifiedCreditorFinancialInstitution();
                if (cardAccountType != null) {
                    iDType = new BranchType();
                    iDType.setID(CIIToUBL21Converter._copyID(cardAccountType.getBICID()));
                    paymentIDType.setFinancialInstitutionBranch((BranchType)iDType);
                }
                paymentMeansType.setPayeeFinancialAccount((FinancialAccountType)paymentIDType);
            }
        }
        if (bl2 = CIIToUBL21Converter.isPaymentMeansCodePaymentCard(string)) {
            paymentIDType = tradeSettlementPaymentMeansType.getApplicableTradeSettlementFinancialCard();
            if (paymentIDType == null) {
                errorList.add((Object)CIIToUBL21Converter._buildError(null, "The element 'ApplicableTradeSettlementFinancialCard' is missing for Payment Card Information"));
            } else {
                cardAccountType = new CardAccountType();
                cardAccountType.setPrimaryAccountNumberID(CIIToUBL21Converter._copyID(paymentIDType.getID(), new PrimaryAccountNumberIDType()));
                cardAccountType.setNetworkID(this.getCardAccountNetworkID());
                cardAccountType.setHolderName(paymentIDType.getCardholderNameValue());
                if (StringHelper.hasNoText((String)cardAccountType.getPrimaryAccountNumberIDValue())) {
                    errorList.add((Object)CIIToUBL21Converter._buildError(null, "The Payment card primary account number is missing"));
                } else if (StringHelper.hasNoText((String)cardAccountType.getNetworkIDValue())) {
                    errorList.add((Object)CIIToUBL21Converter._buildError(null, "The Payment card network ID is missing"));
                } else {
                    paymentMeansType.setCardAccount(cardAccountType);
                }
            }
        }
        if (bl = CIIToUBL21Converter.isPaymentMeansCodeDirectDebit(string)) {
            TradePaymentTermsType tradePaymentTermsType;
            cardAccountType = new PaymentMandateType();
            iDType = headerTradeSettlementType.getSpecifiedTradePaymentTerms().iterator();
            while (iDType.hasNext()) {
                tradePaymentTermsType = (TradePaymentTermsType)iDType.next();
                if (!tradePaymentTermsType.hasDirectDebitMandateIDEntries()) continue;
                cardAccountType.setID(CIIToUBL21Converter._copyID(tradePaymentTermsType.getDirectDebitMandateIDAtIndex(0)));
                if (cardAccountType.getID() == null) continue;
                break;
            }
            if ((iDType = headerTradeSettlementType.getCreditorReferenceID()) != null) {
                tradePaymentTermsType = CIIToUBL21Converter._copyID(iDType);
                tradePaymentTermsType.setSchemeID("SEPA");
                consumer.accept((oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType)tradePaymentTermsType);
            }
            if ((tradePaymentTermsType = tradeSettlementPaymentMeansType.getPayerPartyDebtorFinancialAccount()) != null) {
                FinancialAccountType financialAccountType = new FinancialAccountType();
                financialAccountType.setID(CIIToUBL21Converter._copyID(tradePaymentTermsType.getIBANID()));
                if (financialAccountType.getID() != null) {
                    cardAccountType.setPayerFinancialAccount(financialAccountType);
                }
            }
            paymentMeansType.setPaymentMandate((PaymentMandateType)cardAccountType);
        }
        if (bl3 || bl2 || bl || CIIToUBL21Converter.isPaymentMeansCodeOtherKnown(string)) {
            consumer2.accept(paymentMeansType);
        } else {
            errorList.add((Object)CIIToUBL21Converter._buildError(null, "Failed to determine a supported Payment Means Type from code '" + string + "'"));
        }
    }

    @Nullable
    public InvoiceType convertToInvoice(@Nonnull CrossIndustryInvoiceType crossIndustryInvoiceType, @Nonnull ErrorList errorList) {
        Object object;
        PartyType partyType;
        TextType textType;
        TradeAddressType tradeAddressType;
        oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType iDType22;
        Object object2;
        PeriodType periodType2;
        Object object32;
        Object object42;
        ValueEnforcer.notNull((Object)crossIndustryInvoiceType, (String)"CIIInvoice");
        ValueEnforcer.notNull((Object)errorList, (String)"ErrorList");
        ExchangedDocumentType exchangedDocumentType = crossIndustryInvoiceType.getExchangedDocument();
        SupplyChainTradeTransactionType supplyChainTradeTransactionType = crossIndustryInvoiceType.getSupplyChainTradeTransaction();
        if (supplyChainTradeTransactionType == null) {
            return null;
        }
        HeaderTradeAgreementType headerTradeAgreementType = supplyChainTradeTransactionType.getApplicableHeaderTradeAgreement();
        HeaderTradeDeliveryType headerTradeDeliveryType = supplyChainTradeTransactionType.getApplicableHeaderTradeDelivery();
        HeaderTradeSettlementType headerTradeSettlementType = supplyChainTradeTransactionType.getApplicableHeaderTradeSettlement();
        if (headerTradeAgreementType == null || headerTradeDeliveryType == null || headerTradeSettlementType == null) {
            return null;
        }
        InvoiceType invoiceType = new InvoiceType();
        invoiceType.setCustomizationID(this.getCustomizationID());
        invoiceType.setProfileID(this.getProfileID());
        if (exchangedDocumentType != null) {
            invoiceType.setID(exchangedDocumentType.getIDValue());
        }
        SupplierPartyType supplierPartyType = new SupplierPartyType();
        invoiceType.setAccountingSupplierParty(supplierPartyType);
        CustomerPartyType customerPartyType = new CustomerPartyType();
        invoiceType.setAccountingCustomerParty(customerPartyType);
        Object object5 = null;
        if (exchangedDocumentType != null && exchangedDocumentType.getIssueDateTime() != null) {
            object5 = CIIToUBL21Converter._parseDate(exchangedDocumentType.getIssueDateTime().getDateTimeString(), (IErrorList)errorList);
        }
        if (object5 != null) {
            invoiceType.setIssueDate(object5);
        }
        object5 = null;
        Object object62 = headerTradeSettlementType.getSpecifiedTradePaymentTerms().iterator();
        while (object62.hasNext() && ((object42 = (TradePaymentTermsType)object62.next()).getDueDateDateTime() == null || (object5 = CIIToUBL21Converter._parseDate(object42.getDueDateDateTime().getDateTimeString(), (IErrorList)errorList)) == null)) {
        }
        if (object5 != null) {
            invoiceType.setDueDate((LocalDate)object5);
        }
        if (exchangedDocumentType != null) {
            invoiceType.setInvoiceTypeCode(exchangedDocumentType.getTypeCodeValue());
        }
        if (exchangedDocumentType != null) {
            for (Object object62 : exchangedDocumentType.getIncludedNote()) {
                invoiceType.addNote(CIIToUBL21Converter._copyNote((NoteType)object62));
            }
        }
        for (Object object62 : headerTradeSettlementType.getApplicableTradeTax()) {
            if (object62.getTaxPointDate() == null || (object42 = CIIToUBL21Converter._parseDate(object62.getTaxPointDate().getDateString(), (IErrorList)errorList)) == null) continue;
            invoiceType.setTaxPointDate((LocalDate)object42);
            break;
        }
        object5 = headerTradeSettlementType.getInvoiceCurrencyCodeValue();
        invoiceType.setDocumentCurrencyCode((String)object5);
        if (headerTradeSettlementType.getTaxCurrencyCodeValue() != null) {
            invoiceType.setTaxCurrencyCode(headerTradeSettlementType.getTaxCurrencyCodeValue());
        }
        object62 = headerTradeSettlementType.getReceivableSpecifiedTradeAccountingAccount().iterator();
        while (object62.hasNext()) {
            object42 = (TradeAccountingAccountType)object62.next();
            object32 = object42.getIDValue();
            if (!StringHelper.hasText((String)object32)) continue;
            invoiceType.setAccountingCost((String)object32);
            break;
        }
        if (headerTradeAgreementType.getBuyerReferenceValue() != null) {
            invoiceType.setBuyerReference(headerTradeAgreementType.getBuyerReferenceValue());
        }
        if ((object62 = headerTradeSettlementType.getBillingSpecifiedPeriod()) != null) {
            object42 = object62.getStartDateTime();
            object32 = object62.getEndDateTime();
            if (object42 != null && object32 != null) {
                periodType2 = new PeriodType();
                periodType2.setStartDate(CIIToUBL21Converter._parseDate(object42.getDateTimeString(), (IErrorList)errorList));
                periodType2.setEndDate(CIIToUBL21Converter._parseDate(object32.getDateTimeString(), (IErrorList)errorList));
                invoiceType.addInvoicePeriod(periodType2);
            }
        }
        object62 = new OrderReferenceType();
        object42 = headerTradeAgreementType.getBuyerOrderReferencedDocument();
        if (object42 != null) {
            object62.setID(object42.getIssuerAssignedIDValue());
        }
        if ((object32 = headerTradeAgreementType.getSellerOrderReferencedDocument()) != null) {
            if (object62.getIDValue() == null) {
                object62.setID("");
            }
            object62.setSalesOrderID(object32.getIssuerAssignedIDValue());
        }
        if (object62.getIDValue() != null || object62.getSalesOrderIDValue() != null) {
            invoiceType.setOrderReference((OrderReferenceType)object62);
        }
        if ((object62 = CIIToUBL21Converter._convertDocumentReference(headerTradeSettlementType.getInvoiceReferencedDocument(), (IErrorList)errorList)) != null) {
            object42 = new BillingReferenceType();
            object42.setInvoiceDocumentReference((DocumentReferenceType)object62);
            invoiceType.addBillingReference((BillingReferenceType)object42);
        }
        if ((object62 = CIIToUBL21Converter._convertDocumentReference(headerTradeDeliveryType.getDespatchAdviceReferencedDocument(), (IErrorList)errorList)) != null) {
            invoiceType.addDespatchDocumentReference((DocumentReferenceType)object62);
        }
        if ((object62 = CIIToUBL21Converter._convertDocumentReference(headerTradeDeliveryType.getReceivingAdviceReferencedDocument(), (IErrorList)errorList)) != null) {
            invoiceType.addReceiptDocumentReference((DocumentReferenceType)object62);
        }
        for (Object object42 : headerTradeAgreementType.getAdditionalReferencedDocument()) {
            if (!CIIToUBL21Converter.isOriginatorDocumentReferenceTypeCode(object42.getTypeCodeValue()) || (object32 = CIIToUBL21Converter._convertDocumentReference((ReferencedDocumentType)object42, (IErrorList)errorList)) == null) continue;
            invoiceType.addOriginatorDocumentReference((DocumentReferenceType)object32);
        }
        object62 = CIIToUBL21Converter._convertDocumentReference(headerTradeAgreementType.getContractReferencedDocument(), (IErrorList)errorList);
        if (object62 != null) {
            invoiceType.addContractDocumentReference((DocumentReferenceType)object62);
        }
        for (Object object42 : headerTradeAgreementType.getAdditionalReferencedDocument()) {
            if (CIIToUBL21Converter.isOriginatorDocumentReferenceTypeCode(object42.getTypeCodeValue()) || (object32 = CIIToUBL21Converter._convertDocumentReference((ReferencedDocumentType)object42, (IErrorList)errorList)) == null) continue;
            invoiceType.addAdditionalDocumentReference((DocumentReferenceType)object32);
        }
        object62 = headerTradeAgreementType.getSpecifiedProcuringProject();
        if (object62 != null && StringHelper.hasText((String)(object42 = object62.getIDValue()))) {
            object32 = new ProjectReferenceType();
            object32.setID((String)object42);
            invoiceType.addProjectReference((ProjectReferenceType)object32);
        }
        if ((object62 = headerTradeAgreementType.getSellerTradeParty()) != null) {
            object42 = CIIToUBL21Converter._convertParty((TradePartyType)object62);
            for (PeriodType periodType2 : object62.getSpecifiedTaxRegistration()) {
                object2 = this._convertPartyTaxScheme((TaxRegistrationType)periodType2);
                if (object2 == null) continue;
                object42.addPartyTaxScheme((PartyTaxSchemeType)object2);
            }
            object32 = CIIToUBL21Converter._convertPartyLegalEntity((TradePartyType)object62);
            if (object32 != null) {
                object42.addPartyLegalEntity((PartyLegalEntityType)object32);
            }
            if ((periodType2 = CIIToUBL21Converter._convertContact((TradePartyType)object62)) != null) {
                object42.setContact((ContactType)periodType2);
            }
            supplierPartyType.setParty((PartyType)object42);
        }
        if ((object62 = headerTradeAgreementType.getBuyerTradeParty()) != null) {
            object42 = CIIToUBL21Converter._convertParty((TradePartyType)object62);
            for (PeriodType periodType2 : object62.getSpecifiedTaxRegistration()) {
                object2 = this._convertPartyTaxScheme((TaxRegistrationType)periodType2);
                if (object2 == null) continue;
                object42.addPartyTaxScheme((PartyTaxSchemeType)object2);
            }
            object32 = CIIToUBL21Converter._convertPartyLegalEntity((TradePartyType)object62);
            if (object32 != null) {
                object42.addPartyLegalEntity((PartyLegalEntityType)object32);
            }
            if ((periodType2 = CIIToUBL21Converter._convertContact((TradePartyType)object62)) != null) {
                object42.setContact((ContactType)periodType2);
            }
            customerPartyType.setParty((PartyType)object42);
        }
        if ((object62 = headerTradeSettlementType.getPayeeTradeParty()) != null) {
            object42 = CIIToUBL21Converter._convertParty((TradePartyType)object62);
            for (PeriodType periodType2 : object62.getSpecifiedTaxRegistration()) {
                object2 = this._convertPartyTaxScheme((TaxRegistrationType)periodType2);
                if (object2 == null) continue;
                object42.addPartyTaxScheme((PartyTaxSchemeType)object2);
            }
            object32 = CIIToUBL21Converter._convertContact((TradePartyType)object62);
            if (object32 != null) {
                object42.setContact((ContactType)object32);
            }
            invoiceType.setPayeeParty((PartyType)object42);
        }
        if ((object62 = headerTradeAgreementType.getSellerTaxRepresentativeTradeParty()) != null) {
            object42 = CIIToUBL21Converter._convertParty((TradePartyType)object62);
            for (PeriodType periodType2 : object62.getSpecifiedTaxRegistration()) {
                object2 = this._convertPartyTaxScheme((TaxRegistrationType)periodType2);
                if (object2 == null) continue;
                object42.addPartyTaxScheme((PartyTaxSchemeType)object2);
            }
            object32 = CIIToUBL21Converter._convertContact((TradePartyType)object62);
            if (object32 != null) {
                object42.setContact((ContactType)object32);
            }
            invoiceType.setTaxRepresentativeParty((PartyType)object42);
        }
        object62 = new DeliveryType();
        boolean bl = false;
        object32 = headerTradeDeliveryType.getActualDeliverySupplyChainEvent();
        if (object32 != null && (periodType2 = object32.getOccurrenceDateTime()) != null) {
            object62.setActualDeliveryDate(CIIToUBL21Converter._parseDate(periodType2.getDateTimeString(), (IErrorList)errorList));
            bl = true;
        }
        if ((periodType2 = headerTradeDeliveryType.getShipToTradeParty()) != null) {
            object2 = new LocationType();
            boolean bl2 = false;
            iDType22 = CIIToUBL21Converter._extractPartyID((TradePartyType)periodType2);
            if (iDType22 != null) {
                object2.setID(iDType22);
                bl2 = true;
            }
            if ((tradeAddressType = periodType2.getPostalTradeAddress()) != null) {
                object2.setAddress(CIIToUBL21Converter._convertPostalAddress(tradeAddressType));
                bl2 = true;
            }
            if (bl2) {
                object62.setDeliveryLocation((LocationType)object2);
                bl = true;
            }
            if ((textType = periodType2.getName()) != null) {
                partyType = new PartyType();
                object = new PartyNameType();
                object.setName(CIIToUBL21Converter._copyName(textType, new NameType()));
                partyType.addPartyName((PartyNameType)object);
                object62.setDeliveryParty(partyType);
                bl = true;
            }
        }
        if (bl) {
            invoiceType.addDelivery((DeliveryType)object62);
        }
        for (TradeSettlementPaymentMeansType tradeSettlementPaymentMeansType : headerTradeSettlementType.getSpecifiedTradeSettlementPaymentMeans()) {
            this._convertPaymentMeans(headerTradeSettlementType, tradeSettlementPaymentMeansType, iDType -> CIIToUBL21Converter._addPartyID(iDType, invoiceType.getAccountingSupplierParty().getParty()), arg_0 -> ((InvoiceType)invoiceType).addPaymentMeans(arg_0), errorList);
        }
        for (TradePaymentTermsType tradePaymentTermsType : headerTradeSettlementType.getSpecifiedTradePaymentTerms()) {
            boolean bl3 = false;
            periodType2 = new PaymentTermsType();
            for (TextType textType2 : tradePaymentTermsType.getDescription()) {
                periodType2.addNote(CIIToUBL21Converter._copyNote(textType2));
                bl3 = true;
            }
            if (!bl3) continue;
            invoiceType.addPaymentTerms((PaymentTermsType)periodType2);
        }
        for (TradeAllowanceChargeType tradeAllowanceChargeType : headerTradeSettlementType.getSpecifiedTradeAllowanceCharge()) {
            object32 = ETriState.UNDEFINED;
            if (tradeAllowanceChargeType.getChargeIndicator() != null) {
                object32 = CIIToUBL21Converter._parseIndicator(tradeAllowanceChargeType.getChargeIndicator(), (IErrorList)errorList);
            } else {
                errorList.add((Object)CIIToUBL21Converter._buildError(new String[]{"CrossIndustryInvoice", "SupplyChainTradeTransaction", "ApplicableHeaderTradeSettlement", "SpecifiedTradeAllowanceCharge"}, "Failed to determine if SpecifiedTradeAllowanceCharge is an Allowance or a Charge"));
            }
            if (!object32.isDefined()) continue;
            periodType2 = new AllowanceChargeType();
            periodType2.setChargeIndicator(object32.getAsBooleanValue());
            this._copyAllowanceCharge(tradeAllowanceChargeType, (AllowanceChargeType)periodType2, (String)object5);
            invoiceType.addAllowanceCharge((AllowanceChargeType)periodType2);
        }
        object62 = headerTradeSettlementType.getSpecifiedTradeSettlementHeaderMonetarySummation();
        Object object7 = null;
        if (object62 != null && object62.hasTaxTotalAmountEntries()) {
            for (PeriodType periodType2 : object62.getTaxTotalAmount()) {
                object2 = new TaxTotalType();
                object2.setTaxAmount(CIIToUBL21Converter._copyAmount((un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType)periodType2, new TaxAmountType(), (String)object5));
                invoiceType.addTaxTotal((TaxTotalType)object2);
                if (object7 != null) continue;
                object7 = object2;
            }
        } else {
            object32 = new TaxAmountType();
            object32.setValue(BigDecimal.ZERO);
            object32.setCurrencyID((String)object5);
            object7 = new TaxTotalType();
            object7.setTaxAmount((TaxAmountType)object32);
            invoiceType.addTaxTotal((TaxTotalType)object7);
        }
        for (PeriodType periodType2 : headerTradeSettlementType.getApplicableTradeTax()) {
            object2 = new TaxSubtotalType();
            if (periodType2.hasBasisAmountEntries()) {
                object2.setTaxableAmount(CIIToUBL21Converter._copyAmount(periodType2.getBasisAmountAtIndex(0), new TaxableAmountType(), (String)object5));
            }
            if (periodType2.hasCalculatedAmountEntries()) {
                object2.setTaxAmount(CIIToUBL21Converter._copyAmount(periodType2.getCalculatedAmountAtIndex(0), new TaxAmountType(), (String)object5));
            }
            TaxCategoryType taxCategoryType = new TaxCategoryType();
            taxCategoryType.setID(periodType2.getCategoryCodeValue());
            if (periodType2.getRateApplicablePercentValue() != null) {
                taxCategoryType.setPercent(periodType2.getRateApplicablePercentValue());
            }
            if (StringHelper.hasText((String)periodType2.getExemptionReasonCodeValue())) {
                taxCategoryType.setTaxExemptionReasonCode(periodType2.getExemptionReasonCodeValue());
            }
            if (periodType2.getExemptionReason() != null) {
                iDType22 = new TaxExemptionReasonType();
                iDType22.setValue(periodType2.getExemptionReason().getValue());
                iDType22.setLanguageID(periodType2.getExemptionReason().getLanguageID());
                iDType22.setLanguageLocaleID(periodType2.getExemptionReason().getLanguageLocaleID());
                taxCategoryType.addTaxExemptionReason((TaxExemptionReasonType)iDType22);
            }
            iDType22 = new TaxSchemeType();
            iDType22.setID(this.getVATScheme());
            taxCategoryType.setTaxScheme((TaxSchemeType)iDType22);
            object2.setTaxCategory(taxCategoryType);
            object7.addTaxSubtotal((TaxSubtotalType)object2);
        }
        object7 = new MonetaryTotalType();
        if (object62 != null) {
            if (object62.hasLineTotalAmountEntries()) {
                object7.setLineExtensionAmount(CIIToUBL21Converter._copyAmount(object62.getLineTotalAmountAtIndex(0), new LineExtensionAmountType(), (String)object5));
            }
            if (object62.hasTaxBasisTotalAmountEntries()) {
                object7.setTaxExclusiveAmount(CIIToUBL21Converter._copyAmount(object62.getTaxBasisTotalAmountAtIndex(0), new TaxExclusiveAmountType(), (String)object5));
            }
            if (object62.hasGrandTotalAmountEntries()) {
                object7.setTaxInclusiveAmount(CIIToUBL21Converter._copyAmount(object62.getGrandTotalAmountAtIndex(0), new TaxInclusiveAmountType(), (String)object5));
            }
            if (object62.hasAllowanceTotalAmountEntries()) {
                object7.setAllowanceTotalAmount(CIIToUBL21Converter._copyAmount(object62.getAllowanceTotalAmountAtIndex(0), new AllowanceTotalAmountType(), (String)object5));
            }
            if (object62.hasChargeTotalAmountEntries()) {
                object7.setChargeTotalAmount(CIIToUBL21Converter._copyAmount(object62.getChargeTotalAmountAtIndex(0), new ChargeTotalAmountType(), (String)object5));
            }
            if (object62.hasTotalPrepaidAmountEntries()) {
                object7.setPrepaidAmount(CIIToUBL21Converter._copyAmount(object62.getTotalPrepaidAmountAtIndex(0), new PrepaidAmountType(), (String)object5));
            }
            if (object62.hasRoundingAmountEntries() && MathHelper.isNE0((BigDecimal)object62.getRoundingAmountAtIndex(0).getValue())) {
                object7.setPayableRoundingAmount(CIIToUBL21Converter._copyAmount(object62.getRoundingAmountAtIndex(0), new PayableRoundingAmountType(), (String)object5));
            }
            if (object62.hasDuePayableAmountEntries()) {
                object7.setPayableAmount(CIIToUBL21Converter._copyAmount(object62.getDuePayableAmountAtIndex(0), new PayableAmountType(), (String)object5));
            }
        }
        invoiceType.setLegalMonetaryTotal((MonetaryTotalType)object7);
        for (Object object32 : supplyChainTradeTransactionType.getIncludedSupplyChainTradeLineItem()) {
            Object object8;
            TradeCountryType tradeCountryType;
            Object object9;
            TaxCategoryType taxCategoryType;
            IDType iDType32;
            Object object10;
            OrderLineReferenceType orderLineReferenceType2;
            periodType2 = new InvoiceLineType();
            object2 = object32.getAssociatedDocumentLineDocument();
            periodType2.setID(CIIToUBL21Converter._copyID(object2.getLineID()));
            for (oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType iDType22 : object2.getIncludedNote()) {
                periodType2.addNote(CIIToUBL21Converter._copyNote((NoteType)iDType22));
            }
            LineTradeDeliveryType lineTradeDeliveryType = object32.getSpecifiedLineTradeDelivery();
            if (lineTradeDeliveryType != null && (iDType22 = lineTradeDeliveryType.getBilledQuantity()) != null) {
                periodType2.setInvoicedQuantity(CIIToUBL21Converter._copyQuantity((QuantityType)iDType22, new InvoicedQuantityType()));
            }
            if ((tradeAddressType = (iDType22 = object32.getSpecifiedLineTradeSettlement()).getSpecifiedTradeSettlementLineMonetarySummation()) != null && tradeAddressType.hasLineTotalAmountEntries()) {
                periodType2.setLineExtensionAmount(CIIToUBL21Converter._copyAmount(tradeAddressType.getLineTotalAmountAtIndex(0), new LineExtensionAmountType(), (String)object5));
            }
            if (iDType22.hasReceivableSpecifiedTradeAccountingAccountEntries()) {
                textType = iDType22.getReceivableSpecifiedTradeAccountingAccountAtIndex(0);
                periodType2.setAccountingCost(textType.getIDValue());
            }
            if ((textType = iDType22.getBillingSpecifiedPeriod()) != null) {
                partyType = new PeriodType();
                if (textType.getStartDateTime() != null) {
                    partyType.setStartDate(CIIToUBL21Converter._parseDate(textType.getStartDateTime().getDateTimeString(), (IErrorList)errorList));
                }
                if (textType.getEndDateTime() != null) {
                    partyType.setEndDate(CIIToUBL21Converter._parseDate(textType.getEndDateTime().getDateTimeString(), (IErrorList)errorList));
                }
                periodType2.addInvoicePeriod((PeriodType)partyType);
            }
            if ((partyType = object32.getSpecifiedLineTradeAgreement()) != null && (object = partyType.getBuyerOrderReferencedDocument()) != null) {
                orderLineReferenceType2 = new OrderLineReferenceType();
                orderLineReferenceType2.setLineID(CIIToUBL21Converter._copyID(object.getLineID(), new LineIDType()));
                periodType2.addOrderLineReference(orderLineReferenceType2);
            }
            for (OrderLineReferenceType orderLineReferenceType2 : iDType22.getAdditionalReferencedDocument()) {
                object10 = CIIToUBL21Converter._convertDocumentReference((ReferencedDocumentType)orderLineReferenceType2, (IErrorList)errorList);
                if (object10 == null) continue;
                periodType2.addDocumentReference((DocumentReferenceType)object10);
            }
            for (OrderLineReferenceType orderLineReferenceType2 : iDType22.getSpecifiedTradeAllowanceCharge()) {
                object10 = ETriState.UNDEFINED;
                if (orderLineReferenceType2.getChargeIndicator() != null) {
                    object10 = CIIToUBL21Converter._parseIndicator(orderLineReferenceType2.getChargeIndicator(), (IErrorList)errorList);
                } else {
                    errorList.add((Object)CIIToUBL21Converter._buildError(new String[]{"CrossIndustryInvoice", "SupplyChainTradeTransaction", "IncludedSupplyChainTradeLineItem", "SpecifiedLineTradeSettlement", "SpecifiedTradeAllowanceCharge"}, "Failed to determine if SpecifiedTradeAllowanceCharge is an Allowance or a Charge"));
                }
                if (!object10.isDefined()) continue;
                iDType32 = new AllowanceChargeType();
                iDType32.setChargeIndicator(object10.getAsBooleanValue());
                this._copyAllowanceCharge((TradeAllowanceChargeType)orderLineReferenceType2, (AllowanceChargeType)iDType32, (String)object5);
                periodType2.addAllowanceCharge((AllowanceChargeType)iDType32);
            }
            object = new ItemType();
            orderLineReferenceType2 = object32.getSpecifiedTradeProduct();
            if (orderLineReferenceType2 != null) {
                object10 = orderLineReferenceType2.getDescription();
                if (object10 != null) {
                    object.addDescription(CIIToUBL21Converter._copyName((TextType)object10, new DescriptionType()));
                }
                if (orderLineReferenceType2.hasNameEntries()) {
                    object.setName(CIIToUBL21Converter._copyName(orderLineReferenceType2.getNameAtIndex(0), new NameType()));
                }
                if ((iDType32 = orderLineReferenceType2.getBuyerAssignedID()) != null) {
                    taxCategoryType = new ItemIdentificationType();
                    taxCategoryType.setID(CIIToUBL21Converter._copyID(iDType32));
                    object.setBuyersItemIdentification((ItemIdentificationType)taxCategoryType);
                }
                if ((taxCategoryType = orderLineReferenceType2.getSellerAssignedID()) != null) {
                    object9 = new ItemIdentificationType();
                    object9.setID(CIIToUBL21Converter._copyID((IDType)taxCategoryType));
                    object.setSellersItemIdentification((ItemIdentificationType)object9);
                }
                if ((object9 = orderLineReferenceType2.getGlobalID()) != null) {
                    tradeCountryType = new ItemIdentificationType();
                    tradeCountryType.setID(CIIToUBL21Converter._copyID((IDType)object9));
                    object.setStandardItemIdentification((ItemIdentificationType)tradeCountryType);
                }
                if ((tradeCountryType = orderLineReferenceType2.getOriginTradeCountry()) != null) {
                    object8 = new CountryType();
                    object8.setIdentificationCode(tradeCountryType.getIDValue());
                    if (tradeCountryType.hasNameEntries()) {
                        object8.setName(CIIToUBL21Converter._copyName(tradeCountryType.getNameAtIndex(0), new NameType()));
                    }
                    object.setOriginCountry((CountryType)object8);
                }
                for (ProductClassificationType productClassificationType : orderLineReferenceType2.getDesignatedProductClassification()) {
                    CodeType codeType = productClassificationType.getClassCode();
                    if (codeType == null) continue;
                    CommodityClassificationType commodityClassificationType = new CommodityClassificationType();
                    commodityClassificationType.setItemClassificationCode(CIIToUBL21Converter._copyCode(codeType, new ItemClassificationCodeType()));
                    object.addCommodityClassification(commodityClassificationType);
                }
            }
            for (IDType iDType32 : iDType22.getApplicableTradeTax()) {
                taxCategoryType = new TaxCategoryType();
                taxCategoryType.setID(iDType32.getCategoryCodeValue());
                if (iDType32.getRateApplicablePercentValue() != null) {
                    taxCategoryType.setPercent(iDType32.getRateApplicablePercentValue());
                }
                object9 = new TaxSchemeType();
                object9.setID(this.getVATScheme());
                taxCategoryType.setTaxScheme((TaxSchemeType)object9);
                object.addClassifiedTaxCategory(taxCategoryType);
            }
            if (orderLineReferenceType2 != null) {
                for (IDType iDType32 : orderLineReferenceType2.getApplicableProductCharacteristic()) {
                    if (!iDType32.hasDescriptionEntries()) continue;
                    taxCategoryType = new ItemPropertyType();
                    taxCategoryType.setName(CIIToUBL21Converter._copyName(iDType32.getDescriptionAtIndex(0), new NameType()));
                    if (iDType32.hasValueEntries()) {
                        taxCategoryType.setValue(iDType32.getValueAtIndex(0).getValue());
                    }
                    object.addAdditionalItemProperty((ItemPropertyType)taxCategoryType);
                }
            }
            object10 = new PriceType();
            boolean bl4 = false;
            if (partyType != null && (taxCategoryType = partyType.getNetPriceProductTradePrice()) != null) {
                if (taxCategoryType.hasChargeAmountEntries()) {
                    object10.setPriceAmount(CIIToUBL21Converter._copyAmount(taxCategoryType.getChargeAmountAtIndex(0), new PriceAmountType(), (String)object5));
                    bl4 = true;
                }
                if (taxCategoryType.getBasisQuantity() != null) {
                    object10.setBaseQuantity(CIIToUBL21Converter._copyQuantity(taxCategoryType.getBasisQuantity(), new BaseQuantityType()));
                    bl4 = true;
                }
            }
            if ((taxCategoryType = partyType.getNetPriceProductTradePrice()) != null) {
                object9 = taxCategoryType.getAppliedTradeAllowanceCharge().iterator();
                while (object9.hasNext()) {
                    ProductClassificationType productClassificationType;
                    tradeCountryType = (TradeAllowanceChargeType)object9.next();
                    object8 = ETriState.UNDEFINED;
                    if (tradeCountryType.getChargeIndicator() != null) {
                        object8 = CIIToUBL21Converter._parseIndicator(tradeCountryType.getChargeIndicator(), (IErrorList)errorList);
                    } else {
                        errorList.add((Object)CIIToUBL21Converter._buildError(new String[]{"CrossIndustryInvoice", "SupplyChainTradeTransaction", "IncludedSupplyChainTradeLineItem", "SpecifiedLineTradeAgreement", "NetPriceProductTradePrice", "AppliedTradeAllowanceCharge"}, "Failed to determine if AppliedTradeAllowanceCharge is an Allowance or a Charge"));
                    }
                    if (!object8.isDefined()) continue;
                    productClassificationType = new AllowanceChargeType();
                    productClassificationType.setChargeIndicator(object8.getAsBooleanValue());
                    this._copyAllowanceCharge((TradeAllowanceChargeType)tradeCountryType, (AllowanceChargeType)productClassificationType, (String)object5);
                    object10.addAllowanceCharge((AllowanceChargeType)productClassificationType);
                }
            }
            if (bl4) {
                periodType2.setPrice((PriceType)object10);
            }
            periodType2.setItem((ItemType)object);
            invoiceType.addInvoiceLine((InvoiceLineType)periodType2);
        }
        return invoiceType;
    }

    @Nullable
    public CreditNoteType convertToCreditNote(@Nonnull CrossIndustryInvoiceType crossIndustryInvoiceType, @Nonnull ErrorList errorList) {
        PartyNameType partyNameType;
        PartyType partyType;
        TextType textType;
        TradeAddressType tradeAddressType2;
        Object object6;
        PartyTaxSchemeType partyTaxSchemeType;
        PeriodType periodType2;
        Object object22;
        Object object32;
        Object object42;
        ValueEnforcer.notNull((Object)crossIndustryInvoiceType, (String)"CIICreditNote");
        ValueEnforcer.notNull((Object)errorList, (String)"ErrorList");
        ExchangedDocumentType exchangedDocumentType = crossIndustryInvoiceType.getExchangedDocument();
        SupplyChainTradeTransactionType supplyChainTradeTransactionType = crossIndustryInvoiceType.getSupplyChainTradeTransaction();
        if (supplyChainTradeTransactionType == null) {
            return null;
        }
        HeaderTradeAgreementType headerTradeAgreementType = supplyChainTradeTransactionType.getApplicableHeaderTradeAgreement();
        HeaderTradeDeliveryType headerTradeDeliveryType = supplyChainTradeTransactionType.getApplicableHeaderTradeDelivery();
        HeaderTradeSettlementType headerTradeSettlementType = supplyChainTradeTransactionType.getApplicableHeaderTradeSettlement();
        if (headerTradeAgreementType == null || headerTradeDeliveryType == null || headerTradeSettlementType == null) {
            return null;
        }
        CreditNoteType creditNoteType = new CreditNoteType();
        creditNoteType.setCustomizationID(this.getCustomizationID());
        creditNoteType.setProfileID(this.getProfileID());
        if (exchangedDocumentType != null) {
            creditNoteType.setID(exchangedDocumentType.getIDValue());
        }
        SupplierPartyType supplierPartyType = new SupplierPartyType();
        creditNoteType.setAccountingSupplierParty(supplierPartyType);
        CustomerPartyType customerPartyType = new CustomerPartyType();
        creditNoteType.setAccountingCustomerParty(customerPartyType);
        Object object5 = null;
        if (exchangedDocumentType != null && exchangedDocumentType.getIssueDateTime() != null) {
            object5 = CIIToUBL21Converter._parseDate(exchangedDocumentType.getIssueDateTime().getDateTimeString(), (IErrorList)errorList);
        }
        if (object5 != null) {
            creditNoteType.setIssueDate(object5);
        }
        if (exchangedDocumentType != null) {
            creditNoteType.setCreditNoteTypeCode(exchangedDocumentType.getTypeCodeValue());
        }
        if (exchangedDocumentType != null) {
            for (Object object42 : exchangedDocumentType.getIncludedNote()) {
                creditNoteType.addNote(CIIToUBL21Converter._copyNote((NoteType)object42));
            }
        }
        for (Object object42 : headerTradeSettlementType.getApplicableTradeTax()) {
            if (object42.getTaxPointDate() == null || (object32 = CIIToUBL21Converter._parseDate(object42.getTaxPointDate().getDateString(), (IErrorList)errorList)) == null) continue;
            creditNoteType.setTaxPointDate((LocalDate)object32);
            break;
        }
        object5 = headerTradeSettlementType.getInvoiceCurrencyCodeValue();
        creditNoteType.setDocumentCurrencyCode((String)object5);
        if (headerTradeSettlementType.getTaxCurrencyCodeValue() != null) {
            creditNoteType.setTaxCurrencyCode(headerTradeSettlementType.getTaxCurrencyCodeValue());
        }
        object42 = headerTradeSettlementType.getReceivableSpecifiedTradeAccountingAccount().iterator();
        while (object42.hasNext()) {
            object32 = (TradeAccountingAccountType)object42.next();
            object22 = object32.getIDValue();
            if (!StringHelper.hasText((String)object22)) continue;
            creditNoteType.setAccountingCost((String)object22);
            break;
        }
        if (headerTradeAgreementType.getBuyerReferenceValue() != null) {
            creditNoteType.setBuyerReference(headerTradeAgreementType.getBuyerReferenceValue());
        }
        if ((object42 = headerTradeSettlementType.getBillingSpecifiedPeriod()) != null) {
            object32 = object42.getStartDateTime();
            object22 = object42.getEndDateTime();
            if (object32 != null && object22 != null) {
                periodType2 = new PeriodType();
                periodType2.setStartDate(CIIToUBL21Converter._parseDate(object32.getDateTimeString(), (IErrorList)errorList));
                periodType2.setEndDate(CIIToUBL21Converter._parseDate(object22.getDateTimeString(), (IErrorList)errorList));
                creditNoteType.addInvoicePeriod(periodType2);
            }
        }
        object42 = new OrderReferenceType();
        object32 = headerTradeAgreementType.getBuyerOrderReferencedDocument();
        if (object32 != null) {
            object42.setID(object32.getIssuerAssignedIDValue());
        }
        if ((object22 = headerTradeAgreementType.getSellerOrderReferencedDocument()) != null) {
            if (object42.getIDValue() == null) {
                object42.setID("");
            }
            object42.setSalesOrderID(object22.getIssuerAssignedIDValue());
        }
        if (object42.getIDValue() != null || object42.getSalesOrderIDValue() != null) {
            creditNoteType.setOrderReference((OrderReferenceType)object42);
        }
        if ((object42 = CIIToUBL21Converter._convertDocumentReference(headerTradeSettlementType.getInvoiceReferencedDocument(), (IErrorList)errorList)) != null) {
            object32 = new BillingReferenceType();
            object32.setCreditNoteDocumentReference((DocumentReferenceType)object42);
            creditNoteType.addBillingReference((BillingReferenceType)object32);
        }
        if ((object42 = CIIToUBL21Converter._convertDocumentReference(headerTradeDeliveryType.getDespatchAdviceReferencedDocument(), (IErrorList)errorList)) != null) {
            creditNoteType.addDespatchDocumentReference((DocumentReferenceType)object42);
        }
        if ((object42 = CIIToUBL21Converter._convertDocumentReference(headerTradeDeliveryType.getReceivingAdviceReferencedDocument(), (IErrorList)errorList)) != null) {
            creditNoteType.addReceiptDocumentReference((DocumentReferenceType)object42);
        }
        for (Object object32 : headerTradeAgreementType.getAdditionalReferencedDocument()) {
            if (!CIIToUBL21Converter.isOriginatorDocumentReferenceTypeCode(object32.getTypeCodeValue()) || (object22 = CIIToUBL21Converter._convertDocumentReference((ReferencedDocumentType)object32, (IErrorList)errorList)) == null) continue;
            creditNoteType.addOriginatorDocumentReference((DocumentReferenceType)object22);
        }
        object42 = CIIToUBL21Converter._convertDocumentReference(headerTradeAgreementType.getContractReferencedDocument(), (IErrorList)errorList);
        if (object42 != null) {
            creditNoteType.addContractDocumentReference((DocumentReferenceType)object42);
        }
        for (Object object32 : headerTradeAgreementType.getAdditionalReferencedDocument()) {
            if (CIIToUBL21Converter.isOriginatorDocumentReferenceTypeCode(object32.getTypeCodeValue()) || (object22 = CIIToUBL21Converter._convertDocumentReference((ReferencedDocumentType)object32, (IErrorList)errorList)) == null) continue;
            creditNoteType.addAdditionalDocumentReference((DocumentReferenceType)object22);
        }
        object42 = headerTradeAgreementType.getSellerTradeParty();
        if (object42 != null) {
            object32 = CIIToUBL21Converter._convertParty((TradePartyType)object42);
            for (PeriodType periodType2 : object42.getSpecifiedTaxRegistration()) {
                partyTaxSchemeType = this._convertPartyTaxScheme((TaxRegistrationType)periodType2);
                if (partyTaxSchemeType == null) continue;
                object32.addPartyTaxScheme(partyTaxSchemeType);
            }
            object22 = CIIToUBL21Converter._convertPartyLegalEntity((TradePartyType)object42);
            if (object22 != null) {
                object32.addPartyLegalEntity((PartyLegalEntityType)object22);
            }
            if ((periodType2 = CIIToUBL21Converter._convertContact((TradePartyType)object42)) != null) {
                object32.setContact((ContactType)periodType2);
            }
            supplierPartyType.setParty((PartyType)object32);
        }
        if ((object42 = headerTradeAgreementType.getBuyerTradeParty()) != null) {
            object32 = CIIToUBL21Converter._convertParty((TradePartyType)object42);
            for (PeriodType periodType2 : object42.getSpecifiedTaxRegistration()) {
                partyTaxSchemeType = this._convertPartyTaxScheme((TaxRegistrationType)periodType2);
                if (partyTaxSchemeType == null) continue;
                object32.addPartyTaxScheme(partyTaxSchemeType);
            }
            object22 = CIIToUBL21Converter._convertPartyLegalEntity((TradePartyType)object42);
            if (object22 != null) {
                object32.addPartyLegalEntity((PartyLegalEntityType)object22);
            }
            if ((periodType2 = CIIToUBL21Converter._convertContact((TradePartyType)object42)) != null) {
                object32.setContact((ContactType)periodType2);
            }
            customerPartyType.setParty((PartyType)object32);
        }
        if ((object42 = headerTradeSettlementType.getPayeeTradeParty()) != null) {
            object32 = CIIToUBL21Converter._convertParty((TradePartyType)object42);
            for (PeriodType periodType2 : object42.getSpecifiedTaxRegistration()) {
                partyTaxSchemeType = this._convertPartyTaxScheme((TaxRegistrationType)periodType2);
                if (partyTaxSchemeType == null) continue;
                object32.addPartyTaxScheme(partyTaxSchemeType);
            }
            object22 = CIIToUBL21Converter._convertContact((TradePartyType)object42);
            if (object22 != null) {
                object32.setContact((ContactType)object22);
            }
            creditNoteType.setPayeeParty((PartyType)object32);
        }
        if ((object42 = headerTradeAgreementType.getSellerTaxRepresentativeTradeParty()) != null) {
            object32 = CIIToUBL21Converter._convertParty((TradePartyType)object42);
            for (PeriodType periodType2 : object42.getSpecifiedTaxRegistration()) {
                partyTaxSchemeType = this._convertPartyTaxScheme((TaxRegistrationType)periodType2);
                if (partyTaxSchemeType == null) continue;
                object32.addPartyTaxScheme(partyTaxSchemeType);
            }
            object22 = CIIToUBL21Converter._convertContact((TradePartyType)object42);
            if (object22 != null) {
                object32.setContact((ContactType)object22);
            }
            creditNoteType.setTaxRepresentativeParty((PartyType)object32);
        }
        if ((object42 = headerTradeDeliveryType.getShipToTradeParty()) != null) {
            object32 = new DeliveryType();
            object22 = headerTradeDeliveryType.getActualDeliverySupplyChainEvent();
            if (object22 != null && (periodType2 = object22.getOccurrenceDateTime()) != null) {
                object32.setActualDeliveryDate(CIIToUBL21Converter._parseDate(periodType2.getDateTimeString(), (IErrorList)errorList));
            }
            periodType2 = new LocationType();
            boolean bl = false;
            object6 = CIIToUBL21Converter._extractPartyID((TradePartyType)object42);
            if (object6 != null) {
                periodType2.setID((oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType)object6);
                bl = true;
            }
            if ((tradeAddressType2 = object42.getPostalTradeAddress()) != null) {
                periodType2.setAddress(CIIToUBL21Converter._convertPostalAddress(tradeAddressType2));
                bl = true;
            }
            if (bl) {
                object32.setDeliveryLocation((LocationType)periodType2);
            }
            if ((textType = object42.getName()) != null) {
                partyType = new PartyType();
                partyNameType = new PartyNameType();
                partyNameType.setName(CIIToUBL21Converter._copyName(textType, new NameType()));
                partyType.addPartyName(partyNameType);
                object32.setDeliveryParty(partyType);
            }
            creditNoteType.addDelivery((DeliveryType)object32);
        }
        for (Object object32 : headerTradeSettlementType.getSpecifiedTradeSettlementPaymentMeans()) {
            this._convertPaymentMeans(headerTradeSettlementType, (TradeSettlementPaymentMeansType)object32, iDType -> CIIToUBL21Converter._addPartyID(iDType, creditNoteType.getAccountingSupplierParty().getParty()), arg_0 -> ((CreditNoteType)creditNoteType).addPaymentMeans(arg_0), errorList);
        }
        for (Object object32 : headerTradeSettlementType.getSpecifiedTradePaymentTerms()) {
            boolean bl = false;
            periodType2 = new PaymentTermsType();
            for (Object object6 : object32.getDescription()) {
                periodType2.addNote(CIIToUBL21Converter._copyNote((TextType)object6));
                bl = true;
            }
            if (!bl) continue;
            creditNoteType.addPaymentTerms((PaymentTermsType)periodType2);
        }
        for (Object object32 : headerTradeSettlementType.getSpecifiedTradeAllowanceCharge()) {
            object22 = ETriState.UNDEFINED;
            if (object32.getChargeIndicator() != null) {
                object22 = CIIToUBL21Converter._parseIndicator(object32.getChargeIndicator(), (IErrorList)errorList);
            } else {
                errorList.add((Object)CIIToUBL21Converter._buildError(new String[]{"CrossIndustryCreditNote", "SupplyChainTradeTransaction", "ApplicableHeaderTradeSettlement", "SpecifiedTradeAllowanceCharge"}, "Failed to determine if SpecifiedTradeAllowanceCharge is an Allowance or a Charge"));
            }
            if (!object22.isDefined()) continue;
            periodType2 = new AllowanceChargeType();
            periodType2.setChargeIndicator(object22.getAsBooleanValue());
            this._copyAllowanceCharge((TradeAllowanceChargeType)object32, (AllowanceChargeType)periodType2, (String)object5);
            creditNoteType.addAllowanceCharge((AllowanceChargeType)periodType2);
        }
        object42 = headerTradeSettlementType.getSpecifiedTradeSettlementHeaderMonetarySummation();
        object32 = null;
        if (object42 != null && object42.hasTaxTotalAmountEntries()) {
            for (PeriodType periodType2 : object42.getTaxTotalAmount()) {
                TaxTotalType taxTotalType = new TaxTotalType();
                taxTotalType.setTaxAmount(CIIToUBL21Converter._copyAmount((un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType)periodType2, new TaxAmountType(), (String)object5));
                creditNoteType.addTaxTotal(taxTotalType);
                if (object32 != null) continue;
                object32 = taxTotalType;
            }
        } else {
            object22 = new TaxAmountType();
            object22.setValue(BigDecimal.ZERO);
            object22.setCurrencyID((String)object5);
            object32 = new TaxTotalType();
            object32.setTaxAmount((TaxAmountType)object22);
            creditNoteType.addTaxTotal((TaxTotalType)object32);
        }
        for (PeriodType periodType2 : headerTradeSettlementType.getApplicableTradeTax()) {
            TaxSubtotalType taxSubtotalType = new TaxSubtotalType();
            if (periodType2.hasBasisAmountEntries()) {
                taxSubtotalType.setTaxableAmount(CIIToUBL21Converter._copyAmount(periodType2.getBasisAmountAtIndex(0), new TaxableAmountType(), (String)object5));
            }
            if (periodType2.hasCalculatedAmountEntries()) {
                taxSubtotalType.setTaxAmount(CIIToUBL21Converter._copyAmount(periodType2.getCalculatedAmountAtIndex(0), new TaxAmountType(), (String)object5));
            }
            object6 = new TaxCategoryType();
            object6.setID(periodType2.getCategoryCodeValue());
            if (periodType2.getRateApplicablePercentValue() != null) {
                object6.setPercent(periodType2.getRateApplicablePercentValue());
            }
            if (StringHelper.hasText((String)periodType2.getExemptionReasonCodeValue())) {
                object6.setTaxExemptionReasonCode(periodType2.getExemptionReasonCodeValue());
            }
            if (periodType2.getExemptionReason() != null) {
                tradeAddressType2 = new TaxExemptionReasonType();
                tradeAddressType2.setValue(periodType2.getExemptionReason().getValue());
                tradeAddressType2.setLanguageID(periodType2.getExemptionReason().getLanguageID());
                tradeAddressType2.setLanguageLocaleID(periodType2.getExemptionReason().getLanguageLocaleID());
                object6.addTaxExemptionReason((TaxExemptionReasonType)tradeAddressType2);
            }
            tradeAddressType2 = new TaxSchemeType();
            tradeAddressType2.setID(this.getVATScheme());
            object6.setTaxScheme((TaxSchemeType)tradeAddressType2);
            taxSubtotalType.setTaxCategory((TaxCategoryType)object6);
            object32.addTaxSubtotal(taxSubtotalType);
        }
        object32 = new MonetaryTotalType();
        if (object42 != null) {
            if (object42.hasLineTotalAmountEntries()) {
                object32.setLineExtensionAmount(CIIToUBL21Converter._copyAmount(object42.getLineTotalAmountAtIndex(0), new LineExtensionAmountType(), (String)object5));
            }
            if (object42.hasTaxBasisTotalAmountEntries()) {
                object32.setTaxExclusiveAmount(CIIToUBL21Converter._copyAmount(object42.getTaxBasisTotalAmountAtIndex(0), new TaxExclusiveAmountType(), (String)object5));
            }
            if (object42.hasGrandTotalAmountEntries()) {
                object32.setTaxInclusiveAmount(CIIToUBL21Converter._copyAmount(object42.getGrandTotalAmountAtIndex(0), new TaxInclusiveAmountType(), (String)object5));
            }
            if (object42.hasAllowanceTotalAmountEntries()) {
                object32.setAllowanceTotalAmount(CIIToUBL21Converter._copyAmount(object42.getAllowanceTotalAmountAtIndex(0), new AllowanceTotalAmountType(), (String)object5));
            }
            if (object42.hasChargeTotalAmountEntries()) {
                object32.setChargeTotalAmount(CIIToUBL21Converter._copyAmount(object42.getChargeTotalAmountAtIndex(0), new ChargeTotalAmountType(), (String)object5));
            }
            if (object42.hasTotalPrepaidAmountEntries()) {
                object32.setPrepaidAmount(CIIToUBL21Converter._copyAmount(object42.getTotalPrepaidAmountAtIndex(0), new PrepaidAmountType(), (String)object5));
            }
            if (object42.hasRoundingAmountEntries() && MathHelper.isNE0((BigDecimal)object42.getRoundingAmountAtIndex(0).getValue())) {
                object32.setPayableRoundingAmount(CIIToUBL21Converter._copyAmount(object42.getRoundingAmountAtIndex(0), new PayableRoundingAmountType(), (String)object5));
            }
            if (object42.hasDuePayableAmountEntries()) {
                object32.setPayableAmount(CIIToUBL21Converter._copyAmount(object42.getDuePayableAmountAtIndex(0), new PayableAmountType(), (String)object5));
            }
        }
        creditNoteType.setLegalMonetaryTotal((MonetaryTotalType)object32);
        for (Object object22 : supplyChainTradeTransactionType.getIncludedSupplyChainTradeLineItem()) {
            Object object7;
            TradeCountryType tradeCountryType;
            Object object8;
            TaxCategoryType taxCategoryType;
            IDType iDType22;
            Object object9;
            OrderLineReferenceType orderLineReferenceType2;
            Object object10;
            periodType2 = new CreditNoteLineType();
            DocumentLineDocumentType documentLineDocumentType = object22.getAssociatedDocumentLineDocument();
            periodType2.setID(CIIToUBL21Converter._copyID(documentLineDocumentType.getLineID()));
            for (TradeAddressType tradeAddressType2 : documentLineDocumentType.getIncludedNote()) {
                periodType2.addNote(CIIToUBL21Converter._copyNote((NoteType)tradeAddressType2));
            }
            object6 = object22.getSpecifiedLineTradeDelivery();
            if (object6 != null && (tradeAddressType2 = object6.getBilledQuantity()) != null) {
                periodType2.setCreditedQuantity(CIIToUBL21Converter._copyQuantity((QuantityType)tradeAddressType2, new CreditedQuantityType()));
            }
            if ((textType = (tradeAddressType2 = object22.getSpecifiedLineTradeSettlement()).getSpecifiedTradeSettlementLineMonetarySummation()) != null && textType.hasLineTotalAmountEntries()) {
                periodType2.setLineExtensionAmount(CIIToUBL21Converter._copyAmount(textType.getLineTotalAmountAtIndex(0), new LineExtensionAmountType(), (String)object5));
            }
            if (tradeAddressType2.hasReceivableSpecifiedTradeAccountingAccountEntries()) {
                partyType = tradeAddressType2.getReceivableSpecifiedTradeAccountingAccountAtIndex(0);
                periodType2.setAccountingCost(partyType.getIDValue());
            }
            if ((partyType = tradeAddressType2.getBillingSpecifiedPeriod()) != null) {
                partyNameType = new PeriodType();
                if (partyType.getStartDateTime() != null) {
                    partyNameType.setStartDate(CIIToUBL21Converter._parseDate(partyType.getStartDateTime().getDateTimeString(), (IErrorList)errorList));
                }
                if (partyType.getEndDateTime() != null) {
                    partyNameType.setEndDate(CIIToUBL21Converter._parseDate(partyType.getEndDateTime().getDateTimeString(), (IErrorList)errorList));
                }
                periodType2.addInvoicePeriod((PeriodType)partyNameType);
            }
            if ((partyNameType = object22.getSpecifiedLineTradeAgreement()) != null && (object10 = partyNameType.getBuyerOrderReferencedDocument()) != null) {
                orderLineReferenceType2 = new OrderLineReferenceType();
                orderLineReferenceType2.setLineID(CIIToUBL21Converter._copyID(object10.getLineID(), new LineIDType()));
                periodType2.addOrderLineReference(orderLineReferenceType2);
            }
            for (OrderLineReferenceType orderLineReferenceType2 : tradeAddressType2.getAdditionalReferencedDocument()) {
                object9 = CIIToUBL21Converter._convertDocumentReference((ReferencedDocumentType)orderLineReferenceType2, (IErrorList)errorList);
                if (object9 == null) continue;
                periodType2.addDocumentReference((DocumentReferenceType)object9);
            }
            for (OrderLineReferenceType orderLineReferenceType2 : tradeAddressType2.getSpecifiedTradeAllowanceCharge()) {
                object9 = ETriState.UNDEFINED;
                if (orderLineReferenceType2.getChargeIndicator() != null) {
                    object9 = CIIToUBL21Converter._parseIndicator(orderLineReferenceType2.getChargeIndicator(), (IErrorList)errorList);
                } else {
                    errorList.add((Object)CIIToUBL21Converter._buildError(new String[]{"CrossIndustryCreditNote", "SupplyChainTradeTransaction", "IncludedSupplyChainTradeLineItem", "SpecifiedLineTradeSettlement", "SpecifiedTradeAllowanceCharge"}, "Failed to determine if SpecifiedTradeAllowanceCharge is an Allowance or a Charge"));
                }
                if (!object9.isDefined()) continue;
                iDType22 = new AllowanceChargeType();
                iDType22.setChargeIndicator(object9.getAsBooleanValue());
                this._copyAllowanceCharge((TradeAllowanceChargeType)orderLineReferenceType2, (AllowanceChargeType)iDType22, (String)object5);
                periodType2.addAllowanceCharge((AllowanceChargeType)iDType22);
            }
            object10 = new ItemType();
            orderLineReferenceType2 = object22.getSpecifiedTradeProduct();
            if (orderLineReferenceType2 != null) {
                object9 = orderLineReferenceType2.getDescription();
                if (object9 != null) {
                    object10.addDescription(CIIToUBL21Converter._copyName((TextType)object9, new DescriptionType()));
                }
                if (orderLineReferenceType2.hasNameEntries()) {
                    object10.setName(CIIToUBL21Converter._copyName(orderLineReferenceType2.getNameAtIndex(0), new NameType()));
                }
                if ((iDType22 = orderLineReferenceType2.getBuyerAssignedID()) != null) {
                    taxCategoryType = new ItemIdentificationType();
                    taxCategoryType.setID(CIIToUBL21Converter._copyID(iDType22));
                    object10.setBuyersItemIdentification((ItemIdentificationType)taxCategoryType);
                }
                if ((taxCategoryType = orderLineReferenceType2.getSellerAssignedID()) != null) {
                    object8 = new ItemIdentificationType();
                    object8.setID(CIIToUBL21Converter._copyID((IDType)taxCategoryType));
                    object10.setSellersItemIdentification((ItemIdentificationType)object8);
                }
                if ((object8 = orderLineReferenceType2.getGlobalID()) != null) {
                    tradeCountryType = new ItemIdentificationType();
                    tradeCountryType.setID(CIIToUBL21Converter._copyID((IDType)object8));
                    object10.setStandardItemIdentification((ItemIdentificationType)tradeCountryType);
                }
                if ((tradeCountryType = orderLineReferenceType2.getOriginTradeCountry()) != null) {
                    object7 = new CountryType();
                    object7.setIdentificationCode(tradeCountryType.getIDValue());
                    if (tradeCountryType.hasNameEntries()) {
                        object7.setName(CIIToUBL21Converter._copyName(tradeCountryType.getNameAtIndex(0), new NameType()));
                    }
                    object10.setOriginCountry((CountryType)object7);
                }
                for (ProductClassificationType productClassificationType : orderLineReferenceType2.getDesignatedProductClassification()) {
                    CodeType codeType = productClassificationType.getClassCode();
                    if (codeType == null) continue;
                    CommodityClassificationType commodityClassificationType = new CommodityClassificationType();
                    commodityClassificationType.setItemClassificationCode(CIIToUBL21Converter._copyCode(codeType, new ItemClassificationCodeType()));
                    object10.addCommodityClassification(commodityClassificationType);
                }
            }
            for (IDType iDType22 : tradeAddressType2.getApplicableTradeTax()) {
                taxCategoryType = new TaxCategoryType();
                taxCategoryType.setID(iDType22.getCategoryCodeValue());
                if (iDType22.getRateApplicablePercentValue() != null) {
                    taxCategoryType.setPercent(iDType22.getRateApplicablePercentValue());
                }
                object8 = new TaxSchemeType();
                object8.setID(this.getVATScheme());
                taxCategoryType.setTaxScheme((TaxSchemeType)object8);
                object10.addClassifiedTaxCategory(taxCategoryType);
            }
            if (orderLineReferenceType2 != null) {
                for (IDType iDType22 : orderLineReferenceType2.getApplicableProductCharacteristic()) {
                    if (!iDType22.hasDescriptionEntries()) continue;
                    taxCategoryType = new ItemPropertyType();
                    taxCategoryType.setName(CIIToUBL21Converter._copyName(iDType22.getDescriptionAtIndex(0), new NameType()));
                    if (iDType22.hasValueEntries()) {
                        taxCategoryType.setValue(iDType22.getValueAtIndex(0).getValue());
                    }
                    object10.addAdditionalItemProperty((ItemPropertyType)taxCategoryType);
                }
            }
            object9 = new PriceType();
            boolean bl = false;
            if (partyNameType != null && (taxCategoryType = partyNameType.getNetPriceProductTradePrice()) != null) {
                if (taxCategoryType.hasChargeAmountEntries()) {
                    object9.setPriceAmount(CIIToUBL21Converter._copyAmount(taxCategoryType.getChargeAmountAtIndex(0), new PriceAmountType(), (String)object5));
                    bl = true;
                }
                if (taxCategoryType.getBasisQuantity() != null) {
                    object9.setBaseQuantity(CIIToUBL21Converter._copyQuantity(taxCategoryType.getBasisQuantity(), new BaseQuantityType()));
                    bl = true;
                }
            }
            if ((taxCategoryType = partyNameType.getNetPriceProductTradePrice()) != null) {
                object8 = taxCategoryType.getAppliedTradeAllowanceCharge().iterator();
                while (object8.hasNext()) {
                    ProductClassificationType productClassificationType;
                    tradeCountryType = (TradeAllowanceChargeType)object8.next();
                    object7 = ETriState.UNDEFINED;
                    if (tradeCountryType.getChargeIndicator() != null) {
                        object7 = CIIToUBL21Converter._parseIndicator(tradeCountryType.getChargeIndicator(), (IErrorList)errorList);
                    } else {
                        errorList.add((Object)CIIToUBL21Converter._buildError(new String[]{"CrossIndustryCreditNote", "SupplyChainTradeTransaction", "IncludedSupplyChainTradeLineItem", "SpecifiedLineTradeAgreement", "NetPriceProductTradePrice", "AppliedTradeAllowanceCharge"}, "Failed to determine if AppliedTradeAllowanceCharge is an Allowance or a Charge"));
                    }
                    if (!object7.isDefined()) continue;
                    productClassificationType = new AllowanceChargeType();
                    productClassificationType.setChargeIndicator(object7.getAsBooleanValue());
                    this._copyAllowanceCharge((TradeAllowanceChargeType)tradeCountryType, (AllowanceChargeType)productClassificationType, (String)object5);
                    object9.addAllowanceCharge((AllowanceChargeType)productClassificationType);
                }
            }
            if (bl) {
                periodType2.setPrice((PriceType)object9);
            }
            periodType2.setItem((ItemType)object10);
            creditNoteType.addCreditNoteLine((CreditNoteLineType)periodType2);
        }
        return creditNoteType;
    }

    @Override
    @Nullable
    public Serializable convertCIItoUBL(@Nonnull CrossIndustryInvoiceType crossIndustryInvoiceType, @Nonnull ErrorList errorList) {
        ValueEnforcer.notNull((Object)crossIndustryInvoiceType, (String)"CIIInvoice");
        ValueEnforcer.notNull((Object)errorList, (String)"ErrorList");
        switch (this.getUBLCreationMode()) {
            case AUTOMATIC: {
                SupplyChainTradeTransactionType supplyChainTradeTransactionType = crossIndustryInvoiceType.getSupplyChainTradeTransaction();
                HeaderTradeSettlementType headerTradeSettlementType = supplyChainTradeTransactionType == null ? null : supplyChainTradeTransactionType.getApplicableHeaderTradeSettlement();
                TradeSettlementHeaderMonetarySummationType tradeSettlementHeaderMonetarySummationType = headerTradeSettlementType == null ? null : headerTradeSettlementType.getSpecifiedTradeSettlementHeaderMonetarySummation();
                un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType amountType = tradeSettlementHeaderMonetarySummationType == null || tradeSettlementHeaderMonetarySummationType.hasNoDuePayableAmountEntries() ? null : (un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType)tradeSettlementHeaderMonetarySummationType.getDuePayableAmount().get(0);
                boolean bl = amountType == null || MathHelper.isGE0((BigDecimal)amountType.getValue());
                return bl ? this.convertToInvoice(crossIndustryInvoiceType, errorList) : this.convertToCreditNote(crossIndustryInvoiceType, errorList);
            }
            case INVOICE: {
                return this.convertToInvoice(crossIndustryInvoiceType, errorList);
            }
            case CREDIT_NOTE: {
                return this.convertToCreditNote(crossIndustryInvoiceType, errorList);
            }
        }
        throw new IllegalStateException("Unsupported creation mode");
    }
}

