/*
 * Decompiled with CFR 0.152.
 */
package com.helger.en16931.cii2ubl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.math.MathHelper;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringHelper;
import com.helger.en16931.cii2ubl.AbstractCIIToUBLConverter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AddressLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AddressType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AllowanceChargeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AttachmentType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.BillingReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.BranchType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CardAccountType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CommodityClassificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ContactType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CountryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CreditNoteLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CustomerPartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DocumentReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ExternalReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.FinancialAccountType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.InvoiceLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ItemIdentificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ItemPropertyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ItemType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.LocationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.MonetaryTotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.OrderLineReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.OrderReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyIdentificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyLegalEntityType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyNameType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyTaxSchemeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentMandateType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentMeansType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentTermsType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PriceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ProjectReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.SupplierPartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxCategoryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxSchemeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxSubtotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxTotalType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.AllowanceChargeReasonType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.AllowanceTotalAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.AmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.BaseAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.BaseQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.ChargeTotalAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.CompanyIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.CreditedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DescriptionCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DocumentDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DocumentTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.EmbeddedDocumentBinaryObjectType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.EndpointIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.InvoicedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.ItemClassificationCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.LineExtensionAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.LineIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NameType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PayableAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PayableRoundingAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PaymentIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PaymentMeansCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PrepaidAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PriceAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PrimaryAccountNumberIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TaxAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TaxExclusiveAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TaxExemptionReasonType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TaxInclusiveAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TaxableAmountType;
import oasis.names.specification.ubl.schema.xsd.creditnote_21.CreditNoteType;
import oasis.names.specification.ubl.schema.xsd.invoice_21.InvoiceType;
import un.unece.uncefact.data.standard.crossindustryinvoice._100.CrossIndustryInvoiceType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.FormattedDateTimeType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.CreditorFinancialAccountType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.DocumentLineDocumentType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.ExchangedDocumentContextType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.ExchangedDocumentType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.HeaderTradeAgreementType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.HeaderTradeDeliveryType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.HeaderTradeSettlementType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.LegalOrganizationType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.LineTradeAgreementType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.NoteType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.ProductClassificationType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.ReferencedDocumentType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.SupplyChainTradeTransactionType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TaxRegistrationType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeAddressType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeAllowanceChargeType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeContactType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeCountryType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradePartyType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradePaymentTermsType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeSettlementFinancialCardType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeSettlementPaymentMeansType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.TradeTaxType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.UniversalCommunicationType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.CodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.DateTimeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IDType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.QuantityType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType;

public class CIIToUBL21Converter
extends AbstractCIIToUBLConverter<CIIToUBL21Converter> {
    private static final String UBL_VERSION = "2.1";

    @Nullable
    private static oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType _copyID(@Nullable IDType iDType) {
        return CIIToUBL21Converter.copyID(iDType, new oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType());
    }

    @Nullable
    private static oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NoteType _copyNote(@Nullable NoteType noteType) {
        if (noteType == null) {
            return null;
        }
        oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NoteType noteType2 = new oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NoteType();
        StringBuilder stringBuilder = new StringBuilder();
        if (StringHelper.hasText((String)noteType.getSubjectCodeValue())) {
            stringBuilder.append('#').append(noteType.getSubjectCodeValue()).append('#');
        }
        boolean bl = true;
        for (TextType textType : noteType.getContent()) {
            if (stringBuilder.length() > 0 && !bl) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(textType.getValue());
            bl = false;
        }
        noteType2.setValue(stringBuilder.toString());
        return noteType2;
    }

    @Nullable
    private static oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NoteType _copyNote(@Nullable TextType textType) {
        return CIIToUBL21Converter.copyName(textType, new oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NoteType());
    }

    @Nullable
    private static DocumentReferenceType _convertDocumentReference(@Nullable ReferencedDocumentType referencedDocumentType, @Nonnull IErrorList iErrorList) {
        DocumentDescriptionType documentDescriptionType;
        TextType textType;
        FormattedDateTimeType formattedDateTimeType;
        if (referencedDocumentType == null) {
            return null;
        }
        String string = referencedDocumentType.getIssuerAssignedIDValue();
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        DocumentReferenceType documentReferenceType = new DocumentReferenceType();
        documentReferenceType.setID(string).setSchemeID(referencedDocumentType.getReferenceTypeCodeValue());
        if (CIIToUBL21Converter.isValidDocumentReferenceTypeCode(referencedDocumentType.getTypeCodeValue())) {
            documentReferenceType.setDocumentTypeCode(referencedDocumentType.getTypeCodeValue());
        }
        if ((formattedDateTimeType = referencedDocumentType.getFormattedIssueDateTime()) != null) {
            documentReferenceType.setIssueDate(CIIToUBL21Converter.parseDate(formattedDateTimeType.getDateTimeString(), iErrorList));
        }
        Object object = referencedDocumentType.getName().iterator();
        while (object.hasNext()) {
            textType = (TextType)object.next();
            documentDescriptionType = new DocumentDescriptionType();
            documentDescriptionType.setValue(textType.getValue());
            documentDescriptionType.setLanguageID(textType.getLanguageID());
            documentDescriptionType.setLanguageLocaleID(textType.getLanguageLocaleID());
            documentReferenceType.addDocumentDescription(documentDescriptionType);
        }
        if (referencedDocumentType.getAttachmentBinaryObjectCount() > 0) {
            object = referencedDocumentType.getAttachmentBinaryObjectAtIndex(0);
            textType = new AttachmentType();
            documentDescriptionType = new EmbeddedDocumentBinaryObjectType();
            documentDescriptionType.setMimeCode(object.getMimeCode());
            documentDescriptionType.setFilename(object.getFilename());
            documentDescriptionType.setValue(object.getValue());
            textType.setEmbeddedDocumentBinaryObject((EmbeddedDocumentBinaryObjectType)documentDescriptionType);
            documentReferenceType.setAttachment((AttachmentType)textType);
        }
        if (StringHelper.hasText((String)(object = referencedDocumentType.getURIIDValue()))) {
            textType = documentReferenceType.getAttachment();
            if (textType == null) {
                textType = new AttachmentType();
                documentReferenceType.setAttachment((AttachmentType)textType);
            }
            documentDescriptionType = new ExternalReferenceType();
            documentDescriptionType.setURI((String)object);
            textType.setExternalReference((ExternalReferenceType)documentDescriptionType);
        }
        return documentReferenceType;
    }

    @Nonnull
    private static AddressType _convertPostalAddress(@Nonnull TradeAddressType tradeAddressType) {
        AddressLineType addressLineType;
        AddressType addressType = new AddressType();
        if (StringHelper.hasText((String)tradeAddressType.getLineOneValue())) {
            addressType.setStreetName(tradeAddressType.getLineOneValue());
        }
        if (StringHelper.hasText((String)tradeAddressType.getLineTwoValue())) {
            addressType.setAdditionalStreetName(tradeAddressType.getLineTwoValue());
        }
        if (StringHelper.hasText((String)tradeAddressType.getLineThreeValue())) {
            addressLineType = new AddressLineType();
            addressLineType.setLine(tradeAddressType.getLineThreeValue());
            addressType.addAddressLine(addressLineType);
        }
        if (StringHelper.hasText((String)tradeAddressType.getCityNameValue())) {
            addressType.setCityName(tradeAddressType.getCityNameValue());
        }
        if (StringHelper.hasText((String)tradeAddressType.getPostcodeCodeValue())) {
            addressType.setPostalZone(tradeAddressType.getPostcodeCodeValue());
        }
        if (tradeAddressType.hasCountrySubDivisionNameEntries()) {
            addressType.setCountrySubentity(tradeAddressType.getCountrySubDivisionNameAtIndex(0).getValue());
        }
        if (StringHelper.hasText((String)tradeAddressType.getCountryIDValue())) {
            addressLineType = new CountryType();
            addressLineType.setIdentificationCode(tradeAddressType.getCountryIDValue());
            addressType.setCountry((CountryType)addressLineType);
        }
        return addressType;
    }

    @Nullable
    private static oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType _extractFirstPartyID(@Nonnull TradePartyType tradePartyType) {
        Object object = CIIToUBL21Converter.canUseGlobalID(tradePartyType) ? (IDType)CIIToUBL21Converter.getAllUsableGlobalIDs(tradePartyType).getFirstOrNull() : (tradePartyType.hasIDEntries() ? tradePartyType.getIDAtIndex(0) : null);
        return object == null ? null : CIIToUBL21Converter._copyID(object);
    }

    private static void _extractAllPartyIDs(@Nonnull TradePartyType tradePartyType, @Nonnull Consumer<? super oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType> consumer) {
        if (CIIToUBL21Converter.canUseGlobalID(tradePartyType)) {
            CIIToUBL21Converter.getAllUsableGlobalIDs(tradePartyType).forEach(iDType -> consumer.accept(CIIToUBL21Converter._copyID(iDType)));
        } else {
            for (IDType iDType2 : tradePartyType.getID()) {
                consumer.accept((oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType)CIIToUBL21Converter._copyID(iDType2));
            }
        }
    }

    private static void _addPartyID(@Nullable oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType iDType, @Nonnull PartyType partyType) {
        if (iDType != null && !CollectionHelper.containsAny((Iterable)partyType.getPartyIdentification(), partyIdentificationType -> EqualsHelper.equals((Object)iDType, (Object)partyIdentificationType.getID()))) {
            PartyIdentificationType partyIdentificationType2 = new PartyIdentificationType();
            partyIdentificationType2.setID(iDType);
            partyType.addPartyIdentification(partyIdentificationType2);
        }
    }

    @Nonnull
    private static PartyType _convertParty(@Nonnull TradePartyType tradePartyType, boolean bl, boolean bl2) {
        TradeAddressType tradeAddressType;
        UniversalCommunicationType universalCommunicationType;
        PartyType partyType = new PartyType();
        if (tradePartyType.hasURIUniversalCommunicationEntries()) {
            universalCommunicationType = tradePartyType.getURIUniversalCommunicationAtIndex(0);
            partyType.setEndpointID(CIIToUBL21Converter.copyID(universalCommunicationType.getURIID(), new EndpointIDType()));
        }
        if (bl) {
            CIIToUBL21Converter._extractAllPartyIDs(tradePartyType, iDType -> CIIToUBL21Converter._addPartyID(iDType, partyType));
        } else {
            CIIToUBL21Converter._addPartyID(CIIToUBL21Converter._extractFirstPartyID(tradePartyType), partyType);
        }
        universalCommunicationType = tradePartyType.getName();
        if (universalCommunicationType != null && StringHelper.hasText((String)universalCommunicationType.getValue())) {
            if (bl2) {
                tradeAddressType = new PartyLegalEntityType();
                tradeAddressType.setRegistrationName(universalCommunicationType.getValue());
                partyType.addPartyLegalEntity((PartyLegalEntityType)tradeAddressType);
            } else {
                tradeAddressType = new PartyNameType();
                tradeAddressType.setName(CIIToUBL21Converter.copyName((TextType)universalCommunicationType, new NameType()));
                if (tradeAddressType.getName() != null) {
                    partyType.addPartyName((PartyNameType)tradeAddressType);
                }
            }
        }
        if ((tradeAddressType = tradePartyType.getPostalTradeAddress()) != null) {
            partyType.setPostalAddress(CIIToUBL21Converter._convertPostalAddress(tradeAddressType));
        }
        return partyType;
    }

    @Nonnull
    private PartyTaxSchemeType _convertPartyTaxScheme(@Nonnull TaxRegistrationType taxRegistrationType) {
        if (taxRegistrationType.getID() == null) {
            return null;
        }
        PartyTaxSchemeType partyTaxSchemeType = new PartyTaxSchemeType();
        partyTaxSchemeType.setCompanyID(taxRegistrationType.getIDValue());
        String string = taxRegistrationType.getID().getSchemeID();
        if (StringHelper.hasNoText((String)string)) {
            string = this.getVATScheme();
        } else if ("VA".equals(string)) {
            string = this.getVATScheme();
        }
        TaxSchemeType taxSchemeType = new TaxSchemeType();
        taxSchemeType.setID(string);
        partyTaxSchemeType.setTaxScheme(taxSchemeType);
        return partyTaxSchemeType;
    }

    private static void _convertPartyLegalEntity(@Nonnull TradePartyType tradePartyType, @Nonnull PartyType partyType) {
        PartyLegalEntityType partyLegalEntityType;
        if (partyType.hasPartyLegalEntityEntries()) {
            partyLegalEntityType = partyType.getPartyLegalEntityAtIndex(0);
        } else {
            partyLegalEntityType = new PartyLegalEntityType();
            partyType.addPartyLegalEntity(partyLegalEntityType);
        }
        LegalOrganizationType legalOrganizationType = tradePartyType.getSpecifiedLegalOrganization();
        if (legalOrganizationType != null) {
            if (StringHelper.hasText((String)legalOrganizationType.getTradingBusinessNameValue())) {
                PartyNameType partyNameType = new PartyNameType();
                partyNameType.setName(legalOrganizationType.getTradingBusinessNameValue());
                if (partyNameType.getName() != null) {
                    partyType.addPartyName(partyNameType);
                }
            }
            partyLegalEntityType.setCompanyID(CIIToUBL21Converter.copyID(legalOrganizationType.getID(), new CompanyIDType()));
        }
        for (TextType textType : tradePartyType.getDescription()) {
            if (!StringHelper.hasText((String)textType.getValue())) continue;
            partyLegalEntityType.setCompanyLegalForm(textType.getValue());
            break;
        }
        if (partyLegalEntityType.getRegistrationName() == null) {
            partyLegalEntityType.setRegistrationName(tradePartyType.getNameValue());
        }
    }

    @Nullable
    private static ContactType _convertContact(@Nonnull TradePartyType tradePartyType) {
        UniversalCommunicationType universalCommunicationType;
        UniversalCommunicationType universalCommunicationType2;
        if (!tradePartyType.hasDefinedTradeContactEntries()) {
            return null;
        }
        TradeContactType tradeContactType = tradePartyType.getDefinedTradeContactAtIndex(0);
        ContactType contactType = new ContactType();
        contactType.setName(CIIToUBL21Converter.copyName(tradeContactType.getPersonName(), new NameType()));
        if (contactType.getNameValue() == null) {
            contactType.setName(CIIToUBL21Converter.copyName(tradeContactType.getDepartmentName(), new NameType()));
        }
        if ((universalCommunicationType2 = tradeContactType.getTelephoneUniversalCommunication()) != null) {
            CIIToUBL21Converter.ifNotEmpty(universalCommunicationType2.getCompleteNumberValue(), arg_0 -> ((ContactType)contactType).setTelephone(arg_0));
        }
        if ((universalCommunicationType = tradeContactType.getEmailURIUniversalCommunication()) != null) {
            CIIToUBL21Converter.ifNotEmpty(universalCommunicationType.getURIIDValue(), arg_0 -> ((ContactType)contactType).setElectronicMail(arg_0));
        }
        if (contactType.getName() == null && contactType.getTelephone() == null && contactType.getElectronicMail() == null) {
            return null;
        }
        return contactType;
    }

    @Nullable
    private static AmountType _copyAmount(@Nullable un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType amountType, @Nullable String string) {
        return CIIToUBL21Converter.copyAmount(amountType, new AmountType(), string);
    }

    private void _copyAllowanceCharge(@Nonnull TradeAllowanceChargeType tradeAllowanceChargeType, @Nonnull AllowanceChargeType allowanceChargeType, @Nullable String string) {
        if (StringHelper.hasText((String)tradeAllowanceChargeType.getReasonCodeValue())) {
            allowanceChargeType.setAllowanceChargeReasonCode(tradeAllowanceChargeType.getReasonCodeValue());
        }
        if (tradeAllowanceChargeType.getReason() != null) {
            AllowanceChargeReasonType allowanceChargeReasonType = new AllowanceChargeReasonType();
            allowanceChargeReasonType.setValue(tradeAllowanceChargeType.getReasonValue());
            allowanceChargeType.addAllowanceChargeReason(allowanceChargeReasonType);
        }
        if (tradeAllowanceChargeType.getCalculationPercent() != null) {
            allowanceChargeType.setMultiplierFactorNumeric(tradeAllowanceChargeType.getCalculationPercentValue());
        }
        if (tradeAllowanceChargeType.hasActualAmountEntries()) {
            allowanceChargeType.setAmount(CIIToUBL21Converter._copyAmount(tradeAllowanceChargeType.getActualAmountAtIndex(0), string));
        }
        allowanceChargeType.setBaseAmount(CIIToUBL21Converter.copyAmount(tradeAllowanceChargeType.getBasisAmount(), new BaseAmountType(), string));
        for (TradeTaxType tradeTaxType : tradeAllowanceChargeType.getCategoryTradeTax()) {
            TaxCategoryType taxCategoryType = new TaxCategoryType();
            taxCategoryType.setID(tradeTaxType.getCategoryCodeValue());
            if (tradeTaxType.getRateApplicablePercentValue() != null) {
                taxCategoryType.setPercent(MathHelper.getWithoutTrailingZeroes((BigDecimal)tradeTaxType.getRateApplicablePercentValue()));
            }
            TaxSchemeType taxSchemeType = new TaxSchemeType();
            taxSchemeType.setID(this.getVATScheme());
            taxCategoryType.setTaxScheme(taxSchemeType);
            allowanceChargeType.addTaxCategory(taxCategoryType);
        }
    }

    private void _convertPaymentMeans(@Nonnull HeaderTradeSettlementType headerTradeSettlementType, @Nonnull TradeSettlementPaymentMeansType tradeSettlementPaymentMeansType, @Nonnull Consumer<oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType> consumer, @Nonnull Consumer<PaymentMeansType> consumer2, @Nonnull ErrorList errorList) {
        boolean bl;
        boolean bl2;
        CardAccountType cardAccountType;
        TradeSettlementFinancialCardType tradeSettlementFinancialCardType;
        boolean bl3;
        PaymentIDType paymentIDType;
        String string = tradeSettlementPaymentMeansType.getTypeCodeValue();
        PaymentMeansType paymentMeansType = new PaymentMeansType();
        PaymentMeansCodeType paymentMeansCodeType = new PaymentMeansCodeType();
        paymentMeansCodeType.setValue(string);
        if (tradeSettlementPaymentMeansType.hasInformationEntries()) {
            paymentMeansCodeType.setName(tradeSettlementPaymentMeansType.getInformationAtIndex(0).getValue());
        }
        paymentMeansType.setPaymentMeansCode(paymentMeansCodeType);
        for (TextType textType : headerTradeSettlementType.getPaymentReference()) {
            paymentIDType = new PaymentIDType();
            paymentIDType.setValue(textType.getValue());
            paymentMeansType.addPaymentID(paymentIDType);
        }
        CreditorFinancialAccountType creditorFinancialAccountType = tradeSettlementPaymentMeansType.getPayeePartyCreditorFinancialAccount();
        boolean bl4 = bl3 = CIIToUBL21Converter.isPaymentMeansCodeCreditTransfer(string) && creditorFinancialAccountType != null;
        if (bl3) {
            paymentIDType = new FinancialAccountType();
            paymentIDType.setID(CIIToUBL21Converter._copyID(creditorFinancialAccountType.getIBANID()));
            if (paymentIDType.getID() == null) {
                paymentIDType.setID(CIIToUBL21Converter._copyID(creditorFinancialAccountType.getProprietaryID()));
            }
            paymentIDType.setName(CIIToUBL21Converter.copyName(creditorFinancialAccountType.getAccountName(), new NameType()));
            tradeSettlementFinancialCardType = tradeSettlementPaymentMeansType.getPayeeSpecifiedCreditorFinancialInstitution();
            if (tradeSettlementFinancialCardType != null) {
                cardAccountType = new BranchType();
                cardAccountType.setID(CIIToUBL21Converter._copyID(tradeSettlementFinancialCardType.getBICID()));
                if (cardAccountType.getID() != null) {
                    paymentIDType.setFinancialInstitutionBranch((BranchType)cardAccountType);
                }
            }
            paymentMeansType.setPayeeFinancialAccount((FinancialAccountType)paymentIDType);
        }
        if (bl2 = CIIToUBL21Converter.isPaymentMeansCodePaymentCard(string)) {
            tradeSettlementFinancialCardType = tradeSettlementPaymentMeansType.getApplicableTradeSettlementFinancialCard();
            if (tradeSettlementFinancialCardType == null) {
                errorList.add((Object)CIIToUBL21Converter.buildError(null, "The element 'ApplicableTradeSettlementFinancialCard' is missing for Payment Card Information"));
            } else {
                cardAccountType = new CardAccountType();
                cardAccountType.setPrimaryAccountNumberID(CIIToUBL21Converter.copyID(tradeSettlementFinancialCardType.getID(), new PrimaryAccountNumberIDType()));
                if (StringHelper.hasText((String)this.getCardAccountNetworkID())) {
                    cardAccountType.setNetworkID(this.getCardAccountNetworkID());
                }
                if (StringHelper.hasText((String)tradeSettlementFinancialCardType.getCardholderNameValue())) {
                    cardAccountType.setHolderName(tradeSettlementFinancialCardType.getCardholderNameValue());
                }
                if (StringHelper.hasNoText((String)cardAccountType.getPrimaryAccountNumberIDValue())) {
                    errorList.add((Object)CIIToUBL21Converter.buildError(null, "The Payment card primary account number is missing"));
                } else if (StringHelper.hasNoText((String)cardAccountType.getNetworkIDValue())) {
                    errorList.add((Object)CIIToUBL21Converter.buildError(null, "The Payment card network ID is missing"));
                } else {
                    paymentMeansType.setCardAccount(cardAccountType);
                }
            }
        }
        if (bl = CIIToUBL21Converter.isPaymentMeansCodeDirectDebit(string)) {
            TradePaymentTermsType tradePaymentTermsType;
            cardAccountType = new PaymentMandateType();
            IDType iDType = headerTradeSettlementType.getSpecifiedTradePaymentTerms().iterator();
            while (iDType.hasNext()) {
                tradePaymentTermsType = (TradePaymentTermsType)iDType.next();
                if (!tradePaymentTermsType.hasDirectDebitMandateIDEntries()) continue;
                cardAccountType.setID(CIIToUBL21Converter._copyID(tradePaymentTermsType.getDirectDebitMandateIDAtIndex(0)));
                if (cardAccountType.getID() == null) continue;
                break;
            }
            if ((iDType = headerTradeSettlementType.getCreditorReferenceID()) != null && (tradePaymentTermsType = CIIToUBL21Converter._copyID(iDType)) != null) {
                tradePaymentTermsType.setSchemeID("SEPA");
                consumer.accept((oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType)tradePaymentTermsType);
            }
            if ((tradePaymentTermsType = tradeSettlementPaymentMeansType.getPayerPartyDebtorFinancialAccount()) != null) {
                FinancialAccountType financialAccountType = new FinancialAccountType();
                financialAccountType.setID(CIIToUBL21Converter._copyID(tradePaymentTermsType.getIBANID()));
                if (financialAccountType.getID() != null) {
                    cardAccountType.setPayerFinancialAccount(financialAccountType);
                }
            }
            paymentMeansType.setPaymentMandate((PaymentMandateType)cardAccountType);
        }
        if (bl3 || bl2 || bl || CIIToUBL21Converter.isPaymentMeansCodeOtherKnown(string)) {
            consumer2.accept(paymentMeansType);
        } else {
            errorList.add((Object)CIIToUBL21Converter.buildError(null, "Failed to determine a supported Payment Means Type from code '" + string + "'"));
        }
    }

    @Nullable
    private OrderReferenceType _createUBLOrderRef(@Nullable ReferencedDocumentType referencedDocumentType, @Nullable ReferencedDocumentType referencedDocumentType2) {
        OrderReferenceType orderReferenceType = new OrderReferenceType();
        if (referencedDocumentType != null) {
            orderReferenceType.setID(referencedDocumentType.getIssuerAssignedIDValue());
        }
        if (referencedDocumentType2 != null) {
            if (orderReferenceType.getIDValue() == null) {
                orderReferenceType.setID(this.getDefaultOrderRefID());
            }
            CIIToUBL21Converter.ifNotEmpty(referencedDocumentType2.getIssuerAssignedIDValue(), arg_0 -> ((OrderReferenceType)orderReferenceType).setSalesOrderID(arg_0));
        }
        if (StringHelper.hasNoText((String)orderReferenceType.getIDValue()) && StringHelper.hasNoText((String)orderReferenceType.getSalesOrderIDValue())) {
            return null;
        }
        return orderReferenceType;
    }

    @Nullable
    public InvoiceType convertToInvoice(@Nonnull CrossIndustryInvoiceType crossIndustryInvoiceType, @Nonnull ErrorList errorList) {
        PartyNameType partyNameType;
        PartyType partyType;
        TextType textType;
        TradeAddressType tradeAddressType;
        oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType iDType22;
        PartyTaxSchemeType partyTaxSchemeType2;
        Object object6;
        Object object22;
        Object object32;
        ValueEnforcer.notNull((Object)crossIndustryInvoiceType, (String)"CIIInvoice");
        ValueEnforcer.notNull((Object)errorList, (String)"ErrorList");
        ExchangedDocumentType exchangedDocumentType = crossIndustryInvoiceType.getExchangedDocument();
        SupplyChainTradeTransactionType supplyChainTradeTransactionType = crossIndustryInvoiceType.getSupplyChainTradeTransaction();
        if (supplyChainTradeTransactionType == null) {
            return null;
        }
        HeaderTradeAgreementType headerTradeAgreementType = supplyChainTradeTransactionType.getApplicableHeaderTradeAgreement();
        HeaderTradeDeliveryType headerTradeDeliveryType = supplyChainTradeTransactionType.getApplicableHeaderTradeDelivery();
        HeaderTradeSettlementType headerTradeSettlementType = supplyChainTradeTransactionType.getApplicableHeaderTradeSettlement();
        if (headerTradeAgreementType == null || headerTradeDeliveryType == null || headerTradeSettlementType == null) {
            return null;
        }
        InvoiceType invoiceType = new InvoiceType();
        ExchangedDocumentContextType exchangedDocumentContextType = crossIndustryInvoiceType.getExchangedDocumentContext();
        if (exchangedDocumentContextType != null) {
            if (exchangedDocumentContextType.hasBusinessProcessSpecifiedDocumentContextParameterEntries()) {
                invoiceType.setProfileID(exchangedDocumentContextType.getBusinessProcessSpecifiedDocumentContextParameterAtIndex(0).getIDValue());
            }
            if (exchangedDocumentContextType.hasGuidelineSpecifiedDocumentContextParameterEntries()) {
                invoiceType.setCustomizationID(exchangedDocumentContextType.getGuidelineSpecifiedDocumentContextParameterAtIndex(0).getIDValue());
            }
        }
        if (StringHelper.hasText((String)this.getProfileID())) {
            invoiceType.setProfileID(this.getProfileID());
        }
        if (StringHelper.hasText((String)this.getCustomizationID())) {
            invoiceType.setCustomizationID(this.getCustomizationID());
        }
        if (exchangedDocumentType != null) {
            invoiceType.setID(exchangedDocumentType.getIDValue());
        }
        SupplierPartyType supplierPartyType = new SupplierPartyType();
        invoiceType.setAccountingSupplierParty(supplierPartyType);
        CustomerPartyType customerPartyType = new CustomerPartyType();
        invoiceType.setAccountingCustomerParty(customerPartyType);
        Object object4 = null;
        if (exchangedDocumentType != null && exchangedDocumentType.getIssueDateTime() != null) {
            object4 = CIIToUBL21Converter.parseDate(exchangedDocumentType.getIssueDateTime().getDateTimeString(), (IErrorList)errorList);
        }
        if (object4 != null) {
            invoiceType.setIssueDate(object4);
        }
        object4 = null;
        Object object52 = headerTradeSettlementType.getSpecifiedTradePaymentTerms().iterator();
        while (object52.hasNext() && ((object32 = (TradePaymentTermsType)object52.next()).getDueDateDateTime() == null || (object4 = CIIToUBL21Converter.parseDate(object32.getDueDateDateTime().getDateTimeString(), (IErrorList)errorList)) == null)) {
        }
        if (object4 != null) {
            invoiceType.setDueDate((LocalDate)object4);
        }
        if (exchangedDocumentType != null) {
            invoiceType.setInvoiceTypeCode(exchangedDocumentType.getTypeCodeValue());
        }
        if (exchangedDocumentType != null) {
            for (Object object52 : exchangedDocumentType.getIncludedNote()) {
                CIIToUBL21Converter.ifNotNull(CIIToUBL21Converter._copyNote((NoteType)object52), arg_0 -> ((InvoiceType)invoiceType).addNote(arg_0));
            }
        }
        for (Object object52 : headerTradeSettlementType.getApplicableTradeTax()) {
            if (object52.getTaxPointDate() == null || (object32 = CIIToUBL21Converter.parseDate(object52.getTaxPointDate().getDateString(), (IErrorList)errorList)) == null) continue;
            invoiceType.setTaxPointDate((LocalDate)object32);
            break;
        }
        object4 = headerTradeSettlementType.getInvoiceCurrencyCodeValue();
        invoiceType.setDocumentCurrencyCode((String)object4);
        if (headerTradeSettlementType.getTaxCurrencyCodeValue() != null) {
            invoiceType.setTaxCurrencyCode(headerTradeSettlementType.getTaxCurrencyCodeValue());
        }
        for (Object object32 : headerTradeSettlementType.getReceivableSpecifiedTradeAccountingAccount()) {
            object22 = object32.getIDValue();
            if (!StringHelper.hasText((String)object22)) continue;
            invoiceType.setAccountingCost((String)object22);
            break;
        }
        if (headerTradeAgreementType.getBuyerReferenceValue() != null) {
            invoiceType.setBuyerReference(headerTradeAgreementType.getBuyerReferenceValue());
        }
        object52 = new PeriodType();
        object32 = headerTradeSettlementType.getBillingSpecifiedPeriod();
        if (object32 != null) {
            object22 = object32.getStartDateTime();
            if (object22 != null) {
                object52.setStartDate(CIIToUBL21Converter.parseDate(object22.getDateTimeString(), (IErrorList)errorList));
            }
            if ((object6 = object32.getEndDateTime()) != null) {
                object52.setEndDate(CIIToUBL21Converter.parseDate(object6.getDateTimeString(), (IErrorList)errorList));
            }
        }
        if (headerTradeSettlementType.hasApplicableTradeTaxEntries() && StringHelper.hasText((String)(object22 = headerTradeSettlementType.getApplicableTradeTaxAtIndex(0)).getDueDateTypeCodeValue())) {
            object52.addDescriptionCode(new DescriptionCodeType(CIIToUBL21Converter.mapDueDateTypeCode(object22.getDueDateTypeCodeValue())));
        }
        if (object52.getStartDate() != null || object52.getEndDate() != null || object52.hasDescriptionCodeEntries()) {
            invoiceType.addInvoicePeriod((PeriodType)object52);
        }
        object52 = this._createUBLOrderRef(headerTradeAgreementType.getBuyerOrderReferencedDocument(), headerTradeAgreementType.getSellerOrderReferencedDocument());
        invoiceType.setOrderReference((OrderReferenceType)object52);
        object52 = CIIToUBL21Converter._convertDocumentReference(headerTradeSettlementType.getInvoiceReferencedDocument(), (IErrorList)errorList);
        if (object52 != null) {
            object32 = new BillingReferenceType();
            object32.setInvoiceDocumentReference((DocumentReferenceType)object52);
            invoiceType.addBillingReference((BillingReferenceType)object32);
        }
        if ((object52 = CIIToUBL21Converter._convertDocumentReference(headerTradeDeliveryType.getDespatchAdviceReferencedDocument(), (IErrorList)errorList)) != null) {
            invoiceType.addDespatchDocumentReference((DocumentReferenceType)object52);
        }
        if ((object52 = CIIToUBL21Converter._convertDocumentReference(headerTradeDeliveryType.getReceivingAdviceReferencedDocument(), (IErrorList)errorList)) != null) {
            invoiceType.addReceiptDocumentReference((DocumentReferenceType)object52);
        }
        for (Object object32 : headerTradeAgreementType.getAdditionalReferencedDocument()) {
            if (!CIIToUBL21Converter.isOriginatorDocumentReferenceTypeCode(object32.getTypeCodeValue()) || (object22 = CIIToUBL21Converter._convertDocumentReference((ReferencedDocumentType)object32, (IErrorList)errorList)) == null) continue;
            object22.setDocumentTypeCode((DocumentTypeCodeType)null);
            invoiceType.addOriginatorDocumentReference((DocumentReferenceType)object22);
        }
        object52 = CIIToUBL21Converter._convertDocumentReference(headerTradeAgreementType.getContractReferencedDocument(), (IErrorList)errorList);
        if (object52 != null) {
            invoiceType.addContractDocumentReference((DocumentReferenceType)object52);
        }
        for (Object object32 : headerTradeAgreementType.getAdditionalReferencedDocument()) {
            if (CIIToUBL21Converter.isOriginatorDocumentReferenceTypeCode(object32.getTypeCodeValue()) || (object22 = CIIToUBL21Converter._convertDocumentReference((ReferencedDocumentType)object32, (IErrorList)errorList)) == null) continue;
            invoiceType.addAdditionalDocumentReference((DocumentReferenceType)object22);
        }
        object52 = headerTradeAgreementType.getSpecifiedProcuringProject();
        if (object52 != null && StringHelper.hasText((String)(object32 = object52.getIDValue()))) {
            object22 = new ProjectReferenceType();
            object22.setID((String)object32);
            invoiceType.addProjectReference((ProjectReferenceType)object22);
        }
        if ((object52 = headerTradeAgreementType.getSellerTradeParty()) != null) {
            object32 = CIIToUBL21Converter._convertParty((TradePartyType)object52, true, true);
            for (Object object6 : object52.getSpecifiedTaxRegistration()) {
                partyTaxSchemeType2 = this._convertPartyTaxScheme((TaxRegistrationType)object6);
                if (partyTaxSchemeType2 == null) continue;
                object32.addPartyTaxScheme(partyTaxSchemeType2);
            }
            CIIToUBL21Converter._convertPartyLegalEntity((TradePartyType)object52, (PartyType)object32);
            object22 = CIIToUBL21Converter._convertContact((TradePartyType)object52);
            if (object22 != null) {
                object32.setContact((ContactType)object22);
            }
            supplierPartyType.setParty((PartyType)object32);
        }
        if ((object52 = headerTradeAgreementType.getBuyerTradeParty()) != null) {
            object32 = CIIToUBL21Converter._convertParty((TradePartyType)object52, false, true);
            for (Object object6 : object52.getSpecifiedTaxRegistration()) {
                partyTaxSchemeType2 = this._convertPartyTaxScheme((TaxRegistrationType)object6);
                if (partyTaxSchemeType2 == null) continue;
                object32.addPartyTaxScheme(partyTaxSchemeType2);
            }
            CIIToUBL21Converter._convertPartyLegalEntity((TradePartyType)object52, (PartyType)object32);
            object22 = CIIToUBL21Converter._convertContact((TradePartyType)object52);
            if (object22 != null) {
                object32.setContact((ContactType)object22);
            }
            customerPartyType.setParty((PartyType)object32);
        }
        if ((object52 = headerTradeSettlementType.getPayeeTradeParty()) != null) {
            object32 = CIIToUBL21Converter._convertParty((TradePartyType)object52, false, false);
            for (Object object6 : object52.getSpecifiedTaxRegistration()) {
                partyTaxSchemeType2 = this._convertPartyTaxScheme((TaxRegistrationType)object6);
                if (partyTaxSchemeType2 == null) continue;
                object32.addPartyTaxScheme(partyTaxSchemeType2);
            }
            object22 = CIIToUBL21Converter._convertContact((TradePartyType)object52);
            if (object22 != null) {
                object32.setContact((ContactType)object22);
            }
            invoiceType.setPayeeParty((PartyType)object32);
        }
        if ((object52 = headerTradeAgreementType.getSellerTaxRepresentativeTradeParty()) != null) {
            object32 = CIIToUBL21Converter._convertParty((TradePartyType)object52, false, false);
            for (Object object6 : object52.getSpecifiedTaxRegistration()) {
                partyTaxSchemeType2 = this._convertPartyTaxScheme((TaxRegistrationType)object6);
                if (partyTaxSchemeType2 == null) continue;
                object32.addPartyTaxScheme(partyTaxSchemeType2);
            }
            object22 = CIIToUBL21Converter._convertContact((TradePartyType)object52);
            if (object22 != null) {
                object32.setContact((ContactType)object22);
            }
            invoiceType.setTaxRepresentativeParty((PartyType)object32);
        }
        object52 = new DeliveryType();
        boolean bl = false;
        object22 = headerTradeDeliveryType.getActualDeliverySupplyChainEvent();
        if (object22 != null && (object6 = object22.getOccurrenceDateTime()) != null) {
            object52.setActualDeliveryDate(CIIToUBL21Converter.parseDate(object6.getDateTimeString(), (IErrorList)errorList));
            bl = true;
        }
        if ((object6 = headerTradeDeliveryType.getShipToTradeParty()) != null) {
            partyTaxSchemeType2 = new LocationType();
            boolean bl2 = false;
            iDType22 = CIIToUBL21Converter._extractFirstPartyID((TradePartyType)object6);
            if (iDType22 != null) {
                partyTaxSchemeType2.setID(iDType22);
                bl2 = true;
            }
            if ((tradeAddressType = object6.getPostalTradeAddress()) != null) {
                partyTaxSchemeType2.setAddress(CIIToUBL21Converter._convertPostalAddress(tradeAddressType));
                bl2 = true;
            }
            if (bl2) {
                object52.setDeliveryLocation((LocationType)partyTaxSchemeType2);
                bl = true;
            }
            if ((textType = object6.getName()) != null) {
                partyType = new PartyType();
                partyNameType = new PartyNameType();
                partyNameType.setName(CIIToUBL21Converter.copyName(textType, new NameType()));
                partyType.addPartyName(partyNameType);
                object52.setDeliveryParty(partyType);
                bl = true;
            }
        }
        if (bl) {
            invoiceType.addDelivery((DeliveryType)object52);
        }
        for (TradeSettlementPaymentMeansType tradeSettlementPaymentMeansType : headerTradeSettlementType.getSpecifiedTradeSettlementPaymentMeans()) {
            this._convertPaymentMeans(headerTradeSettlementType, tradeSettlementPaymentMeansType, iDType -> CIIToUBL21Converter._addPartyID(iDType, invoiceType.getAccountingSupplierParty().getParty()), arg_0 -> ((InvoiceType)invoiceType).addPaymentMeans(arg_0), errorList);
        }
        for (TradePaymentTermsType tradePaymentTermsType : headerTradeSettlementType.getSpecifiedTradePaymentTerms()) {
            object22 = new PaymentTermsType();
            for (PartyTaxSchemeType partyTaxSchemeType2 : tradePaymentTermsType.getDescription()) {
                CIIToUBL21Converter.ifNotNull(CIIToUBL21Converter._copyNote((TextType)partyTaxSchemeType2), arg_0 -> ((PaymentTermsType)object22).addNote(arg_0));
            }
            if (!object22.hasNoteEntries()) continue;
            invoiceType.addPaymentTerms((PaymentTermsType)object22);
        }
        for (TradeAllowanceChargeType tradeAllowanceChargeType : headerTradeSettlementType.getSpecifiedTradeAllowanceCharge()) {
            object22 = ETriState.UNDEFINED;
            if (tradeAllowanceChargeType.getChargeIndicator() != null) {
                object22 = CIIToUBL21Converter.parseIndicator(tradeAllowanceChargeType.getChargeIndicator(), (IErrorList)errorList);
            } else {
                errorList.add((Object)CIIToUBL21Converter.buildError(new String[]{"CrossIndustryInvoice", "SupplyChainTradeTransaction", "ApplicableHeaderTradeSettlement", "SpecifiedTradeAllowanceCharge"}, "Failed to determine if SpecifiedTradeAllowanceCharge is an Allowance or a Charge"));
            }
            if (!object22.isDefined()) continue;
            object6 = new AllowanceChargeType();
            object6.setChargeIndicator(object22.getAsBooleanValue());
            this._copyAllowanceCharge(tradeAllowanceChargeType, (AllowanceChargeType)object6, (String)object4);
            invoiceType.addAllowanceCharge((AllowanceChargeType)object6);
        }
        object52 = headerTradeSettlementType.getSpecifiedTradeSettlementHeaderMonetarySummation();
        Object object7 = null;
        if (object52 != null && object52.hasTaxTotalAmountEntries()) {
            for (Object object6 : object52.getTaxTotalAmount()) {
                partyTaxSchemeType2 = new TaxTotalType();
                partyTaxSchemeType2.setTaxAmount(CIIToUBL21Converter.copyAmount((un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType)object6, new TaxAmountType(), (String)object4));
                invoiceType.addTaxTotal((TaxTotalType)partyTaxSchemeType2);
                if (object7 != null) continue;
                object7 = partyTaxSchemeType2;
            }
        } else {
            object22 = new TaxAmountType();
            object22.setValue(BigDecimal.ZERO);
            object22.setCurrencyID((String)object4);
            object7 = new TaxTotalType();
            object7.setTaxAmount((TaxAmountType)object22);
            invoiceType.addTaxTotal((TaxTotalType)object7);
        }
        for (Object object6 : headerTradeSettlementType.getApplicableTradeTax()) {
            partyTaxSchemeType2 = new TaxSubtotalType();
            if (object6.hasBasisAmountEntries()) {
                partyTaxSchemeType2.setTaxableAmount(CIIToUBL21Converter.copyAmount(object6.getBasisAmountAtIndex(0), new TaxableAmountType(), (String)object4));
            }
            if (object6.hasCalculatedAmountEntries()) {
                partyTaxSchemeType2.setTaxAmount(CIIToUBL21Converter.copyAmount(object6.getCalculatedAmountAtIndex(0), new TaxAmountType(), (String)object4));
            }
            TaxCategoryType taxCategoryType = new TaxCategoryType();
            taxCategoryType.setID(object6.getCategoryCodeValue());
            if (object6.getRateApplicablePercentValue() != null) {
                taxCategoryType.setPercent(MathHelper.getWithoutTrailingZeroes((BigDecimal)object6.getRateApplicablePercentValue()));
            }
            if (StringHelper.hasText((String)object6.getExemptionReasonCodeValue())) {
                taxCategoryType.setTaxExemptionReasonCode(object6.getExemptionReasonCodeValue());
            }
            if (object6.getExemptionReason() != null) {
                iDType22 = new TaxExemptionReasonType();
                iDType22.setValue(object6.getExemptionReason().getValue());
                iDType22.setLanguageID(object6.getExemptionReason().getLanguageID());
                iDType22.setLanguageLocaleID(object6.getExemptionReason().getLanguageLocaleID());
                taxCategoryType.addTaxExemptionReason((TaxExemptionReasonType)iDType22);
            }
            iDType22 = new TaxSchemeType();
            iDType22.setID(this.getVATScheme());
            taxCategoryType.setTaxScheme((TaxSchemeType)iDType22);
            partyTaxSchemeType2.setTaxCategory(taxCategoryType);
            object7.addTaxSubtotal((TaxSubtotalType)partyTaxSchemeType2);
        }
        object7 = new MonetaryTotalType();
        if (object52 != null) {
            if (object52.hasLineTotalAmountEntries()) {
                object7.setLineExtensionAmount(CIIToUBL21Converter.copyAmount(object52.getLineTotalAmountAtIndex(0), new LineExtensionAmountType(), (String)object4));
            }
            if (object52.hasTaxBasisTotalAmountEntries()) {
                object7.setTaxExclusiveAmount(CIIToUBL21Converter.copyAmount(object52.getTaxBasisTotalAmountAtIndex(0), new TaxExclusiveAmountType(), (String)object4));
            }
            if (object52.hasGrandTotalAmountEntries()) {
                object7.setTaxInclusiveAmount(CIIToUBL21Converter.copyAmount(object52.getGrandTotalAmountAtIndex(0), new TaxInclusiveAmountType(), (String)object4));
            }
            if (object52.hasAllowanceTotalAmountEntries()) {
                object7.setAllowanceTotalAmount(CIIToUBL21Converter.copyAmount(object52.getAllowanceTotalAmountAtIndex(0), new AllowanceTotalAmountType(), (String)object4));
            }
            if (object52.hasChargeTotalAmountEntries()) {
                object7.setChargeTotalAmount(CIIToUBL21Converter.copyAmount(object52.getChargeTotalAmountAtIndex(0), new ChargeTotalAmountType(), (String)object4));
            }
            if (object52.hasTotalPrepaidAmountEntries()) {
                object7.setPrepaidAmount(CIIToUBL21Converter.copyAmount(object52.getTotalPrepaidAmountAtIndex(0), new PrepaidAmountType(), (String)object4));
            }
            if (object52.hasRoundingAmountEntries() && MathHelper.isNE0((BigDecimal)object52.getRoundingAmountAtIndex(0).getValue())) {
                object7.setPayableRoundingAmount(CIIToUBL21Converter.copyAmount(object52.getRoundingAmountAtIndex(0), new PayableRoundingAmountType(), (String)object4));
            }
            if (object52.hasDuePayableAmountEntries()) {
                object7.setPayableAmount(CIIToUBL21Converter.copyAmount(object52.getDuePayableAmountAtIndex(0), new PayableAmountType(), (String)object4));
            }
        }
        invoiceType.setLegalMonetaryTotal((MonetaryTotalType)object7);
        for (Object object22 : supplyChainTradeTransactionType.getIncludedSupplyChainTradeLineItem()) {
            CodeType codeType;
            Object object8;
            Object object9;
            IDType iDType3;
            TaxCategoryType taxCategoryType;
            IDType iDType42;
            Object object10;
            DateTimeType dateTimeType2;
            Object object11;
            object6 = new InvoiceLineType();
            partyTaxSchemeType2 = object22.getAssociatedDocumentLineDocument();
            object6.setID(CIIToUBL21Converter._copyID(partyTaxSchemeType2.getLineID()));
            for (oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType iDType22 : partyTaxSchemeType2.getIncludedNote()) {
                CIIToUBL21Converter.ifNotNull(CIIToUBL21Converter._copyNote((NoteType)iDType22), arg_0 -> ((InvoiceLineType)object6).addNote(arg_0));
            }
            boolean bl3 = false;
            iDType22 = object22.getSpecifiedLineTradeSettlement();
            tradeAddressType = iDType22.getSpecifiedTradeSettlementLineMonetarySummation();
            if (tradeAddressType != null && tradeAddressType.hasLineTotalAmountEntries()) {
                object6.setLineExtensionAmount(CIIToUBL21Converter.copyAmount(tradeAddressType.getLineTotalAmountAtIndex(0), new LineExtensionAmountType(), (String)object4));
                if (CIIToUBL21Converter.isLT0Strict(object6.getLineExtensionAmountValue())) {
                    bl3 = true;
                }
            }
            if ((textType = object22.getSpecifiedLineTradeDelivery()) != null && (partyType = textType.getBilledQuantity()) != null) {
                object6.setInvoicedQuantity(CIIToUBL21Converter.copyQuantity((QuantityType)partyType, new InvoicedQuantityType()));
            }
            if (iDType22.hasReceivableSpecifiedTradeAccountingAccountEntries()) {
                partyType = iDType22.getReceivableSpecifiedTradeAccountingAccountAtIndex(0);
                object6.setAccountingCost(partyType.getIDValue());
            }
            if ((partyType = iDType22.getBillingSpecifiedPeriod()) != null) {
                partyNameType = new PeriodType();
                object11 = partyType.getStartDateTime();
                if (object11 != null) {
                    partyNameType.setStartDate(CIIToUBL21Converter.parseDate(object11.getDateTimeString(), (IErrorList)errorList));
                }
                if ((dateTimeType2 = partyType.getEndDateTime()) != null) {
                    partyNameType.setEndDate(CIIToUBL21Converter.parseDate(dateTimeType2.getDateTimeString(), (IErrorList)errorList));
                }
                if (partyNameType.getStartDate() != null || partyNameType.getEndDate() != null) {
                    object6.addInvoicePeriod((PeriodType)partyNameType);
                }
            }
            if ((partyNameType = object22.getSpecifiedLineTradeAgreement()) != null && (object11 = partyNameType.getBuyerOrderReferencedDocument()) != null && StringHelper.hasText((String)object11.getLineIDValue())) {
                dateTimeType2 = new OrderLineReferenceType();
                dateTimeType2.setLineID(CIIToUBL21Converter.copyID(object11.getLineID(), new LineIDType()));
                object6.addOrderLineReference((OrderLineReferenceType)dateTimeType2);
            }
            for (DateTimeType dateTimeType2 : iDType22.getAdditionalReferencedDocument()) {
                object10 = CIIToUBL21Converter._convertDocumentReference((ReferencedDocumentType)dateTimeType2, (IErrorList)errorList);
                if (object10 == null) continue;
                object6.addDocumentReference((DocumentReferenceType)object10);
            }
            for (DateTimeType dateTimeType2 : iDType22.getSpecifiedTradeAllowanceCharge()) {
                object10 = ETriState.UNDEFINED;
                if (dateTimeType2.getChargeIndicator() != null) {
                    object10 = CIIToUBL21Converter.parseIndicator(dateTimeType2.getChargeIndicator(), (IErrorList)errorList);
                } else {
                    errorList.add((Object)CIIToUBL21Converter.buildError(new String[]{"CrossIndustryInvoice", "SupplyChainTradeTransaction", "IncludedSupplyChainTradeLineItem", "SpecifiedLineTradeSettlement", "SpecifiedTradeAllowanceCharge"}, "Failed to determine if SpecifiedTradeAllowanceCharge is an Allowance or a Charge"));
                }
                if (!object10.isDefined()) continue;
                iDType42 = new AllowanceChargeType();
                iDType42.setChargeIndicator(object10.getAsBooleanValue());
                this._copyAllowanceCharge((TradeAllowanceChargeType)dateTimeType2, (AllowanceChargeType)iDType42, (String)object4);
                object6.addAllowanceCharge((AllowanceChargeType)iDType42);
            }
            object11 = new ItemType();
            dateTimeType2 = object22.getSpecifiedTradeProduct();
            if (dateTimeType2 != null) {
                object10 = dateTimeType2.getDescription();
                if (object10 != null) {
                    CIIToUBL21Converter.ifNotNull(CIIToUBL21Converter.copyName((TextType)object10, new DescriptionType()), arg_0 -> ((ItemType)object11).addDescription(arg_0));
                }
                if (dateTimeType2.hasNameEntries()) {
                    object11.setName(CIIToUBL21Converter.copyName(dateTimeType2.getNameAtIndex(0), new NameType()));
                }
                if ((iDType42 = dateTimeType2.getBuyerAssignedID()) != null) {
                    taxCategoryType = new ItemIdentificationType();
                    taxCategoryType.setID(CIIToUBL21Converter._copyID(iDType42));
                    if (StringHelper.hasText((String)taxCategoryType.getIDValue())) {
                        object11.setBuyersItemIdentification((ItemIdentificationType)taxCategoryType);
                    }
                }
                if ((taxCategoryType = dateTimeType2.getSellerAssignedID()) != null) {
                    iDType3 = new ItemIdentificationType();
                    iDType3.setID(CIIToUBL21Converter._copyID((IDType)taxCategoryType));
                    if (StringHelper.hasText((String)iDType3.getIDValue())) {
                        object11.setSellersItemIdentification((ItemIdentificationType)iDType3);
                    }
                }
                if ((iDType3 = dateTimeType2.getGlobalID()) != null) {
                    object9 = new ItemIdentificationType();
                    object9.setID(CIIToUBL21Converter._copyID(iDType3));
                    if (StringHelper.hasText((String)object9.getIDValue())) {
                        object11.setStandardItemIdentification((ItemIdentificationType)object9);
                    }
                }
                if ((object9 = dateTimeType2.getOriginTradeCountry()) != null) {
                    object8 = new CountryType();
                    object8.setIdentificationCode(object9.getIDValue());
                    if (object9.hasNameEntries()) {
                        object8.setName(CIIToUBL21Converter.copyName(object9.getNameAtIndex(0), new NameType()));
                    }
                    object11.setOriginCountry((CountryType)object8);
                }
                for (ProductClassificationType productClassificationType : dateTimeType2.getDesignatedProductClassification()) {
                    codeType = productClassificationType.getClassCode();
                    if (codeType == null) continue;
                    CommodityClassificationType commodityClassificationType = new CommodityClassificationType();
                    commodityClassificationType.setItemClassificationCode(CIIToUBL21Converter.copyCode(codeType, new ItemClassificationCodeType()));
                    if (commodityClassificationType.getItemClassificationCode() == null) continue;
                    object11.addCommodityClassification(commodityClassificationType);
                }
            }
            for (IDType iDType42 : iDType22.getApplicableTradeTax()) {
                taxCategoryType = new TaxCategoryType();
                taxCategoryType.setID(iDType42.getCategoryCodeValue());
                if (iDType42.getRateApplicablePercentValue() != null) {
                    taxCategoryType.setPercent(MathHelper.getWithoutTrailingZeroes((BigDecimal)iDType42.getRateApplicablePercentValue()));
                }
                iDType3 = new TaxSchemeType();
                iDType3.setID(this.getVATScheme());
                taxCategoryType.setTaxScheme((TaxSchemeType)iDType3);
                object11.addClassifiedTaxCategory(taxCategoryType);
            }
            if (dateTimeType2 != null) {
                for (IDType iDType42 : dateTimeType2.getApplicableProductCharacteristic()) {
                    if (!iDType42.hasDescriptionEntries()) continue;
                    taxCategoryType = new ItemPropertyType();
                    taxCategoryType.setName(CIIToUBL21Converter.copyName(iDType42.getDescriptionAtIndex(0), new NameType()));
                    if (iDType42.hasValueEntries()) {
                        taxCategoryType.setValue(iDType42.getValueAtIndex(0).getValue());
                    }
                    if (taxCategoryType.getName() == null) continue;
                    object11.addAdditionalItemProperty((ItemPropertyType)taxCategoryType);
                }
            }
            object10 = new PriceType();
            boolean bl4 = false;
            taxCategoryType = new AllowanceChargeType();
            taxCategoryType.setChargeIndicator(false);
            object10.addAllowanceCharge((AllowanceChargeType)taxCategoryType);
            boolean bl5 = false;
            if (partyNameType != null) {
                ProductClassificationType productClassificationType;
                object9 = null;
                object8 = partyNameType.getGrossPriceProductTradePrice();
                if (object8 != null) {
                    if (object8.hasAppliedTradeAllowanceChargeEntries() && (productClassificationType = object8.getAppliedTradeAllowanceChargeAtIndex(0)).hasActualAmountEntries() && (codeType = productClassificationType.getActualAmountAtIndex(0)) != null) {
                        taxCategoryType.setAmount(CIIToUBL21Converter.copyAmount((un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType)codeType, new AmountType(), (String)object4));
                        boolean bl6 = bl5 = taxCategoryType.getAmount() != null;
                    }
                    if (object8.hasChargeAmountEntries() && (productClassificationType = object8.getChargeAmountAtIndex(0)) != null) {
                        taxCategoryType.setBaseAmount(CIIToUBL21Converter.copyAmount((un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType)productClassificationType, new BaseAmountType(), (String)object4));
                        if (!bl5) {
                            taxCategoryType.setAmount(BigDecimal.ZERO).setCurrencyID((String)object4);
                            bl5 = true;
                        }
                    }
                    if (object8.getBasisQuantity() != null) {
                        object9 = object8.getBasisQuantity().getUnitCode();
                    }
                }
                if ((productClassificationType = partyNameType.getNetPriceProductTradePrice()) != null) {
                    if (productClassificationType.hasChargeAmountEntries()) {
                        object10.setPriceAmount(CIIToUBL21Converter.copyAmount(productClassificationType.getChargeAmountAtIndex(0), new PriceAmountType(), (String)object4));
                        bl4 = object10.getPriceAmount() != null;
                    }
                    QuantityType quantityType = codeType = object8 != null ? object8.getBasisQuantity() : null;
                    if (codeType == null) {
                        codeType = productClassificationType.getBasisQuantity();
                    }
                    if (codeType != null) {
                        object10.setBaseQuantity(CIIToUBL21Converter.copyQuantity((QuantityType)codeType, new BaseQuantityType()));
                        if (object10.getBaseQuantity() != null) {
                            object10.getBaseQuantity().setUnitCode((String)object9);
                        }
                    }
                }
            }
            if (object6.getInvoicedQuantityValue() != null) {
                this.swapQuantityAndPriceIfNeeded(bl3, object6.getInvoicedQuantityValue(), arg_0 -> ((InvoiceLineType)object6).setInvoicedQuantity(arg_0), bl4 ? object10.getPriceAmountValue() : null, bl4 ? arg_0 -> ((PriceType)object10).setPriceAmount(arg_0) : null, (IErrorList)errorList);
            }
            if (bl4) {
                if (!bl5) {
                    object10.setAllowanceCharge(null);
                }
                object6.setPrice((PriceType)object10);
            }
            object6.setItem((ItemType)object11);
            invoiceType.addInvoiceLine((InvoiceLineType)object6);
        }
        return invoiceType;
    }

    @Nullable
    public CreditNoteType convertToCreditNote(@Nonnull CrossIndustryInvoiceType crossIndustryInvoiceType, @Nonnull ErrorList errorList) {
        PartyNameType partyNameType;
        PartyType partyType;
        TextType textType;
        TradeAddressType tradeAddressType2;
        Object object;
        PartyTaxSchemeType partyTaxSchemeType;
        Object object22;
        Object object32;
        Object object42;
        Object object52;
        ValueEnforcer.notNull((Object)crossIndustryInvoiceType, (String)"CIICreditNote");
        ValueEnforcer.notNull((Object)errorList, (String)"ErrorList");
        ExchangedDocumentType exchangedDocumentType = crossIndustryInvoiceType.getExchangedDocument();
        SupplyChainTradeTransactionType supplyChainTradeTransactionType = crossIndustryInvoiceType.getSupplyChainTradeTransaction();
        if (supplyChainTradeTransactionType == null) {
            return null;
        }
        HeaderTradeAgreementType headerTradeAgreementType = supplyChainTradeTransactionType.getApplicableHeaderTradeAgreement();
        HeaderTradeDeliveryType headerTradeDeliveryType = supplyChainTradeTransactionType.getApplicableHeaderTradeDelivery();
        HeaderTradeSettlementType headerTradeSettlementType = supplyChainTradeTransactionType.getApplicableHeaderTradeSettlement();
        if (headerTradeAgreementType == null || headerTradeDeliveryType == null || headerTradeSettlementType == null) {
            return null;
        }
        CreditNoteType creditNoteType = new CreditNoteType();
        ExchangedDocumentContextType exchangedDocumentContextType = crossIndustryInvoiceType.getExchangedDocumentContext();
        if (exchangedDocumentContextType != null) {
            if (exchangedDocumentContextType.hasBusinessProcessSpecifiedDocumentContextParameterEntries()) {
                creditNoteType.setProfileID(exchangedDocumentContextType.getBusinessProcessSpecifiedDocumentContextParameterAtIndex(0).getIDValue());
            }
            if (exchangedDocumentContextType.hasGuidelineSpecifiedDocumentContextParameterEntries()) {
                creditNoteType.setCustomizationID(exchangedDocumentContextType.getGuidelineSpecifiedDocumentContextParameterAtIndex(0).getIDValue());
            }
        }
        if (StringHelper.hasText((String)this.getProfileID())) {
            creditNoteType.setProfileID(this.getProfileID());
        }
        if (StringHelper.hasText((String)this.getCustomizationID())) {
            creditNoteType.setCustomizationID(this.getCustomizationID());
        }
        if (exchangedDocumentType != null) {
            creditNoteType.setID(exchangedDocumentType.getIDValue());
        }
        SupplierPartyType supplierPartyType = new SupplierPartyType();
        creditNoteType.setAccountingSupplierParty(supplierPartyType);
        CustomerPartyType customerPartyType = new CustomerPartyType();
        creditNoteType.setAccountingCustomerParty(customerPartyType);
        Object object6 = null;
        if (exchangedDocumentType != null && exchangedDocumentType.getIssueDateTime() != null) {
            object6 = CIIToUBL21Converter.parseDate(exchangedDocumentType.getIssueDateTime().getDateTimeString(), (IErrorList)errorList);
        }
        if (object6 != null) {
            creditNoteType.setIssueDate(object6);
        }
        if (exchangedDocumentType != null) {
            creditNoteType.setCreditNoteTypeCode(exchangedDocumentType.getTypeCodeValue());
        }
        if (exchangedDocumentType != null) {
            for (Object object52 : exchangedDocumentType.getIncludedNote()) {
                CIIToUBL21Converter.ifNotNull(CIIToUBL21Converter._copyNote((NoteType)object52), arg_0 -> ((CreditNoteType)creditNoteType).addNote(arg_0));
            }
        }
        for (Object object52 : headerTradeSettlementType.getApplicableTradeTax()) {
            if (object52.getTaxPointDate() == null || (object42 = CIIToUBL21Converter.parseDate(object52.getTaxPointDate().getDateString(), (IErrorList)errorList)) == null) continue;
            creditNoteType.setTaxPointDate((LocalDate)object42);
            break;
        }
        object6 = headerTradeSettlementType.getInvoiceCurrencyCodeValue();
        creditNoteType.setDocumentCurrencyCode((String)object6);
        if (headerTradeSettlementType.getTaxCurrencyCodeValue() != null) {
            creditNoteType.setTaxCurrencyCode(headerTradeSettlementType.getTaxCurrencyCodeValue());
        }
        for (Object object42 : headerTradeSettlementType.getReceivableSpecifiedTradeAccountingAccount()) {
            object32 = object42.getIDValue();
            if (!StringHelper.hasText((String)object32)) continue;
            creditNoteType.setAccountingCost((String)object32);
            break;
        }
        if (headerTradeAgreementType.getBuyerReferenceValue() != null) {
            creditNoteType.setBuyerReference(headerTradeAgreementType.getBuyerReferenceValue());
        }
        object52 = new PeriodType();
        object42 = headerTradeSettlementType.getBillingSpecifiedPeriod();
        if (object42 != null) {
            object32 = object42.getStartDateTime();
            if (object32 != null) {
                object52.setStartDate(CIIToUBL21Converter.parseDate(object32.getDateTimeString(), (IErrorList)errorList));
            }
            if ((object22 = object42.getEndDateTime()) != null) {
                object52.setEndDate(CIIToUBL21Converter.parseDate(object22.getDateTimeString(), (IErrorList)errorList));
            }
        }
        if (headerTradeSettlementType.hasApplicableTradeTaxEntries() && StringHelper.hasText((String)(object32 = headerTradeSettlementType.getApplicableTradeTaxAtIndex(0)).getDueDateTypeCodeValue())) {
            object52.addDescriptionCode(new DescriptionCodeType(CIIToUBL21Converter.mapDueDateTypeCode(object32.getDueDateTypeCodeValue())));
        }
        if (object52.getStartDate() != null || object52.getEndDate() != null || object52.hasDescriptionCodeEntries()) {
            creditNoteType.addInvoicePeriod((PeriodType)object52);
        }
        object52 = this._createUBLOrderRef(headerTradeAgreementType.getBuyerOrderReferencedDocument(), headerTradeAgreementType.getSellerOrderReferencedDocument());
        creditNoteType.setOrderReference((OrderReferenceType)object52);
        object52 = CIIToUBL21Converter._convertDocumentReference(headerTradeSettlementType.getInvoiceReferencedDocument(), (IErrorList)errorList);
        if (object52 != null) {
            object42 = new BillingReferenceType();
            object42.setCreditNoteDocumentReference((DocumentReferenceType)object52);
            creditNoteType.addBillingReference((BillingReferenceType)object42);
        }
        if ((object52 = CIIToUBL21Converter._convertDocumentReference(headerTradeDeliveryType.getDespatchAdviceReferencedDocument(), (IErrorList)errorList)) != null) {
            creditNoteType.addDespatchDocumentReference((DocumentReferenceType)object52);
        }
        if ((object52 = CIIToUBL21Converter._convertDocumentReference(headerTradeDeliveryType.getReceivingAdviceReferencedDocument(), (IErrorList)errorList)) != null) {
            creditNoteType.addReceiptDocumentReference((DocumentReferenceType)object52);
        }
        for (Object object42 : headerTradeAgreementType.getAdditionalReferencedDocument()) {
            if (!CIIToUBL21Converter.isOriginatorDocumentReferenceTypeCode(object42.getTypeCodeValue()) || (object32 = CIIToUBL21Converter._convertDocumentReference((ReferencedDocumentType)object42, (IErrorList)errorList)) == null) continue;
            object32.setDocumentTypeCode((DocumentTypeCodeType)null);
            creditNoteType.addOriginatorDocumentReference((DocumentReferenceType)object32);
        }
        object52 = CIIToUBL21Converter._convertDocumentReference(headerTradeAgreementType.getContractReferencedDocument(), (IErrorList)errorList);
        if (object52 != null) {
            creditNoteType.addContractDocumentReference((DocumentReferenceType)object52);
        }
        for (Object object42 : headerTradeAgreementType.getAdditionalReferencedDocument()) {
            if (CIIToUBL21Converter.isOriginatorDocumentReferenceTypeCode(object42.getTypeCodeValue()) || (object32 = CIIToUBL21Converter._convertDocumentReference((ReferencedDocumentType)object42, (IErrorList)errorList)) == null) continue;
            creditNoteType.addAdditionalDocumentReference((DocumentReferenceType)object32);
        }
        object52 = headerTradeAgreementType.getSellerTradeParty();
        if (object52 != null) {
            object42 = CIIToUBL21Converter._convertParty((TradePartyType)object52, true, true);
            for (Object object22 : object52.getSpecifiedTaxRegistration()) {
                partyTaxSchemeType = this._convertPartyTaxScheme((TaxRegistrationType)object22);
                if (partyTaxSchemeType == null) continue;
                object42.addPartyTaxScheme(partyTaxSchemeType);
            }
            CIIToUBL21Converter._convertPartyLegalEntity((TradePartyType)object52, (PartyType)object42);
            object32 = CIIToUBL21Converter._convertContact((TradePartyType)object52);
            if (object32 != null) {
                object42.setContact((ContactType)object32);
            }
            supplierPartyType.setParty((PartyType)object42);
        }
        if ((object52 = headerTradeAgreementType.getBuyerTradeParty()) != null) {
            object42 = CIIToUBL21Converter._convertParty((TradePartyType)object52, false, true);
            for (Object object22 : object52.getSpecifiedTaxRegistration()) {
                partyTaxSchemeType = this._convertPartyTaxScheme((TaxRegistrationType)object22);
                if (partyTaxSchemeType == null) continue;
                object42.addPartyTaxScheme(partyTaxSchemeType);
            }
            CIIToUBL21Converter._convertPartyLegalEntity((TradePartyType)object52, (PartyType)object42);
            object32 = CIIToUBL21Converter._convertContact((TradePartyType)object52);
            if (object32 != null) {
                object42.setContact((ContactType)object32);
            }
            customerPartyType.setParty((PartyType)object42);
        }
        if ((object52 = headerTradeSettlementType.getPayeeTradeParty()) != null) {
            object42 = CIIToUBL21Converter._convertParty((TradePartyType)object52, false, false);
            for (Object object22 : object52.getSpecifiedTaxRegistration()) {
                partyTaxSchemeType = this._convertPartyTaxScheme((TaxRegistrationType)object22);
                if (partyTaxSchemeType == null) continue;
                object42.addPartyTaxScheme(partyTaxSchemeType);
            }
            object32 = CIIToUBL21Converter._convertContact((TradePartyType)object52);
            if (object32 != null) {
                object42.setContact((ContactType)object32);
            }
            creditNoteType.setPayeeParty((PartyType)object42);
        }
        if ((object52 = headerTradeAgreementType.getSellerTaxRepresentativeTradeParty()) != null) {
            object42 = CIIToUBL21Converter._convertParty((TradePartyType)object52, false, false);
            for (Object object22 : object52.getSpecifiedTaxRegistration()) {
                partyTaxSchemeType = this._convertPartyTaxScheme((TaxRegistrationType)object22);
                if (partyTaxSchemeType == null) continue;
                object42.addPartyTaxScheme(partyTaxSchemeType);
            }
            object32 = CIIToUBL21Converter._convertContact((TradePartyType)object52);
            if (object32 != null) {
                object42.setContact((ContactType)object32);
            }
            creditNoteType.setTaxRepresentativeParty((PartyType)object42);
        }
        if ((object52 = headerTradeDeliveryType.getShipToTradeParty()) != null) {
            object42 = new DeliveryType();
            object32 = headerTradeDeliveryType.getActualDeliverySupplyChainEvent();
            if (object32 != null && (object22 = object32.getOccurrenceDateTime()) != null) {
                object42.setActualDeliveryDate(CIIToUBL21Converter.parseDate(object22.getDateTimeString(), (IErrorList)errorList));
            }
            object22 = new LocationType();
            boolean bl = false;
            object = CIIToUBL21Converter._extractFirstPartyID((TradePartyType)object52);
            if (object != null) {
                object22.setID((oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType)object);
                bl = true;
            }
            if ((tradeAddressType2 = object52.getPostalTradeAddress()) != null) {
                object22.setAddress(CIIToUBL21Converter._convertPostalAddress(tradeAddressType2));
                bl = true;
            }
            if (bl) {
                object42.setDeliveryLocation((LocationType)object22);
            }
            if ((textType = object52.getName()) != null) {
                partyType = new PartyType();
                partyNameType = new PartyNameType();
                partyNameType.setName(CIIToUBL21Converter.copyName(textType, new NameType()));
                partyType.addPartyName(partyNameType);
                object42.setDeliveryParty(partyType);
            }
            creditNoteType.addDelivery((DeliveryType)object42);
        }
        for (Object object42 : headerTradeSettlementType.getSpecifiedTradeSettlementPaymentMeans()) {
            this._convertPaymentMeans(headerTradeSettlementType, (TradeSettlementPaymentMeansType)object42, iDType -> CIIToUBL21Converter._addPartyID(iDType, creditNoteType.getAccountingSupplierParty().getParty()), arg_0 -> ((CreditNoteType)creditNoteType).addPaymentMeans(arg_0), errorList);
        }
        for (Object object42 : headerTradeSettlementType.getSpecifiedTradePaymentTerms()) {
            object32 = new PaymentTermsType();
            for (TextType textType2 : object42.getDescription()) {
                CIIToUBL21Converter.ifNotNull(CIIToUBL21Converter._copyNote(textType2), arg_0 -> ((PaymentTermsType)object32).addNote(arg_0));
            }
            if (!object32.hasNoteEntries()) continue;
            creditNoteType.addPaymentTerms((PaymentTermsType)object32);
        }
        for (Object object42 : headerTradeSettlementType.getSpecifiedTradeAllowanceCharge()) {
            object32 = ETriState.UNDEFINED;
            if (object42.getChargeIndicator() != null) {
                object32 = CIIToUBL21Converter.parseIndicator(object42.getChargeIndicator(), (IErrorList)errorList);
            } else {
                errorList.add((Object)CIIToUBL21Converter.buildError(new String[]{"CrossIndustryCreditNote", "SupplyChainTradeTransaction", "ApplicableHeaderTradeSettlement", "SpecifiedTradeAllowanceCharge"}, "Failed to determine if SpecifiedTradeAllowanceCharge is an Allowance or a Charge"));
            }
            if (!object32.isDefined()) continue;
            object22 = new AllowanceChargeType();
            object22.setChargeIndicator(object32.getAsBooleanValue());
            this._copyAllowanceCharge((TradeAllowanceChargeType)object42, (AllowanceChargeType)object22, (String)object6);
            creditNoteType.addAllowanceCharge((AllowanceChargeType)object22);
        }
        object52 = headerTradeSettlementType.getSpecifiedTradeSettlementHeaderMonetarySummation();
        object42 = null;
        if (object52 != null && object52.hasTaxTotalAmountEntries()) {
            for (Object object22 : object52.getTaxTotalAmount()) {
                TaxTotalType taxTotalType = new TaxTotalType();
                taxTotalType.setTaxAmount(CIIToUBL21Converter.copyAmount((un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType)object22, new TaxAmountType(), (String)object6));
                creditNoteType.addTaxTotal(taxTotalType);
                if (object42 != null) continue;
                object42 = taxTotalType;
            }
        } else {
            object32 = new TaxAmountType();
            object32.setValue(BigDecimal.ZERO);
            object32.setCurrencyID((String)object6);
            object42 = new TaxTotalType();
            object42.setTaxAmount((TaxAmountType)object32);
            creditNoteType.addTaxTotal((TaxTotalType)object42);
        }
        for (Object object22 : headerTradeSettlementType.getApplicableTradeTax()) {
            TaxSubtotalType taxSubtotalType = new TaxSubtotalType();
            if (object22.hasBasisAmountEntries()) {
                taxSubtotalType.setTaxableAmount(CIIToUBL21Converter.copyAmount(object22.getBasisAmountAtIndex(0), new TaxableAmountType(), (String)object6));
            }
            if (object22.hasCalculatedAmountEntries()) {
                taxSubtotalType.setTaxAmount(CIIToUBL21Converter.copyAmount(object22.getCalculatedAmountAtIndex(0), new TaxAmountType(), (String)object6));
            }
            object = new TaxCategoryType();
            object.setID(object22.getCategoryCodeValue());
            if (object22.getRateApplicablePercentValue() != null) {
                object.setPercent(MathHelper.getWithoutTrailingZeroes((BigDecimal)object22.getRateApplicablePercentValue()));
            }
            if (StringHelper.hasText((String)object22.getExemptionReasonCodeValue())) {
                object.setTaxExemptionReasonCode(object22.getExemptionReasonCodeValue());
            }
            if (object22.getExemptionReason() != null) {
                tradeAddressType2 = new TaxExemptionReasonType();
                tradeAddressType2.setValue(object22.getExemptionReason().getValue());
                tradeAddressType2.setLanguageID(object22.getExemptionReason().getLanguageID());
                tradeAddressType2.setLanguageLocaleID(object22.getExemptionReason().getLanguageLocaleID());
                object.addTaxExemptionReason((TaxExemptionReasonType)tradeAddressType2);
            }
            tradeAddressType2 = new TaxSchemeType();
            tradeAddressType2.setID(this.getVATScheme());
            object.setTaxScheme((TaxSchemeType)tradeAddressType2);
            taxSubtotalType.setTaxCategory((TaxCategoryType)object);
            object42.addTaxSubtotal(taxSubtotalType);
        }
        object42 = new MonetaryTotalType();
        if (object52 != null) {
            if (object52.hasLineTotalAmountEntries()) {
                object42.setLineExtensionAmount(CIIToUBL21Converter.copyAmount(object52.getLineTotalAmountAtIndex(0), new LineExtensionAmountType(), (String)object6));
            }
            if (object52.hasTaxBasisTotalAmountEntries()) {
                object42.setTaxExclusiveAmount(CIIToUBL21Converter.copyAmount(object52.getTaxBasisTotalAmountAtIndex(0), new TaxExclusiveAmountType(), (String)object6));
            }
            if (object52.hasGrandTotalAmountEntries()) {
                object42.setTaxInclusiveAmount(CIIToUBL21Converter.copyAmount(object52.getGrandTotalAmountAtIndex(0), new TaxInclusiveAmountType(), (String)object6));
            }
            if (object52.hasAllowanceTotalAmountEntries()) {
                object42.setAllowanceTotalAmount(CIIToUBL21Converter.copyAmount(object52.getAllowanceTotalAmountAtIndex(0), new AllowanceTotalAmountType(), (String)object6));
            }
            if (object52.hasChargeTotalAmountEntries()) {
                object42.setChargeTotalAmount(CIIToUBL21Converter.copyAmount(object52.getChargeTotalAmountAtIndex(0), new ChargeTotalAmountType(), (String)object6));
            }
            if (object52.hasTotalPrepaidAmountEntries()) {
                object42.setPrepaidAmount(CIIToUBL21Converter.copyAmount(object52.getTotalPrepaidAmountAtIndex(0), new PrepaidAmountType(), (String)object6));
            }
            if (object52.hasRoundingAmountEntries() && MathHelper.isNE0((BigDecimal)object52.getRoundingAmountAtIndex(0).getValue())) {
                object42.setPayableRoundingAmount(CIIToUBL21Converter.copyAmount(object52.getRoundingAmountAtIndex(0), new PayableRoundingAmountType(), (String)object6));
            }
            if (object52.hasDuePayableAmountEntries()) {
                object42.setPayableAmount(CIIToUBL21Converter.copyAmount(object52.getDuePayableAmountAtIndex(0), new PayableAmountType(), (String)object6));
            }
        }
        creditNoteType.setLegalMonetaryTotal((MonetaryTotalType)object42);
        for (Object object32 : supplyChainTradeTransactionType.getIncludedSupplyChainTradeLineItem()) {
            Object object7;
            TradeCountryType tradeCountryType;
            Object object8;
            TaxCategoryType taxCategoryType;
            IDType iDType22;
            Object object9;
            DateTimeType dateTimeType2;
            Object object10;
            LineTradeAgreementType lineTradeAgreementType;
            object22 = new CreditNoteLineType();
            DocumentLineDocumentType documentLineDocumentType = object32.getAssociatedDocumentLineDocument();
            object22.setID(CIIToUBL21Converter._copyID(documentLineDocumentType.getLineID()));
            for (TradeAddressType tradeAddressType2 : documentLineDocumentType.getIncludedNote()) {
                CIIToUBL21Converter.ifNotNull(CIIToUBL21Converter._copyNote((NoteType)tradeAddressType2), arg_0 -> ((CreditNoteLineType)object22).addNote(arg_0));
            }
            boolean bl = false;
            tradeAddressType2 = object32.getSpecifiedLineTradeSettlement();
            textType = tradeAddressType2.getSpecifiedTradeSettlementLineMonetarySummation();
            if (textType != null && textType.hasLineTotalAmountEntries()) {
                object22.setLineExtensionAmount(CIIToUBL21Converter.copyAmount(textType.getLineTotalAmountAtIndex(0), new LineExtensionAmountType(), (String)object6));
                if (CIIToUBL21Converter.isLT0Strict(object22.getLineExtensionAmountValue())) {
                    bl = true;
                }
            }
            if ((partyType = object32.getSpecifiedLineTradeDelivery()) != null && (partyNameType = partyType.getBilledQuantity()) != null) {
                object22.setCreditedQuantity(CIIToUBL21Converter.copyQuantity((QuantityType)partyNameType, new CreditedQuantityType()));
            }
            if (tradeAddressType2.hasReceivableSpecifiedTradeAccountingAccountEntries()) {
                partyNameType = tradeAddressType2.getReceivableSpecifiedTradeAccountingAccountAtIndex(0);
                object22.setAccountingCost(partyNameType.getIDValue());
            }
            if ((partyNameType = tradeAddressType2.getBillingSpecifiedPeriod()) != null) {
                lineTradeAgreementType = new PeriodType();
                object10 = partyNameType.getStartDateTime();
                if (object10 != null) {
                    lineTradeAgreementType.setStartDate(CIIToUBL21Converter.parseDate(object10.getDateTimeString(), (IErrorList)errorList));
                }
                if ((dateTimeType2 = partyNameType.getEndDateTime()) != null) {
                    lineTradeAgreementType.setEndDate(CIIToUBL21Converter.parseDate(dateTimeType2.getDateTimeString(), (IErrorList)errorList));
                }
                if (lineTradeAgreementType.getStartDate() != null || lineTradeAgreementType.getEndDate() != null) {
                    object22.addInvoicePeriod((PeriodType)lineTradeAgreementType);
                }
            }
            if ((lineTradeAgreementType = object32.getSpecifiedLineTradeAgreement()) != null && (object10 = lineTradeAgreementType.getBuyerOrderReferencedDocument()) != null && StringHelper.hasText((String)object10.getLineIDValue())) {
                dateTimeType2 = new OrderLineReferenceType();
                dateTimeType2.setLineID(CIIToUBL21Converter.copyID(object10.getLineID(), new LineIDType()));
                object22.addOrderLineReference((OrderLineReferenceType)dateTimeType2);
            }
            for (DateTimeType dateTimeType2 : tradeAddressType2.getAdditionalReferencedDocument()) {
                object9 = CIIToUBL21Converter._convertDocumentReference((ReferencedDocumentType)dateTimeType2, (IErrorList)errorList);
                if (object9 == null) continue;
                object22.addDocumentReference((DocumentReferenceType)object9);
            }
            for (DateTimeType dateTimeType2 : tradeAddressType2.getSpecifiedTradeAllowanceCharge()) {
                object9 = ETriState.UNDEFINED;
                if (dateTimeType2.getChargeIndicator() != null) {
                    object9 = CIIToUBL21Converter.parseIndicator(dateTimeType2.getChargeIndicator(), (IErrorList)errorList);
                } else {
                    errorList.add((Object)CIIToUBL21Converter.buildError(new String[]{"CrossIndustryCreditNote", "SupplyChainTradeTransaction", "IncludedSupplyChainTradeLineItem", "SpecifiedLineTradeSettlement", "SpecifiedTradeAllowanceCharge"}, "Failed to determine if SpecifiedTradeAllowanceCharge is an Allowance or a Charge"));
                }
                if (!object9.isDefined()) continue;
                iDType22 = new AllowanceChargeType();
                iDType22.setChargeIndicator(object9.getAsBooleanValue());
                this._copyAllowanceCharge((TradeAllowanceChargeType)dateTimeType2, (AllowanceChargeType)iDType22, (String)object6);
                object22.addAllowanceCharge((AllowanceChargeType)iDType22);
            }
            object10 = new ItemType();
            dateTimeType2 = object32.getSpecifiedTradeProduct();
            if (dateTimeType2 != null) {
                object9 = dateTimeType2.getDescription();
                if (object9 != null) {
                    CIIToUBL21Converter.ifNotNull(CIIToUBL21Converter.copyName((TextType)object9, new DescriptionType()), arg_0 -> ((ItemType)object10).addDescription(arg_0));
                }
                if (dateTimeType2.hasNameEntries()) {
                    object10.setName(CIIToUBL21Converter.copyName(dateTimeType2.getNameAtIndex(0), new NameType()));
                }
                if ((iDType22 = dateTimeType2.getBuyerAssignedID()) != null) {
                    taxCategoryType = new ItemIdentificationType();
                    taxCategoryType.setID(CIIToUBL21Converter._copyID(iDType22));
                    if (StringHelper.hasText((String)taxCategoryType.getIDValue())) {
                        object10.setBuyersItemIdentification((ItemIdentificationType)taxCategoryType);
                    }
                }
                if ((taxCategoryType = dateTimeType2.getSellerAssignedID()) != null) {
                    object8 = new ItemIdentificationType();
                    object8.setID(CIIToUBL21Converter._copyID((IDType)taxCategoryType));
                    if (StringHelper.hasText((String)object8.getIDValue())) {
                        object10.setSellersItemIdentification((ItemIdentificationType)object8);
                    }
                }
                if ((object8 = dateTimeType2.getGlobalID()) != null) {
                    tradeCountryType = new ItemIdentificationType();
                    tradeCountryType.setID(CIIToUBL21Converter._copyID((IDType)object8));
                    if (StringHelper.hasText((String)tradeCountryType.getIDValue())) {
                        object10.setStandardItemIdentification((ItemIdentificationType)tradeCountryType);
                    }
                }
                if ((tradeCountryType = dateTimeType2.getOriginTradeCountry()) != null) {
                    object7 = new CountryType();
                    object7.setIdentificationCode(tradeCountryType.getIDValue());
                    if (tradeCountryType.hasNameEntries()) {
                        object7.setName(CIIToUBL21Converter.copyName(tradeCountryType.getNameAtIndex(0), new NameType()));
                    }
                    object10.setOriginCountry((CountryType)object7);
                }
                for (ProductClassificationType productClassificationType : dateTimeType2.getDesignatedProductClassification()) {
                    CodeType codeType = productClassificationType.getClassCode();
                    if (codeType == null) continue;
                    CommodityClassificationType commodityClassificationType = new CommodityClassificationType();
                    commodityClassificationType.setItemClassificationCode(CIIToUBL21Converter.copyCode(codeType, new ItemClassificationCodeType()));
                    if (commodityClassificationType.getItemClassificationCode() == null) continue;
                    object10.addCommodityClassification(commodityClassificationType);
                }
            }
            for (IDType iDType22 : tradeAddressType2.getApplicableTradeTax()) {
                taxCategoryType = new TaxCategoryType();
                taxCategoryType.setID(iDType22.getCategoryCodeValue());
                if (iDType22.getRateApplicablePercentValue() != null) {
                    taxCategoryType.setPercent(MathHelper.getWithoutTrailingZeroes((BigDecimal)iDType22.getRateApplicablePercentValue()));
                }
                object8 = new TaxSchemeType();
                object8.setID(this.getVATScheme());
                taxCategoryType.setTaxScheme((TaxSchemeType)object8);
                object10.addClassifiedTaxCategory(taxCategoryType);
            }
            if (dateTimeType2 != null) {
                for (IDType iDType22 : dateTimeType2.getApplicableProductCharacteristic()) {
                    if (!iDType22.hasDescriptionEntries()) continue;
                    taxCategoryType = new ItemPropertyType();
                    taxCategoryType.setName(CIIToUBL21Converter.copyName(iDType22.getDescriptionAtIndex(0), new NameType()));
                    if (iDType22.hasValueEntries()) {
                        taxCategoryType.setValue(iDType22.getValueAtIndex(0).getValue());
                    }
                    if (taxCategoryType.getName() == null) continue;
                    object10.addAdditionalItemProperty((ItemPropertyType)taxCategoryType);
                }
            }
            object9 = new PriceType();
            boolean bl2 = false;
            if (lineTradeAgreementType != null && (taxCategoryType = lineTradeAgreementType.getNetPriceProductTradePrice()) != null) {
                if (taxCategoryType.hasChargeAmountEntries()) {
                    object9.setPriceAmount(CIIToUBL21Converter.copyAmount(taxCategoryType.getChargeAmountAtIndex(0), new PriceAmountType(), (String)object6));
                    bl2 = true;
                }
                if (taxCategoryType.getBasisQuantity() != null) {
                    object9.setBaseQuantity(CIIToUBL21Converter.copyQuantity(taxCategoryType.getBasisQuantity(), new BaseQuantityType()));
                    bl2 = true;
                }
            }
            if (object22.getCreditedQuantityValue() != null) {
                this.swapQuantityAndPriceIfNeeded(bl, object22.getCreditedQuantityValue(), arg_0 -> ((CreditNoteLineType)object22).setCreditedQuantity(arg_0), bl2 ? object9.getPriceAmountValue() : null, bl2 ? arg_0 -> ((PriceType)object9).setPriceAmount(arg_0) : null, (IErrorList)errorList);
            }
            if ((taxCategoryType = lineTradeAgreementType.getGrossPriceProductTradePrice()) != null) {
                object8 = taxCategoryType.getAppliedTradeAllowanceCharge().iterator();
                while (object8.hasNext()) {
                    ProductClassificationType productClassificationType;
                    tradeCountryType = (TradeAllowanceChargeType)object8.next();
                    object7 = ETriState.UNDEFINED;
                    if (tradeCountryType.getChargeIndicator() != null) {
                        object7 = CIIToUBL21Converter.parseIndicator(tradeCountryType.getChargeIndicator(), (IErrorList)errorList);
                    } else {
                        errorList.add((Object)CIIToUBL21Converter.buildError(new String[]{"CrossIndustryCreditNote", "SupplyChainTradeTransaction", "IncludedSupplyChainTradeLineItem", "SpecifiedLineTradeAgreement", "GrossPriceProductTradePrice", "AppliedTradeAllowanceCharge"}, "Failed to determine if AppliedTradeAllowanceCharge is an Allowance or a Charge"));
                    }
                    if (!object7.isDefined()) continue;
                    productClassificationType = new AllowanceChargeType();
                    productClassificationType.setChargeIndicator(object7.getAsBooleanValue());
                    this._copyAllowanceCharge((TradeAllowanceChargeType)tradeCountryType, (AllowanceChargeType)productClassificationType, (String)object6);
                    object9.addAllowanceCharge((AllowanceChargeType)productClassificationType);
                }
            }
            if (bl2) {
                object22.setPrice((PriceType)object9);
            }
            object22.setItem((ItemType)object10);
            creditNoteType.addCreditNoteLine((CreditNoteLineType)object22);
        }
        return creditNoteType;
    }

    @Override
    @Nullable
    public Serializable convertCIItoUBL(@Nonnull CrossIndustryInvoiceType crossIndustryInvoiceType, @Nonnull ErrorList errorList) {
        ValueEnforcer.notNull((Object)crossIndustryInvoiceType, (String)"CIIInvoice");
        ValueEnforcer.notNull((Object)errorList, (String)"ErrorList");
        switch (this.getUBLCreationMode()) {
            case AUTOMATIC: {
                ETriState eTriState = CIIToUBL21Converter.isInvoiceType(crossIndustryInvoiceType, (IErrorList)errorList);
                return eTriState.getAsBooleanValue(true) ? this.convertToInvoice(crossIndustryInvoiceType, errorList) : this.convertToCreditNote(crossIndustryInvoiceType, errorList);
            }
            case INVOICE: {
                return this.convertToInvoice(crossIndustryInvoiceType, errorList);
            }
            case CREDIT_NOTE: {
                return this.convertToCreditNote(crossIndustryInvoiceType, errorList);
            }
        }
        throw new IllegalStateException("Unsupported creation mode");
    }
}

