/*
 * Decompiled with CFR 0.152.
 */
package eu.cen.en16931.xmlvalidator;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.resource.IWritableResource;
import com.helger.schematron.ISchematronResource;
import com.helger.schematron.SchematronHelper;
import com.helger.schematron.pure.SchematronResourcePure;
import com.helger.schematron.sch.SchematronResourceSCH;
import com.helger.schematron.svrl.SVRLHelper;
import com.helger.schematron.svrl.SVRLMarshaller;
import com.helger.schematron.svrl.jaxb.SchematronOutputType;
import com.helger.schematron.xslt.SchematronResourceXSLT;
import com.helger.xml.schema.XMLSchemaCache;
import com.helger.xml.transform.TransformSourceFactory;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class XMLValidator {
    private static final Logger s_aLogger = LoggerFactory.getLogger(XMLValidator.class);

    public static void main(String[] stringArray) {
        File file;
        String string;
        String string2;
        File file2 = null;
        EMode eMode = null;
        File file3 = null;
        File file4 = null;
        if (stringArray.length >= 2) {
            string2 = stringArray[0];
            string = stringArray[1];
            if (string2.equals("-xml")) {
                file = new File(string);
                if (file.exists() && file.isFile()) {
                    file2 = file;
                } else {
                    s_aLogger.error("The xml instance file '" + string + "' does not exist.");
                }
            } else {
                s_aLogger.error("Invalidate file type '" + string2 + "' provided (try '-xml').");
            }
        }
        if (stringArray.length >= 4) {
            string2 = stringArray[2];
            string = stringArray[3];
            if (string2.equals("-xsd")) {
                eMode = EMode.XSD;
            } else if (string2.equals("-sch")) {
                eMode = EMode.SCH;
            } else if (string2.equals("-xslt")) {
                eMode = EMode.XSLT;
            } else if (string2.equals("-pure")) {
                eMode = EMode.PURE;
            }
            if (eMode != null) {
                file = new File(string);
                if (file.exists() && file.isFile()) {
                    file3 = file;
                } else {
                    s_aLogger.error("The " + eMode.getDisplayName() + " file '" + string + "' does not exist.");
                }
            } else {
                s_aLogger.error("Invalid validation mode '" + string2 + "' provided.");
            }
        }
        if (stringArray.length >= 6) {
            string2 = stringArray[4];
            string = stringArray[5];
            if (string2.equals("-svrl") && eMode != null && eMode.isSchematronBased()) {
                file = new File(string);
                if (!file.exists() || file.isFile()) {
                    file4 = file;
                } else {
                    s_aLogger.error("The SVRL file '" + string + "' does not exist.");
                }
            } else {
                s_aLogger.error("Invalid optional type '" + string2 + "' provided.");
            }
        }
        if (file2 == null || eMode == null || file3 == null) {
            s_aLogger.info("Required commandline parameter is missing!");
            s_aLogger.info("Usage:");
            s_aLogger.info("  java -jar en16931-xml-validator-x.y.z-jar-with-dependencies.jar -xml file [-xsd|-sch|-xslt|-pure] file [-svrl file]");
            s_aLogger.info("With the following allowed options:");
            s_aLogger.info("   -xml filename");
            s_aLogger.info("       The XML file to be validated. This parameter is mandatory");
            s_aLogger.info("   -xsd filename");
            s_aLogger.info("       The XML schema (XSD) file used for validation");
            s_aLogger.info("   -sch filename");
            s_aLogger.info("       The Schematron file used for validation (using XSLT based validation)");
            s_aLogger.info("   -xslt filename");
            s_aLogger.info("       The precompiled Schematron XSLT file used for validation");
            s_aLogger.info("   -pure filename");
            s_aLogger.info("       The Schematron file used for validation (using Pure XPath-only validation)");
            s_aLogger.info("   -svrl filename");
            s_aLogger.info("       The SVRL file which should be written (only for Schematron validation)");
            return;
        }
        s_aLogger.info("=========================================");
        if (eMode == EMode.XSD) {
            s_aLogger.info("Starting validation against XML Schema");
            s_aLogger.info("Result: " + XMLValidator.validateXMLSchema(file3, file2));
        } else {
            s_aLogger.info("Starting validation against Schematron");
            s_aLogger.info("Result: " + XMLValidator.validateXMLSchematron(file3, eMode, file2, file4));
        }
        s_aLogger.info("Finished.");
        s_aLogger.info("=========================================");
    }

    public static boolean validateXMLSchema(@Nonnull File file, @Nonnull File file2) {
        try {
            System.setProperty("jdk.xml.maxOccurLimit", "9999999");
            Validator validator = XMLSchemaCache.getInstance().getValidator((IReadableResource)new FileSystemResource(file));
            validator.validate(TransformSourceFactory.create((File)file2));
        }
        catch (IOException | SAXException exception) {
            s_aLogger.info("Exception: " + exception.getMessage());
            return false;
        }
        return true;
    }

    public static boolean validateXMLSchematron(@Nonnull File file, @Nonnull EMode eMode, @Nonnull File file2, @Nullable File file3) {
        ICommonsList iCommonsList;
        FileSystemResource fileSystemResource = new FileSystemResource(file2);
        FileSystemResource fileSystemResource2 = new FileSystemResource(file);
        Object object = eMode == EMode.PURE ? new SchematronResourcePure((IReadableResource)fileSystemResource2) : (eMode == EMode.XSLT ? new SchematronResourceXSLT((IReadableResource)fileSystemResource2) : new SchematronResourceSCH((IReadableResource)fileSystemResource2));
        SchematronOutputType schematronOutputType = SchematronHelper.applySchematron((ISchematronResource)object, (IReadableResource)fileSystemResource);
        if (schematronOutputType == null) {
            s_aLogger.info("Schematron file " + object + " is malformed!");
            return false;
        }
        if (file3 != null) {
            new SVRLMarshaller(false).write((Object)schematronOutputType, (IWritableResource)new FileSystemResource(file3));
        }
        if ((iCommonsList = SVRLHelper.getAllFailedAssertions((SchematronOutputType)schematronOutputType)).isNotEmpty()) {
            s_aLogger.info("XML does not comply to Schematron!" + (file3 != null ? " See SVRL for details: " + file3 : ""));
            return false;
        }
        s_aLogger.info("XML complies to Schematron!");
        return true;
    }

    private static enum EMode {
        XSD("XML schema"),
        PURE("Pure Schematron"),
        SCH("Schematron"),
        XSLT("XSLT");

        private final String m_sName;

        private EMode(String string2) {
            this.m_sName = string2;
        }

        @Nonnull
        @Nonempty
        public String getDisplayName() {
            return this.m_sName;
        }

        public boolean isSchematronBased() {
            return this == SCH || this == XSLT || this == PURE;
        }
    }
}

