/*
 * Decompiled with CFR 0.152.
 */
package com.helger.font.api;

import com.helger.commons.lang.EnumHelper;
import com.helger.font.api.IFontWeight;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;

public enum EFontWeight implements IFontWeight
{
    HAIRLINE(90),
    THIN(100),
    EXTRA_LIGHT(200),
    LIGHT(300),
    REGULAR(400),
    MEDIUM(500),
    SEMI_BOLD(600),
    BOLD(700),
    EXTRA_BOLD(800),
    BLACK(900);

    private final int m_nWeight;

    private EFontWeight(int n2) {
        this.m_nWeight = n2;
    }

    @Override
    @Nonnegative
    public int getWeight() {
        return this.m_nWeight;
    }

    @Nullable
    public static EFontWeight getFromWeightOrNull(@Nonnegative int n) {
        return EFontWeight.getFromWeightOrDefault(n, null);
    }

    @Nullable
    public static EFontWeight getFromWeightOrDefault(@Nonnegative int n, @Nullable EFontWeight eFontWeight2) {
        return (EFontWeight)EnumHelper.findFirst(EFontWeight.class, eFontWeight -> eFontWeight.getWeight() == n, (Enum)eFontWeight2);
    }
}

