/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JFormatter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JCase
implements IJStatement {
    private final IJExpression m_aLabelExpr;
    private boolean m_bIsDefaultCase = false;
    private JBlock m_aBody;

    public JCase(@Nonnull IJExpression iJExpression) {
        this(iJExpression, false);
    }

    public JCase(@Nullable IJExpression iJExpression, boolean bl) {
        this.m_aLabelExpr = iJExpression;
        this.m_bIsDefaultCase = bl;
    }

    @Nullable
    public IJExpression label() {
        return this.m_aLabelExpr;
    }

    public boolean isDefaultCase() {
        return this.m_bIsDefaultCase;
    }

    @Nonnull
    public JBlock body() {
        if (this.m_aBody == null) {
            this.m_aBody = new JBlock();
        }
        return this.m_aBody;
    }

    @Override
    public void state(@Nonnull JFormatter jFormatter) {
        jFormatter.indent();
        if (this.m_bIsDefaultCase) {
            jFormatter.print("default:").newline();
        } else {
            jFormatter.print("case ").generable(this.m_aLabelExpr).print(':').newline();
        }
        if (this.m_aBody != null) {
            jFormatter.statement(this.m_aBody);
        }
        jFormatter.outdent();
    }
}

