/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.IJGenerable;
import com.helger.jcodemodel.IJOwned;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JCommentPart;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.JVar;
import com.helger.jcodemodel.util.JCValueEnforcer;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JDocComment
extends JCommentPart
implements IJGenerable,
IJOwned {
    public static final String TAG_AUTHOR = "author";
    public static final String TAG_DEPRECATED = "deprecated";
    public static final String TAG_SEE = "see";
    public static final String TAG_SINCE = "since";
    public static final String TAG_VERSION = "version";
    private static final long serialVersionUID = 1L;
    private final JCodeModel m_aOwner;
    private boolean m_bIsSingleLineMode = false;
    private final Map<String, JCommentPart> m_aAtParams = new LinkedHashMap<String, JCommentPart>();
    private JCommentPart m_aAtReturn;
    private final Map<AbstractJClass, JCommentPart> m_aAtThrows = new LinkedHashMap<AbstractJClass, JCommentPart>();
    private final Map<String, JCommentPart> m_aAtTags = new LinkedHashMap<String, JCommentPart>();
    private final Map<String, Map<String, String>> m_aAtXdoclets = new LinkedHashMap<String, Map<String, String>>();

    protected JDocComment(@Nonnull JCodeModel jCodeModel) {
        this.m_aOwner = JCValueEnforcer.notNull(jCodeModel, "Owner");
    }

    @Override
    @Nonnull
    public JCodeModel owner() {
        return this.m_aOwner;
    }

    @Nonnull
    public JDocComment setSingleLineMode(boolean bl) {
        this.m_bIsSingleLineMode = bl;
        return this;
    }

    public boolean isSingleLineMode() {
        return this.m_bIsSingleLineMode;
    }

    @Override
    public JDocComment append(@Nullable Object object) {
        this.add(object);
        return this;
    }

    @Nonnull
    public JCommentPart addParam(@Nonnull String string) {
        JCommentPart jCommentPart = this.m_aAtParams.get(string);
        if (jCommentPart == null) {
            jCommentPart = new JCommentPart();
            this.m_aAtParams.put(string, jCommentPart);
        }
        return jCommentPart;
    }

    public JCommentPart addParam(@Nonnull JVar jVar) {
        return this.addParam(jVar.name());
    }

    @Nullable
    public JCommentPart removeParam(@Nullable String string) {
        return this.m_aAtParams.remove(string);
    }

    @Nullable
    public JCommentPart removeParam(@Nonnull JVar jVar) {
        return this.removeParam(jVar.name());
    }

    public void removeAllParams() {
        this.m_aAtParams.clear();
    }

    @Nullable
    public JCommentPart getParam(@Nullable String string) {
        return this.m_aAtParams.get(string);
    }

    @Nullable
    public JCommentPart getParam(@Nonnull JVar jVar) {
        return this.getParam(jVar.name());
    }

    @Nonnull
    public JCommentPart addReturn() {
        if (this.m_aAtReturn == null) {
            this.m_aAtReturn = new JCommentPart();
        }
        return this.m_aAtReturn;
    }

    @Nullable
    public JCommentPart getReturn() {
        return this.m_aAtReturn;
    }

    public void removeReturn() {
        this.m_aAtReturn = null;
    }

    public JCommentPart addThrows(@Nonnull Class<? extends Throwable> clazz) {
        return this.addThrows(this.m_aOwner.ref(clazz));
    }

    public JCommentPart addThrows(@Nonnull AbstractJClass abstractJClass) {
        JCommentPart jCommentPart = this.m_aAtThrows.get(abstractJClass);
        if (jCommentPart == null) {
            jCommentPart = new JCommentPart();
            this.m_aAtThrows.put(abstractJClass, jCommentPart);
        }
        return jCommentPart;
    }

    @Nullable
    public JCommentPart removeThrows(@Nonnull Class<? extends Throwable> clazz) {
        return this.removeThrows(this.m_aOwner.ref(clazz));
    }

    @Nullable
    public JCommentPart removeThrows(@Nullable AbstractJClass abstractJClass) {
        return this.m_aAtThrows.remove(abstractJClass);
    }

    public void removeAllThrows() {
        this.m_aAtThrows.clear();
    }

    @Nullable
    public JCommentPart getThrows(@Nonnull Class<? extends Throwable> clazz) {
        return this.getThrows(this.m_aOwner.ref(clazz));
    }

    @Nullable
    public JCommentPart getThrows(@Nullable AbstractJClass abstractJClass) {
        return this.m_aAtThrows.get(abstractJClass);
    }

    @Nonnull
    public JCommentPart addTag(@Nonnull String string) {
        JCValueEnforcer.notEmpty(string, "Name");
        JCommentPart jCommentPart = this.m_aAtTags.get(string);
        if (jCommentPart == null) {
            jCommentPart = new JCommentPart();
            this.m_aAtTags.put(string, jCommentPart);
        }
        return jCommentPart;
    }

    @Nullable
    public JCommentPart removeTag(@Nullable String string) {
        return this.m_aAtTags.remove(string);
    }

    @Nullable
    public JCommentPart getTag(@Nullable String string) {
        return this.m_aAtTags.get(string);
    }

    @Nonnull
    public JCommentPart addAuthor() {
        return this.addTag(TAG_AUTHOR);
    }

    public void removeAuthor() {
        this.removeTag(TAG_AUTHOR);
    }

    @Nonnull
    public JCommentPart addDeprecated() {
        return this.addTag(TAG_DEPRECATED);
    }

    public void removeDeprecated() {
        this.removeTag(TAG_DEPRECATED);
    }

    @Nonnull
    public Map<String, String> addXdoclet(@Nonnull String string) {
        Map<String, String> map = this.m_aAtXdoclets.get(string);
        if (map == null) {
            map = new LinkedHashMap<String, String>();
            this.m_aAtXdoclets.put(string, map);
        }
        return map;
    }

    @Nonnull
    public Map<String, String> addXdoclet(@Nonnull String string, @Nonnull Map<String, String> map) {
        Map<String, String> map2 = this.addXdoclet(string);
        map2.putAll(map);
        return map2;
    }

    @Nonnull
    public Map<String, String> addXdoclet(@Nonnull String string, @Nonnull String string2, @Nullable String string3) {
        Map<String, String> map = this.addXdoclet(string);
        map.put(string2, string3);
        return map;
    }

    @Nullable
    public Map<String, String> removeXdoclet(@Nullable String string) {
        return this.m_aAtXdoclets.remove(string);
    }

    public void removeAllXdoclets() {
        this.m_aAtXdoclets.clear();
    }

    @Override
    public void generate(@Nonnull JFormatter jFormatter) {
        boolean bl;
        boolean bl2 = bl = !this.m_aAtParams.isEmpty() || this.m_aAtReturn != null || !this.m_aAtThrows.isEmpty() || !this.m_aAtTags.isEmpty() || !this.m_aAtXdoclets.isEmpty();
        if (!this.isEmpty() || bl) {
            String string = this.m_bIsSingleLineMode ? "// " : " * ";
            String string2 = string + "    ";
            if (!this.m_bIsSingleLineMode) {
                jFormatter.print("/**").newline();
            }
            this.format(jFormatter, string);
            if (!this.isEmpty() && bl) {
                jFormatter.print(string).newline();
            }
            for (Map.Entry<String, JCommentPart> entry : this.m_aAtParams.entrySet()) {
                jFormatter.print(string + "@param ").print(entry.getKey()).newline();
                entry.getValue().format(jFormatter, string2);
            }
            if (this.m_aAtReturn != null) {
                jFormatter.print(string + "@return").newline();
                this.m_aAtReturn.format(jFormatter, string2);
            }
            for (Map.Entry<Object, JCommentPart> entry : this.m_aAtThrows.entrySet()) {
                jFormatter.print(string + "@throws ").type((AbstractJClass)entry.getKey()).newline();
                entry.getValue().format(jFormatter, string2);
            }
            for (Map.Entry<Object, JCommentPart> entry : this.m_aAtTags.entrySet()) {
                jFormatter.print(string + "@" + (String)entry.getKey() + " ");
                entry.getValue().format(jFormatter, "");
            }
            for (Map.Entry<Object, Object> entry : this.m_aAtXdoclets.entrySet()) {
                jFormatter.print(string + "@").print((String)entry.getKey());
                if (entry.getValue() != null) {
                    for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                        String string3 = (String)entry2.getKey();
                        jFormatter.print(" ").print(string3);
                        String string4 = (String)entry2.getValue();
                        if (string4 == null || string4.length() <= 0) continue;
                        jFormatter.print("= \"").print(string4).print("\"");
                    }
                }
                jFormatter.newline();
            }
            if (!this.m_bIsSingleLineMode) {
                jFormatter.print(" */").newline();
            }
        }
    }
}

