/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.IJGenerable;
import com.helger.jcodemodel.JFormatter;
import java.io.StringWriter;
import javax.annotation.Nonnull;

public class JMods
implements IJGenerable {
    private static final int VAR = 8;
    private static final int FIELD = 799;
    private static final int METHOD = 1279;
    private static final int CLASS = 63;
    private static final int INTERFACE = 7;
    private int m_nMods;

    protected JMods(int n) {
        this.m_nMods = n;
    }

    public int getValue() {
        return this.m_nMods;
    }

    private static void _check(int n, int n2, String string) {
        if ((n & ~n2) != 0) {
            throw new IllegalArgumentException("Illegal modifiers for " + string + ": " + new JMods(n).toString());
        }
    }

    @Nonnull
    public static JMods forVar(int n) {
        JMods._check(n, 8, "variable");
        return new JMods(n);
    }

    @Nonnull
    public static JMods forField(int n) {
        JMods._check(n, 799, "field");
        return new JMods(n);
    }

    @Nonnull
    public static JMods forMethod(int n) {
        JMods._check(n, 1279, "method");
        return new JMods(n);
    }

    @Nonnull
    public static JMods forClass(int n) {
        JMods._check(n, 63, "class");
        return new JMods(n);
    }

    @Nonnull
    public static JMods forInterface(int n) {
        JMods._check(n, 7, "interface");
        return new JMods(n);
    }

    public boolean isAbstract() {
        return (this.m_nMods & 0x20) != 0;
    }

    public boolean isNative() {
        return (this.m_nMods & 0x40) != 0;
    }

    public boolean isStatic() {
        return (this.m_nMods & 0x10) != 0;
    }

    public boolean isSynchronized() {
        return (this.m_nMods & 0x80) != 0;
    }

    public void setSynchronized(boolean bl) {
        this._setFlag(128, bl);
    }

    public boolean isStrictFP() {
        return (this.m_nMods & 0x800) != 0;
    }

    public void setStrictFP(boolean bl) {
        this._setFlag(2048, bl);
    }

    public boolean isDefault() {
        return (this.m_nMods & 0x400) != 0;
    }

    public void setDefault(boolean bl) {
        this._setFlag(1024, bl);
    }

    public void setPrivate() {
        this._setFlag(1, false);
        this._setFlag(2, false);
        this._setFlag(4, true);
    }

    public void setPackagePrivate() {
        this._setFlag(1, false);
        this._setFlag(2, false);
        this._setFlag(4, false);
    }

    public void setProtected() {
        this._setFlag(1, false);
        this._setFlag(2, true);
        this._setFlag(4, false);
    }

    public void setPublic() {
        this._setFlag(1, true);
        this._setFlag(2, false);
        this._setFlag(4, false);
    }

    public void setFinal(boolean bl) {
        this._setFlag(8, bl);
    }

    private void _setFlag(int n, boolean bl) {
        this.m_nMods = this.m_nMods & ~n | (bl ? n : 0);
    }

    @Override
    public void generate(@Nonnull JFormatter jFormatter) {
        if ((this.m_nMods & 1) != 0) {
            jFormatter.print("public");
        }
        if ((this.m_nMods & 2) != 0) {
            jFormatter.print("protected");
        }
        if ((this.m_nMods & 4) != 0) {
            jFormatter.print("private");
        }
        if ((this.m_nMods & 8) != 0) {
            jFormatter.print("final");
        }
        if ((this.m_nMods & 0x10) != 0) {
            jFormatter.print("static");
        }
        if ((this.m_nMods & 0x20) != 0) {
            jFormatter.print("abstract");
        }
        if ((this.m_nMods & 0x40) != 0) {
            jFormatter.print("native");
        }
        if ((this.m_nMods & 0x80) != 0) {
            jFormatter.print("synchronized");
        }
        if ((this.m_nMods & 0x100) != 0) {
            jFormatter.print("transient");
        }
        if ((this.m_nMods & 0x200) != 0) {
            jFormatter.print("volatile");
        }
        if ((this.m_nMods & 0x400) != 0) {
            jFormatter.print("default");
        }
        if ((this.m_nMods & 0x800) != 0) {
            jFormatter.print("strictfp");
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        JFormatter jFormatter = new JFormatter(stringWriter);
        this.generate(jFormatter);
        return stringWriter.toString();
    }
}

