/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.fmt;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJResourceFile;
import com.helger.jcodemodel.JPackage;
import com.helger.jcodemodel.JTypeVar;
import com.helger.jcodemodel.util.JCSecureLoader;
import com.helger.jcodemodel.util.JCValueEnforcer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.text.ParseException;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JStaticJavaFile
extends AbstractJResourceFile {
    private final JPackage m_aPkg;
    private final String m_sClassName;
    private final URL m_aSource;
    private final JStaticClass m_aClazz;
    private final ILineFilter m_aFilter;

    public JStaticJavaFile(@Nonnull JPackage jPackage, @Nonnull String string, @Nonnull String string2) {
        this(jPackage, string, JCSecureLoader.getClassClassLoader(JStaticJavaFile.class).getResource(string2), null);
    }

    public JStaticJavaFile(@Nonnull JPackage jPackage, @Nonnull String string, @Nonnull URL uRL, @Nullable ILineFilter iLineFilter) {
        super(string + ".java");
        this.m_aPkg = JCValueEnforcer.notNull(jPackage, "Package");
        this.m_aClazz = new JStaticClass();
        this.m_sClassName = JCValueEnforcer.notEmpty(string, "ClassName");
        this.m_aSource = JCValueEnforcer.notNull(uRL, "Source");
        this.m_aFilter = iLineFilter;
    }

    @Nonnull
    public final AbstractJClass getJClass() {
        return this.m_aClazz;
    }

    @Override
    protected boolean isResource() {
        return false;
    }

    @Override
    protected void build(@Nonnull OutputStream outputStream) throws IOException {
        InputStream inputStream = this.m_aSource.openStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream)));
        ILineFilter iLineFilter = this._createLineFilter();
        int n = 1;
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = iLineFilter.process(string)) != null) {
                    printWriter.println(string);
                }
                ++n;
            }
        }
        catch (ParseException parseException) {
            throw new IOException("unable to process " + this.m_aSource + " line:" + n + "\n" + parseException.getMessage());
        }
        printWriter.close();
        bufferedReader.close();
    }

    @Nonnull
    private ILineFilter _createLineFilter() {
        ILineFilter iLineFilter = new ILineFilter(){

            @Override
            @Nullable
            public String process(@Nonnull String string) {
                if (string.startsWith("package ")) {
                    if (JStaticJavaFile.this.m_aPkg.isUnnamed()) {
                        return null;
                    }
                    return "package " + JStaticJavaFile.this.m_aPkg.name() + ";";
                }
                return string;
            }
        };
        if (this.m_aFilter != null) {
            return new ChainFilter(this.m_aFilter, iLineFilter);
        }
        return iLineFilter;
    }

    private class JStaticClass
    extends AbstractJClass {
        private final JTypeVar[] typeParams;

        JStaticClass() {
            super(JStaticJavaFile.this.m_aPkg.owner());
            this.typeParams = new JTypeVar[0];
        }

        @Override
        public String name() {
            return JStaticJavaFile.this.m_sClassName;
        }

        @Override
        @Nonnull
        public String fullName() {
            if (JStaticJavaFile.this.m_aPkg.isUnnamed()) {
                return JStaticJavaFile.this.m_sClassName;
            }
            return JStaticJavaFile.this.m_aPkg.name() + '.' + JStaticJavaFile.this.m_sClassName;
        }

        @Override
        @Nonnull
        public JPackage _package() {
            return JStaticJavaFile.this.m_aPkg;
        }

        @Override
        public AbstractJClass _extends() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<AbstractJClass> _implements() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInterface() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isAbstract() {
            throw new UnsupportedOperationException();
        }

        @Override
        public JTypeVar[] typeParams() {
            return this.typeParams;
        }

        @Override
        protected AbstractJClass substituteParams(JTypeVar[] jTypeVarArray, List<? extends AbstractJClass> list) {
            return this;
        }
    }

    public static final class ChainFilter
    implements ILineFilter {
        private final ILineFilter m_aFirst;
        private final ILineFilter m_aSecond;

        public ChainFilter(@Nonnull ILineFilter iLineFilter, @Nonnull ILineFilter iLineFilter2) {
            this.m_aFirst = iLineFilter;
            this.m_aSecond = iLineFilter2;
        }

        @Override
        @Nullable
        public String process(@Nonnull String string) throws ParseException {
            String string2 = this.m_aFirst.process(string);
            if (string2 == null) {
                return null;
            }
            return this.m_aSecond.process(string2);
        }
    }

    public static interface ILineFilter {
        @Nullable
        public String process(@Nonnull String var1) throws ParseException;
    }
}

