/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.writer;

import com.helger.jcodemodel.AbstractCodeWriter;
import com.helger.jcodemodel.JPackage;
import com.helger.jcodemodel.SourcePrintWriter;
import com.helger.jcodemodel.writer.FilterCodeWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.annotation.Nonnull;

public class ProgressCodeWriter
extends FilterCodeWriter {
    private final PrintStream m_aPS;

    public ProgressCodeWriter(@Nonnull AbstractCodeWriter abstractCodeWriter, @Nonnull PrintStream printStream) {
        super(abstractCodeWriter);
        if (printStream == null) {
            throw new IllegalArgumentException();
        }
        this.m_aPS = printStream;
    }

    @Override
    public OutputStream openBinary(@Nonnull JPackage jPackage, @Nonnull String string) throws IOException {
        this._report(jPackage, string);
        return super.openBinary(jPackage, string);
    }

    @Override
    public SourcePrintWriter openSource(@Nonnull JPackage jPackage, @Nonnull String string) throws IOException {
        this._report(jPackage, string);
        return super.openSource(jPackage, string);
    }

    private void _report(@Nonnull JPackage jPackage, @Nonnull String string) {
        if (jPackage.isUnnamed()) {
            this.m_aPS.println(string);
        } else {
            this.m_aPS.println(jPackage.name().replace('.', File.separatorChar) + File.separatorChar + string);
        }
    }
}

