/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJExpressionImpl;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.util.JCEqualsHelper;
import com.helger.jcodemodel.util.JCHashCodeGenerator;
import javax.annotation.Nonnull;

public class JAtomDouble
extends AbstractJExpressionImpl {
    public static final String JAVA_LANG_DOUBLE_NEGATIVE_INFINITY = "java.lang.Double.NEGATIVE_INFINITY";
    public static final String JAVA_LANG_DOUBLE_POSITIVE_INFINITY = "java.lang.Double.POSITIVE_INFINITY";
    public static final String JAVA_LANG_DOUBLE_NAN = "java.lang.Double.NaN";
    private final double _what;

    protected JAtomDouble(double d) {
        this._what = d;
    }

    public double what() {
        return this._what;
    }

    @Override
    public void generate(@Nonnull JFormatter jFormatter) {
        if (this._what == Double.NEGATIVE_INFINITY) {
            jFormatter.print(JAVA_LANG_DOUBLE_NEGATIVE_INFINITY);
        } else if (this._what == Double.POSITIVE_INFINITY) {
            jFormatter.print(JAVA_LANG_DOUBLE_POSITIVE_INFINITY);
        } else if (Double.isNaN(this._what)) {
            jFormatter.print(JAVA_LANG_DOUBLE_NAN);
        } else {
            jFormatter.print(Double.toString(this._what));
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JAtomDouble jAtomDouble = (JAtomDouble)object;
        return JCEqualsHelper.isEqual(this._what, jAtomDouble._what);
    }

    public int hashCode() {
        return JCHashCodeGenerator.getHashCode(this, this._what);
    }
}

