/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.JPackage;
import com.helger.jcodemodel.SourcePrintWriter;
import com.helger.jcodemodel.util.JCValueEnforcer;
import com.helger.jcodemodel.util.UnicodeEscapeWriter;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.BitSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractCodeWriter
implements Closeable {
    private final Charset m_aEncoding;
    private final String m_sNewLine;

    @Nonnull
    protected static String getDefaultNewLine() {
        String string = null;
        try {
            string = System.getProperty("line.separator");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null || string.length() == 0) {
            string = "\n";
        }
        return string;
    }

    protected AbstractCodeWriter(@Nullable Charset charset, @Nonnull String string) {
        JCValueEnforcer.notNull(string, "NewLine");
        this.m_aEncoding = charset;
        this.m_sNewLine = string;
    }

    @Nullable
    public Charset encoding() {
        return this.m_aEncoding;
    }

    @Nonnull
    public String getNewLine() {
        return this.m_sNewLine;
    }

    @Nonnull
    public abstract OutputStream openBinary(@Nonnull JPackage var1, @Nonnull String var2) throws IOException;

    @Nonnull
    public SourcePrintWriter openSource(@Nonnull JPackage jPackage, @Nonnull String string) throws IOException {
        UnicodeEscapeWriter unicodeEscapeWriter;
        OutputStream outputStream = this.openBinary(jPackage, string);
        OutputStreamWriter outputStreamWriter = this.m_aEncoding != null ? new OutputStreamWriter(outputStream, this.m_aEncoding) : new OutputStreamWriter(outputStream);
        try {
            unicodeEscapeWriter = new JavaUnicodeEscapeWriter(outputStreamWriter);
        }
        catch (Throwable throwable) {
            unicodeEscapeWriter = new UnicodeEscapeWriter(outputStreamWriter);
        }
        return new SourcePrintWriter(new BufferedWriter(unicodeEscapeWriter), this.m_sNewLine);
    }

    @Override
    public abstract void close() throws IOException;

    private static final class JavaUnicodeEscapeWriter
    extends UnicodeEscapeWriter {
        private static final BitSet ESCAPE = new BitSet(128);
        private final CharsetEncoder m_aEncoder;

        private JavaUnicodeEscapeWriter(@Nonnull OutputStreamWriter outputStreamWriter) {
            super(outputStreamWriter);
            this.m_aEncoder = Charset.forName(outputStreamWriter.getEncoding()).newEncoder();
        }

        @Override
        protected boolean requireEscaping(int n) {
            if (ESCAPE.get(n)) {
                return true;
            }
            if (n < 128) {
                return false;
            }
            return !this.m_aEncoder.canEncode((char)n);
        }

        static {
            for (int i = 0; i < 32; ++i) {
                if (i == 9 || i == 13 || i == 10) continue;
                ESCAPE.set(i, true);
            }
        }
    }
}

