/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJDeclaration;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJGenerable;
import com.helger.jcodemodel.IJObject;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBreak;
import com.helger.jcodemodel.JConditional;
import com.helger.jcodemodel.JContinue;
import com.helger.jcodemodel.JDirectStatement;
import com.helger.jcodemodel.JDoLoop;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JForEach;
import com.helger.jcodemodel.JForLoop;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JLabel;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JMods;
import com.helger.jcodemodel.JReturn;
import com.helger.jcodemodel.JSingleLineCommentStatement;
import com.helger.jcodemodel.JSwitch;
import com.helger.jcodemodel.JSynchronizedBlock;
import com.helger.jcodemodel.JThrow;
import com.helger.jcodemodel.JTryBlock;
import com.helger.jcodemodel.JVar;
import com.helger.jcodemodel.JWhileLoop;
import com.helger.jcodemodel.util.JCValueEnforcer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JBlock
implements IJGenerable,
IJStatement {
    public static final boolean DEFAULT_VIRTUAL_BLOCK = false;
    public static final boolean DEFAULT_BRACES_REQUIRED = true;
    public static final boolean DEFAULT_INDENT_REQUIRED = true;
    protected final List<IJObject> m_aContentList = new ArrayList<IJObject>();
    private boolean m_bVirtualBlock = false;
    private boolean m_bBracesRequired = true;
    private boolean m_bIndentRequired = true;
    private int m_nPos;

    public boolean virtual() {
        return this.m_bVirtualBlock;
    }

    @Nonnull
    public JBlock virtual(boolean bl) {
        this.m_bVirtualBlock = bl;
        return this;
    }

    public boolean bracesRequired() {
        return this.m_bBracesRequired;
    }

    @Nonnull
    public JBlock bracesRequired(boolean bl) {
        this.m_bBracesRequired = bl;
        return this;
    }

    public boolean indentRequired() {
        return this.m_bIndentRequired;
    }

    @Nonnull
    public JBlock indentRequired(boolean bl) {
        this.m_bIndentRequired = bl;
        return this;
    }

    @Nonnull
    public List<IJObject> getContents() {
        return Collections.unmodifiableList(this.m_aContentList);
    }

    @Nonnull
    protected final <T extends IJObject> T internalInsert(@Nonnull T t) {
        return this.internalInsertAt(this.m_nPos, t);
    }

    @Nonnull
    protected final <T extends IJObject> T internalInsertAt(int n, @Nonnull T t) {
        JCValueEnforcer.isGE0(n, "Index");
        JCValueEnforcer.notNull(t, "StatementOrDeclaration");
        this.m_aContentList.add(n, t);
        ++this.m_nPos;
        if (t instanceof JVar) {
            this.m_bBracesRequired = true;
            this.m_bIndentRequired = true;
        }
        return t;
    }

    public void remove(IJObject iJObject) {
        this.m_aContentList.remove(iJObject);
    }

    public void remove(@Nonnegative int n) {
        this.m_aContentList.remove(n);
    }

    public void removeAll() {
        this.m_aContentList.clear();
        this.m_nPos = 0;
    }

    @Nonnegative
    public int pos() {
        return this.m_nPos;
    }

    @Nonnegative
    public int pos(@Nonnegative int n) {
        JCValueEnforcer.isTrue(n >= 0 && n <= this.m_aContentList.size(), () -> "Illegal position provided: " + n);
        int n2 = this.m_nPos;
        this.m_nPos = n;
        return n2;
    }

    public boolean isEmpty() {
        return this.m_aContentList.isEmpty();
    }

    @Nonnegative
    public int size() {
        return this.m_aContentList.size();
    }

    @Nonnull
    public JVar decl(@Nonnull AbstractJType abstractJType, @Nonnull String string) {
        return this.decl(0, abstractJType, string, null);
    }

    @Nonnull
    public JVar decl(int n, @Nonnull AbstractJType abstractJType, @Nonnull String string) {
        return this.decl(n, abstractJType, string, null);
    }

    @Nonnull
    public JVar decl(@Nonnull AbstractJType abstractJType, @Nonnull String string, @Nullable IJExpression iJExpression) {
        return this.decl(0, abstractJType, string, iJExpression);
    }

    @Nonnull
    public JVar decl(int n, @Nonnull AbstractJType abstractJType, @Nonnull String string, @Nullable IJExpression iJExpression) {
        JVar jVar = new JVar(JMods.forVar(n), abstractJType, string, iJExpression);
        this.internalInsert(jVar);
        return jVar;
    }

    @Nonnull
    public JBlock insertBefore(@Nonnull JVar jVar, @Nonnull Object object) {
        int n = this.m_aContentList.indexOf(object);
        this.internalInsertAt(n, jVar);
        return this;
    }

    @Nonnull
    public JBlock assign(@Nonnull IJAssignmentTarget iJAssignmentTarget, @Nonnull IJExpression iJExpression) {
        this.internalInsert(JExpr.assign(iJAssignmentTarget, iJExpression));
        return this;
    }

    @Nonnull
    public JBlock assignPlus(@Nonnull IJAssignmentTarget iJAssignmentTarget, @Nonnull IJExpression iJExpression) {
        this.internalInsert(JExpr.assignPlus(iJAssignmentTarget, iJExpression));
        return this;
    }

    @Nonnull
    public JBlock assignMinus(@Nonnull IJAssignmentTarget iJAssignmentTarget, @Nonnull IJExpression iJExpression) {
        this.internalInsert(JExpr.assignMinus(iJAssignmentTarget, iJExpression));
        return this;
    }

    @Nonnull
    public JBlock assignTimes(@Nonnull IJAssignmentTarget iJAssignmentTarget, @Nonnull IJExpression iJExpression) {
        this.internalInsert(JExpr.assignTimes(iJAssignmentTarget, iJExpression));
        return this;
    }

    @Nonnull
    public JBlock assignDivide(@Nonnull IJAssignmentTarget iJAssignmentTarget, @Nonnull IJExpression iJExpression) {
        this.internalInsert(JExpr.assignDivide(iJAssignmentTarget, iJExpression));
        return this;
    }

    @Nonnull
    public JInvocation invoke(@Nonnull IJExpression iJExpression, @Nonnull String string) {
        return this.internalInsert(new JInvocation(iJExpression, string));
    }

    @Nonnull
    public JInvocation invokeThis(@Nonnull String string) {
        return this.invoke((IJExpression)JExpr._this(), string);
    }

    @Nonnull
    public JInvocation invoke(@Nonnull IJExpression iJExpression, @Nonnull JMethod jMethod) {
        return this.internalInsert(new JInvocation(iJExpression, jMethod));
    }

    @Nonnull
    public JInvocation invokeThis(@Nonnull JMethod jMethod) {
        return this.invoke((IJExpression)JExpr._this(), jMethod);
    }

    @Nonnull
    public JInvocation staticInvoke(@Nonnull AbstractJClass abstractJClass, @Nonnull String string) {
        return this.internalInsert(new JInvocation(abstractJClass, string));
    }

    @Nonnull
    public JInvocation invoke(@Nonnull String string) {
        return this.internalInsert(new JInvocation((IJExpression)null, string));
    }

    @Nonnull
    public JInvocation invoke(@Nonnull JMethod jMethod) {
        return this.internalInsert(new JInvocation((IJExpression)null, jMethod));
    }

    @Nonnull
    public JInvocation _new(@Nonnull AbstractJClass abstractJClass) {
        return this.internalInsert(new JInvocation(abstractJClass));
    }

    @Nonnull
    public JInvocation _new(@Nonnull AbstractJType abstractJType) {
        return this.internalInsert(new JInvocation(abstractJType));
    }

    @Nonnull
    public JBlock add(@Nonnull IJStatement iJStatement) {
        this.internalInsert(iJStatement);
        return this;
    }

    @Nonnull
    public JBlock addSingleLineComment() {
        return this.addSingleLineComment("");
    }

    @Nonnull
    public JBlock addSingleLineComment(@Nullable String string) {
        if (string != null) {
            this.internalInsert(new JSingleLineCommentStatement(string));
        }
        return this;
    }

    @Nonnull
    public JConditional _if(@Nonnull IJExpression iJExpression) {
        return this.internalInsert(new JConditional(iJExpression));
    }

    @Nonnull
    public JConditional _if(@Nonnull IJExpression iJExpression, @Nonnull IJStatement iJStatement) {
        JConditional jConditional = new JConditional(iJExpression);
        jConditional._then().add(iJStatement);
        return this.internalInsert(jConditional);
    }

    @Nonnull
    public JConditional _if(@Nonnull IJExpression iJExpression, @Nonnull IJStatement iJStatement, @Nonnull IJStatement iJStatement2) {
        JConditional jConditional = new JConditional(iJExpression);
        jConditional._then().add(iJStatement);
        jConditional._else().add(iJStatement2);
        return this.internalInsert(jConditional);
    }

    @Nonnull
    public JForLoop _for() {
        return this.internalInsert(new JForLoop());
    }

    @Nonnull
    public JWhileLoop _while(@Nonnull IJExpression iJExpression) {
        return this.internalInsert(new JWhileLoop(iJExpression));
    }

    @Nonnull
    public JSwitch _switch(@Nonnull IJExpression iJExpression) {
        return this.internalInsert(new JSwitch(iJExpression));
    }

    @Nonnull
    public JDoLoop _do(@Nonnull IJExpression iJExpression) {
        return this.internalInsert(new JDoLoop(iJExpression));
    }

    @Nonnull
    public JTryBlock _try() {
        return this.internalInsert(new JTryBlock());
    }

    @Nonnull
    public JReturn _return() {
        return this.internalInsert(new JReturn(null));
    }

    @Nonnull
    public JReturn _return(@Nullable IJExpression iJExpression) {
        return this.internalInsert(new JReturn(iJExpression));
    }

    @Nonnull
    public JThrow _throw(@Nonnull IJExpression iJExpression) {
        return this.internalInsert(new JThrow(iJExpression));
    }

    @Nonnull
    public JBreak _break() {
        return this._break(null);
    }

    @Nonnull
    public JBreak _break(@Nullable JLabel jLabel) {
        return this.internalInsert(new JBreak(jLabel));
    }

    @Nonnull
    public JLabel label(@Nonnull String string) {
        JLabel jLabel = new JLabel(string);
        this.internalInsert(jLabel);
        return jLabel;
    }

    @Nonnull
    public JContinue _continue() {
        return this._continue(null);
    }

    @Nonnull
    public JContinue _continue(@Nullable JLabel jLabel) {
        return this.internalInsert(new JContinue(jLabel));
    }

    @Nonnull
    public JBlock block() {
        return this.internalInsert(new JBlock());
    }

    @Nonnull
    public JBlock blockSimple() {
        return this.block(false, false);
    }

    @Nonnull
    public JBlock blockVirtual() {
        return this.blockSimple().virtual(true);
    }

    @Nonnull
    public JBlock block(boolean bl, boolean bl2) {
        return this.internalInsert(new JBlock().bracesRequired(bl).indentRequired(bl2));
    }

    @Nonnull
    public JForEach forEach(@Nonnull AbstractJType abstractJType, @Nonnull String string, @Nonnull IJExpression iJExpression) {
        return this.internalInsert(new JForEach(abstractJType, string, iJExpression));
    }

    @Nonnull
    public JSynchronizedBlock synchronizedBlock(@Nonnull IJExpression iJExpression) {
        return this.internalInsert(new JSynchronizedBlock(iJExpression));
    }

    @Nonnull
    public IJStatement directStatement(@Nonnull String string) {
        JDirectStatement jDirectStatement = new JDirectStatement(string);
        this.add(jDirectStatement);
        return jDirectStatement;
    }

    @Override
    public void generate(@Nonnull JFormatter jFormatter) {
        if (this.m_bVirtualBlock) {
            this.generateBody(jFormatter);
        } else {
            if (this.m_bBracesRequired) {
                jFormatter.print('{');
                jFormatter.newline();
            }
            if (this.m_bIndentRequired) {
                jFormatter.indent();
            }
            this.generateBody(jFormatter);
            if (this.m_bIndentRequired) {
                jFormatter.outdent();
            }
            if (this.m_bBracesRequired) {
                jFormatter.print('}');
            }
        }
    }

    protected void generateBody(@Nonnull JFormatter jFormatter) {
        for (IJObject iJObject : this.m_aContentList) {
            if (iJObject instanceof IJDeclaration) {
                jFormatter.declaration((IJDeclaration)iJObject);
                continue;
            }
            if (iJObject instanceof IJStatement) {
                jFormatter.statement((IJStatement)iJObject);
                continue;
            }
            jFormatter.generable((IJGenerable)iJObject);
        }
    }

    @Override
    public void state(@Nonnull JFormatter jFormatter) {
        jFormatter.generable(this);
        if (this.m_bBracesRequired) {
            jFormatter.newline();
        }
    }
}

