/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import com.helger.jcodemodel.util.JCValueEnforcer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JLambdaMethodRef
implements IJExpression {
    private final JMethod m_aMethod;
    private final AbstractJType m_aType;
    private final JVar m_aVar;
    private final String m_sMethodName;

    public JLambdaMethodRef(@Nonnull JMethod jMethod) {
        JCValueEnforcer.notNull(jMethod, "Method");
        JCValueEnforcer.isTrue(jMethod.mods().isStatic(), "Only static methods can be used with this constructor. Use the constructor with JVar for instance methods.");
        this.m_aMethod = jMethod;
        this.m_aType = null;
        this.m_aVar = null;
        this.m_sMethodName = null;
    }

    public JLambdaMethodRef(@Nonnull AbstractJType abstractJType) {
        this(abstractJType, "new");
    }

    public JLambdaMethodRef(@Nonnull AbstractJType abstractJType, @Nonnull String string) {
        this.m_aMethod = null;
        this.m_aType = JCValueEnforcer.notNull(abstractJType, "Type");
        this.m_aVar = null;
        this.m_sMethodName = JCValueEnforcer.notEmpty(string, "Method");
    }

    public JLambdaMethodRef(@Nonnull JVar jVar, @Nonnull String string) {
        JCValueEnforcer.notNull(jVar, "Var");
        JCValueEnforcer.notEmpty(string, "Method");
        this.m_aMethod = null;
        this.m_aType = null;
        this.m_aVar = jVar;
        this.m_sMethodName = string;
    }

    public JLambdaMethodRef(@Nonnull JVar jVar, @Nonnull JMethod jMethod) {
        JCValueEnforcer.notNull(jVar, "Var");
        JCValueEnforcer.notNull(jMethod, "Method");
        JCValueEnforcer.isFalse(jMethod.mods().isStatic(), "Only instance methods can be used with this constructor. Use the constructor with JMethod only for static methods.");
        this.m_aMethod = jMethod;
        this.m_aType = null;
        this.m_aVar = jVar;
        this.m_sMethodName = null;
    }

    public boolean isStaticRef() {
        if (this.m_aMethod != null) {
            return this.m_aMethod.mods().isStatic();
        }
        return this.m_aType != null;
    }

    @Nullable
    public JMethod method() {
        return this.m_aMethod;
    }

    @Nonnull
    public AbstractJType type() {
        if (this.m_aVar != null) {
            return this.m_aVar.type();
        }
        if (this.m_aMethod != null) {
            return this.m_aMethod.owningClass();
        }
        return this.m_aType;
    }

    @Nullable
    public JVar var() {
        return this.m_aVar;
    }

    @Nonnull
    public String methodName() {
        return this.m_aMethod != null ? this.m_aMethod.name() : this.m_sMethodName;
    }

    @Override
    public void generate(@Nonnull JFormatter jFormatter) {
        if (this.isStaticRef()) {
            jFormatter.type(this.type());
        } else {
            jFormatter.generable(this.m_aVar);
        }
        jFormatter.print("::").print(this.methodName());
    }
}

