/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJGenerable;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.util.JCEqualsHelper;
import com.helger.jcodemodel.util.JCHashCodeGenerator;
import com.helger.jcodemodel.util.JCValueEnforcer;
import javax.annotation.Nonnull;

public class JOpBinary
implements IJExpression {
    private final IJExpression m_aLeft;
    private final String m_sOperator;
    private final IJGenerable m_aRight;

    protected JOpBinary(@Nonnull IJExpression iJExpression, @Nonnull String string, @Nonnull IJGenerable iJGenerable) {
        this.m_aLeft = JCValueEnforcer.notNull(iJExpression, "Left");
        this.m_sOperator = JCValueEnforcer.notNull(string, "Operator");
        this.m_aRight = JCValueEnforcer.notNull(iJGenerable, "Right");
    }

    @Nonnull
    public IJExpression left() {
        return this.m_aLeft;
    }

    @Nonnull
    public String op() {
        return this.m_sOperator;
    }

    @Nonnull
    public IJGenerable right() {
        return this.m_aRight;
    }

    @Override
    public void generate(@Nonnull JFormatter jFormatter) {
        jFormatter.print('(').generable(this.m_aLeft).print(this.m_sOperator).generable(this.m_aRight).print(')');
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JOpBinary jOpBinary = (JOpBinary)object;
        return JCEqualsHelper.isEqual(this.m_aLeft, jOpBinary.m_aLeft) && JCEqualsHelper.isEqual(this.m_sOperator, jOpBinary.m_sOperator) && JCEqualsHelper.isEqual(this.m_aRight, jOpBinary.m_aRight);
    }

    public int hashCode() {
        return JCHashCodeGenerator.getHashCode(this, this.m_aLeft, this.m_sOperator, this.m_aRight);
    }
}

