/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.BitSet;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class UnicodeEscapeWriter
extends FilterWriter {
    private static final BitSet ESCAPE = new BitSet(128);

    public UnicodeEscapeWriter(@Nonnull Writer writer) {
        super(writer);
    }

    @Override
    public final void write(int n) throws IOException {
        if (this.requireEscaping(n)) {
            this.out.write("\\u");
            String string = Integer.toHexString(n);
            for (int i = string.length(); i < 4; ++i) {
                this.out.write(48);
            }
            this.out.write(string);
        } else {
            this.out.write(n);
        }
    }

    protected boolean requireEscaping(int n) {
        return n >= 128 || ESCAPE.get(n);
    }

    @Override
    public final void write(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.write(cArray[n + i]);
        }
    }

    @Override
    public final void write(@Nonnull char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    @Override
    public final void write(@Nonnull String string, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        this.write(string.toCharArray(), n, n2);
    }

    @Override
    public final void write(@Nonnull String string) throws IOException {
        this.write(string.toCharArray(), 0, string.length());
    }

    static {
        for (int i = 0; i < 32; ++i) {
            if (i == 9 || i == 13 || i == 10) continue;
            ESCAPE.set(i, true);
        }
    }
}

