/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.IJFormatter;
import com.helger.jcodemodel.IJGenerifiable;
import com.helger.jcodemodel.JTypeVar;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public abstract class AbstractJGenerifiableImpl
implements IJGenerifiable {
    private Map<String, JTypeVar> m_aTypeVariables;

    @Override
    public void declare(@Nonnull IJFormatter iJFormatter) {
        if (this.m_aTypeVariables != null && !this.m_aTypeVariables.isEmpty()) {
            iJFormatter.print('<');
            int n = 0;
            for (JTypeVar jTypeVar : this.m_aTypeVariables.values()) {
                if (n++ > 0) {
                    iJFormatter.print(',');
                }
                iJFormatter.declaration(jTypeVar);
            }
            iJFormatter.printCloseTypeArgs();
        }
    }

    @Override
    @Nonnull
    public JTypeVar generify(@Nonnull String string) {
        JTypeVar jTypeVar = new JTypeVar(this.owner(), string);
        if (this.m_aTypeVariables == null) {
            this.m_aTypeVariables = new LinkedHashMap<String, JTypeVar>(3);
        } else if (this.m_aTypeVariables.containsKey(string)) {
            throw new IllegalArgumentException("A type parameter with name '" + string + "' is already present!");
        }
        this.m_aTypeVariables.put(string, jTypeVar);
        return jTypeVar;
    }

    @Override
    @Nonnull
    public JTypeVar[] typeParams() {
        if (this.m_aTypeVariables == null) {
            return AbstractJClass.EMPTY_ARRAY;
        }
        return this.m_aTypeVariables.values().toArray(new JTypeVar[this.m_aTypeVariables.size()]);
    }
}

